/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors.undertow;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.comsat.webactors.Cookie;
import co.paralleluniverse.comsat.webactors.HttpRequest;
import co.paralleluniverse.comsat.webactors.HttpResponse;
import co.paralleluniverse.comsat.webactors.WebMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

final class HttpRequestWrapper
extends HttpRequest {
    final ActorRef<? super HttpResponse> actorRef;
    final HttpServerExchange xch;
    private final ByteBuffer reqContent;
    private ImmutableMultimap<String, String> params;
    private URI uri;
    private Collection<Cookie> cookies;
    private ListMultimap<String, String> heads;
    private ByteBuffer byteBufferBody;
    private String stringBody;
    private String contentType;
    private Charset encoding;

    public HttpRequestWrapper(ActorRef<? super HttpResponse> actorRef, HttpServerExchange xch, ByteBuffer reqContent) {
        this.actorRef = actorRef;
        this.xch = xch;
        this.reqContent = reqContent;
    }

    static ImmutableListMultimap<String, String> extractHeaders(HeaderMap headers) {
        if (headers != null) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (HttpString n : headers.getHeaderNames()) {
                builder.putAll((Object)n.toString(), (Iterable)headers.get(n));
            }
            return builder.build();
        }
        return null;
    }

    public Multimap<String, String> getParameters() {
        if (this.params == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            Map parameters = this.xch.getQueryParameters();
            for (String k : parameters.keySet()) {
                builder.putAll((Object)k, (Iterable)parameters.get(k));
            }
            this.params = builder.build();
        }
        return this.params;
    }

    public Map<String, Object> getAttributes() {
        return null;
    }

    public String getScheme() {
        this.initUri();
        return this.uri.getScheme();
    }

    private void initUri() {
        if (this.uri == null) {
            try {
                this.uri = new URI(this.xch.getRequestURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getMethod() {
        return this.xch.getRequestMethod().toString();
    }

    public String getPathInfo() {
        this.initUri();
        return this.uri.getPath();
    }

    public String getContextPath() {
        return "/";
    }

    public String getQueryString() {
        this.initUri();
        return this.uri.getQuery();
    }

    public String getRequestURI() {
        return this.xch.getRequestURI();
    }

    public String getServerName() {
        return this.xch.getHostName();
    }

    public int getServerPort() {
        return this.xch.getHostPort();
    }

    public ActorRef<WebMessage> getFrom() {
        return this.actorRef;
    }

    public ListMultimap<String, String> getHeaders() {
        if (this.heads == null) {
            this.heads = HttpRequestWrapper.extractHeaders(this.xch.getRequestHeaders());
        }
        return this.heads;
    }

    public Collection<Cookie> getCookies() {
        if (this.cookies == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (io.undertow.server.handlers.Cookie c : this.xch.getRequestCookies().values()) {
                builder.add((Object)Cookie.cookie((String)c.getName(), (String)c.getValue()).setComment(c.getComment()).setDomain(c.getDomain()).setPath(c.getPath()).setHttpOnly(c.isHttpOnly()).setMaxAge(c.getMaxAge().intValue()).setSecure(c.isSecure()).setVersion(c.getVersion()).build());
            }
            this.cookies = builder.build();
        }
        return this.cookies;
    }

    public int getContentLength() {
        return (int)this.xch.getRequestContentLength();
    }

    public Charset getCharacterEncoding() {
        if (this.encoding == null) {
            String charsetName = this.xch.getRequestCharset();
            if (charsetName != null) {
                try {
                    this.encoding = Charset.forName(charsetName);
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    // empty catch block
                }
            }
            if (this.encoding == null) {
                this.encoding = Charset.defaultCharset();
            }
        }
        return this.encoding;
    }

    public String getContentType() {
        List cts;
        this.getHeaders();
        if (this.heads != null && this.contentType == null && (cts = this.heads.get((Object)"Content-Type")) != null && cts.size() > 0) {
            this.contentType = (String)cts.get(0);
        }
        return null;
    }

    public String getStringBody() {
        if (this.stringBody == null) {
            if (this.byteBufferBody != null) {
                return null;
            }
            this.decodeStringBody();
        }
        return this.stringBody;
    }

    public ByteBuffer getByteBufferBody() {
        if (this.byteBufferBody == null) {
            if (this.stringBody != null) {
                return null;
            }
            if (this.reqContent != null) {
                this.byteBufferBody = this.reqContent;
            }
        }
        return this.byteBufferBody;
    }

    private String decodeStringBody() {
        if (this.reqContent != null) {
            try {
                this.stringBody = this.getCharacterEncoding().newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(this.reqContent).toString();
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
        }
        return this.stringBody;
    }
}

