/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors.undertow;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;

public abstract class ByteArrayReadChannelListener
implements ChannelListener<StreamSourceChannel> {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private ByteBufferPool bufferPool;

    public ByteArrayReadChannelListener(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    public final void setup(StreamSourceChannel c) {
        this.partialRead(c, true);
    }

    public final void handleEvent(StreamSourceChannel c) {
        this.partialRead(c, false);
    }

    protected abstract void byteArrayDone(byte[] var1);

    protected abstract void error(IOException var1);

    private void partialRead(StreamSourceChannel c, boolean setup) {
        if (this.baos == null || this.bufferPool == null) {
            return;
        }
        try (PooledByteBuffer r = null;){
            int readCount;
            r = this.bufferPool.allocate();
            ByteBuffer b = r.getBuffer();
            do {
                if ((readCount = c.read(b)) == 0) {
                    if (!setup) {
                        return;
                    }
                    c.getReadSetter().set((ChannelListener)this);
                    c.resumeReads();
                    continue;
                }
                if (readCount == -1) {
                    byte[] result = this.baos.toByteArray();
                    this.cleanup(c);
                    this.byteArrayDone(result);
                    continue;
                }
                b.flip();
                while (b.hasRemaining()) {
                    this.baos.write(b.get());
                }
            } while (readCount > 0);
        }
    }

    private void cleanup(StreamSourceChannel c) {
        this.baos = null;
        this.bufferPool = null;
        c.getReadSetter().set(null);
        IoUtils.safeClose((Closeable)c);
    }
}

