/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors.undertow;

import co.paralleluniverse.actors.Actor;
import co.paralleluniverse.actors.ActorImpl;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.ActorSpec;
import co.paralleluniverse.common.reflection.AnnotationUtil;
import co.paralleluniverse.common.reflection.ClassLoaderUtil;
import co.paralleluniverse.common.util.Pair;
import co.paralleluniverse.comsat.webactors.WebActor;
import co.paralleluniverse.comsat.webactors.WebMessage;
import co.paralleluniverse.comsat.webactors.undertow.WebActorHandler;
import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.util.Sessions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class AutoWebActorHandler
extends WebActorHandler {
    private static final List<Class<?>> actorClasses = new ArrayList(4);
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public AutoWebActorHandler() {
        this(null, null);
    }

    public AutoWebActorHandler(ClassLoader userClassLoader) {
        this(userClassLoader, null);
    }

    public AutoWebActorHandler(Map<Class<?>, Object[]> actorParams) {
        this(null, actorParams);
    }

    public AutoWebActorHandler(ClassLoader userClassLoader, Map<Class<?>, Object[]> actorParams) {
        super(new AutoContextProvider(actorParams, userClassLoader));
    }

    private static class AutoContextProvider
    implements WebActorHandler.ContextProvider {
        private final Map<Class<?>, Object[]> actorParams;
        private final ClassLoader userClassLoader;

        public AutoContextProvider(Map<Class<?>, Object[]> actorParams, ClassLoader userClassLoader) {
            this.actorParams = actorParams;
            this.userClassLoader = userClassLoader;
        }

        @Override
        public final WebActorHandler.Context get(HttpServerExchange xch) {
            WebActorHandler.Context context;
            Session session = null;
            try {
                session = Sessions.getOrCreateSession((HttpServerExchange)xch);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (session != null) {
                context = (WebActorHandler.Context)session.getAttribute("co.paralleluniverse.comsat.webactors.sessionActor");
                if (context == null || !context.isValid()) {
                    context = this.newContext(xch);
                    session.setAttribute("co.paralleluniverse.comsat.webactors.sessionActor", (Object)context);
                }
            } else {
                context = this.newContext(xch);
            }
            return context;
        }

        private WebActorHandler.Context newContext(HttpServerExchange xch) {
            return new AutoActorContext(xch, this.actorParams, this.userClassLoader);
        }
    }

    private static final class AutoActorContext
    extends WebActorHandler.DefaultContextImpl {
        private final Map<Class<?>, Object[]> actorParams;
        private final ClassLoader userClassLoader;
        private Class<? extends ActorImpl<? extends WebMessage>> actorClass;
        private ActorRef<? extends WebMessage> actorRef;

        public AutoActorContext(HttpServerExchange xch, Map<Class<?>, Object[]> actorParams, ClassLoader userClassLoader) {
            this.actorParams = actorParams;
            this.userClassLoader = userClassLoader;
            Pair<ActorRef<? extends WebMessage>, Class<? extends ActorImpl<? extends WebMessage>>> p = this.autoCreateActor(xch);
            if (p != null) {
                this.actorRef = (ActorRef)p.getFirst();
                this.actorClass = (Class)p.getSecond();
            }
        }

        @Override
        public final ActorRef<? extends WebMessage> getRef() {
            return this.actorRef;
        }

        @Override
        public final boolean handlesWithWebSocket(String uri) {
            return WebActorHandler.handlesWithWebSocket(uri, this.actorClass);
        }

        @Override
        public final boolean handlesWithHttp(String uri) {
            return WebActorHandler.handlesWithHttp(uri, this.actorClass);
        }

        private Pair<ActorRef<? extends WebMessage>, Class<? extends ActorImpl<? extends WebMessage>>> autoCreateActor(HttpServerExchange xch) {
            this.registerActorClasses();
            String uri = xch.getRequestURI();
            for (Class c : actorClasses) {
                if (!WebActorHandler.handlesWithHttp(uri, c) && !WebActorHandler.handlesWithWebSocket(uri, c)) continue;
                return new Pair((Object)Actor.newActor((ActorSpec)new ActorSpec(c, this.actorParams != null ? this.actorParams.get(c) : EMPTY_OBJECT_ARRAY)).spawn(), (Object)c);
            }
            return null;
        }

        private synchronized void registerActorClasses() {
            if (actorClasses.isEmpty()) {
                try {
                    ClassLoader classLoader = this.userClassLoader != null ? this.userClassLoader : this.getClass().getClassLoader();
                    ClassLoaderUtil.accept((URLClassLoader)((URLClassLoader)classLoader), (ClassLoaderUtil.Visitor)new ClassLoaderUtil.Visitor(){

                        public final void visit(String resource, URL url, ClassLoader cl) {
                            if (!ClassLoaderUtil.isClassFile((String)resource)) {
                                return;
                            }
                            String className = ClassLoaderUtil.resourceToClass((String)resource);
                            try (InputStream is = cl.getResourceAsStream(resource);){
                                if (AnnotationUtil.hasClassAnnotation(WebActor.class, (InputStream)is)) {
                                    this.registerWebActor(cl.loadClass(className));
                                }
                            }
                            catch (IOException | ClassNotFoundException e) {
                                UndertowLogger.ROOT_LOGGER.error((Object)("Exception while scanning class " + className + " for WebActor annotation"), (Throwable)e);
                                throw new RuntimeException(e);
                            }
                        }

                        private void registerWebActor(Class<?> c) {
                            actorClasses.add(c);
                        }
                    });
                }
                catch (IOException e) {
                    UndertowLogger.ROOT_LOGGER.error((Object)"IOException while scanning classes for WebActor annotation", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

