/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors.netty;

import co.paralleluniverse.actors.ActorImpl;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.ExitMessage;
import co.paralleluniverse.actors.FakeActor;
import co.paralleluniverse.actors.LifecycleMessage;
import co.paralleluniverse.actors.ShutdownMessage;
import co.paralleluniverse.common.util.Pair;
import co.paralleluniverse.common.util.SystemProperties;
import co.paralleluniverse.comsat.webactors.Cookie;
import co.paralleluniverse.comsat.webactors.HttpRequest;
import co.paralleluniverse.comsat.webactors.HttpResponse;
import co.paralleluniverse.comsat.webactors.HttpStreamOpened;
import co.paralleluniverse.comsat.webactors.WebActor;
import co.paralleluniverse.comsat.webactors.WebDataMessage;
import co.paralleluniverse.comsat.webactors.WebMessage;
import co.paralleluniverse.comsat.webactors.WebSocketOpened;
import co.paralleluniverse.comsat.webactors.netty.AutoWebActorHandler;
import co.paralleluniverse.comsat.webactors.netty.HttpRequestWrapper;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.strands.Timeout;
import co.paralleluniverse.strands.channels.SendPort;
import co.paralleluniverse.strands.concurrent.CountDownLatch;
import co.paralleluniverse.strands.concurrent.ReentrantLock;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class WebActorHandler
extends SimpleChannelInboundHandler<Object> {
    protected static final ScheduledExecutorService ts = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    protected static final String SESSION_COOKIE_KEY = "JSESSIONID";
    protected static final String TRACK_SESSION_PROP = HttpChannelAdapter.class.getName() + ".trackSession";
    protected static final String trackSession = System.getProperty(TRACK_SESSION_PROP, "sse");
    protected static final String OMIT_DATE_HEADER_PROP = HttpChannelAdapter.class.getName() + ".omitDateHeader";
    protected static final Boolean omitDateHeader = SystemProperties.isEmptyOrTrue((String)OMIT_DATE_HEADER_PROP);
    protected static final ConcurrentHashMap<String, Context> sessions = new ConcurrentHashMap();
    protected static final ReentrantLock sessionsLock = new ReentrantLock();
    protected WebActorContextProvider contextProvider;
    protected String httpResponseEncoderName;
    private static final String ACTOR_KEY = "co.paralleluniverse.comsat.webactors.sessionActor";
    private static final WeakHashMap<Class<?>, List<Pair<String, String>>> classToUrlPatterns = new WeakHashMap();
    private static final InternalLogger log = InternalLoggerFactory.getInstance(AutoWebActorHandler.class);
    private WebSocketServerHandshaker handshaker;
    private WebSocketActorAdapter webSocketActor;

    public WebActorHandler(WebActorContextProvider contextProvider) {
        this(contextProvider, null);
    }

    public WebActorHandler(WebActorContextProvider contextProvider, String httpResponseEncoderName) {
        this.contextProvider = contextProvider;
        this.httpResponseEncoderName = httpResponseEncoderName;
    }

    public final void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ctx.channel().isOpen()) {
            ctx.close();
        }
        log.error("Exception caught", cause);
    }

    protected final void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else {
            throw new AssertionError((Object)("Unexpected message " + msg));
        }
    }

    protected static boolean sessionsEnabled() {
        return "always".equals(trackSession) || "sse".equals(trackSession);
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (frame instanceof ContinuationWebSocketFrame) {
            return;
        }
        if (frame instanceof TextWebSocketFrame) {
            this.webSocketActor.onMessage(((TextWebSocketFrame)frame).text());
        } else {
            this.webSocketActor.onMessage(frame.content().nioBuffer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) throws SuspendExecution, InterruptedException {
        if (!req.getDecoderResult().isSuccess()) {
            WebActorHandler.sendHttpError(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(req.getProtocolVersion(), HttpResponseStatus.BAD_REQUEST));
            return;
        }
        String uri = req.getUri();
        Context actorCtx = this.contextProvider.get(req);
        assert (actorCtx != null);
        String sessionId = actorCtx.getId();
        assert (sessionId != null);
        ReentrantLock lock = actorCtx.getLock();
        assert (lock != null);
        lock.lock();
        try {
            ActorRef<? extends WebMessage> userActorRef = actorCtx.getWebActor();
            Object internalActor = (ActorImpl)actorCtx.getAttachments().get(ACTOR_KEY);
            if (userActorRef != null) {
                if (actorCtx.handlesWithWebSocket(uri)) {
                    if (internalActor == null || !(internalActor instanceof WebSocketActorAdapter)) {
                        this.webSocketActor = new WebSocketActorAdapter(ctx, userActorRef);
                        WebActorHandler.addActorToContextAndUnlock(actorCtx, (ActorImpl)this.webSocketActor, lock);
                    }
                    WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(uri, null, true);
                    this.handshaker = wsFactory.newHandshaker((io.netty.handler.codec.http.HttpRequest)req);
                    if (this.handshaker == null) {
                        WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
                    } else {
                        final ActorRef<? super WebMessage> userActorRef0 = this.webSocketActor.userActor;
                        this.handshaker.handshake(ctx.channel(), req).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                            @Suspendable
                            public void operationComplete(ChannelFuture future) throws Exception {
                                userActorRef0.send((Object)new WebSocketOpened(WebActorHandler.this.webSocketActor.ref()));
                            }
                        });
                    }
                    return;
                }
                if (actorCtx.handlesWithHttp(uri)) {
                    if (internalActor == null || !(internalActor instanceof HttpActorAdapter)) {
                        internalActor = new HttpActorAdapter(userActorRef, actorCtx, this.httpResponseEncoderName);
                        WebActorHandler.addActorToContextAndUnlock(actorCtx, internalActor, lock);
                    }
                    ((HttpActorAdapter)((Object)internalActor)).handleRequest(new HttpRequestWrapper((ActorRef<? super HttpResponse>)internalActor.ref(), ctx, req, sessionId));
                    return;
                }
            }
        }
        finally {
            if (lock.isHeldByCurrentStrand() && lock.isLocked()) {
                lock.unlock();
            }
        }
        WebActorHandler.sendHttpError(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(req.getProtocolVersion(), HttpResponseStatus.NOT_FOUND));
    }

    static void addActorToContextAndUnlock(Context actorContext, ActorImpl actor, ReentrantLock lock) {
        try {
            actorContext.getAttachments().put(ACTOR_KEY, actor);
        }
        finally {
            if (lock.isLocked() && lock.isHeldByCurrentStrand()) {
                lock.unlock();
            }
        }
    }

    protected static boolean trackSession(boolean sseStarted) {
        return trackSession != null && ("always".equals(trackSession) || sseStarted && "sse".equals(trackSession));
    }

    protected static boolean handlesWithHttp(String uri, Class<?> actorClass) {
        return WebActorHandler.match(uri, actorClass).equals("websocket");
    }

    protected static boolean handlesWithWebSocket(String uri, Class<?> actorClass) {
        return WebActorHandler.match(uri, actorClass).equals("ws");
    }

    static void startSession(String sessionId, Context actorContext) throws SuspendExecution, InterruptedException {
        sessionsLock.lock();
        try {
            WebActorHandler.cleanSessions();
            sessions.put(sessionId, actorContext);
        }
        finally {
            sessionsLock.unlock();
        }
    }

    private static void cleanSessions() throws SuspendExecution, InterruptedException {
        ArrayList<String> toBeRemoved = new ArrayList<String>(1024);
        for (Map.Entry<String, Context> e : sessions.entrySet()) {
            if (e.getValue().isValid()) continue;
            toBeRemoved.add(e.getKey());
        }
        for (String s : toBeRemoved) {
            sessions.remove(s);
        }
    }

    static io.netty.handler.codec.http.cookie.Cookie getNettyCookie(Cookie c) {
        DefaultCookie ret = new DefaultCookie(c.getName(), c.getValue());
        ret.setDomain(c.getDomain());
        ret.setHttpOnly(c.isHttpOnly());
        ret.setMaxAge((long)c.getMaxAge());
        ret.setPath(c.getPath());
        ret.setSecure(c.isSecure());
        return ret;
    }

    static void sendHttpRedirect(ChannelHandlerContext ctx, FullHttpRequest req, String newUri) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(req.getProtocolVersion(), HttpResponseStatus.FOUND);
        HttpHeaders.setHeader((HttpMessage)res, (String)"Location", (Object)newUri);
        WebActorHandler.writeHttpResponse(ctx, req, (FullHttpResponse)res, true);
    }

    static void sendHttpError(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
        WebActorHandler.sendHttpResponse(ctx, req, res, true);
    }

    static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
        WebActorHandler.sendHttpResponse(ctx, req, res, false);
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res, boolean close) {
        WebActorHandler.writeHttpResponse(ctx, req, res, close);
    }

    private static void writeHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res, boolean close) {
        if (!omitDateHeader.booleanValue() && !res.headers().contains("Date")) {
            DefaultHttpHeaders.addDateHeader((HttpMessage)res, (String)"Date", (Date)new Date());
        }
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || close) {
            res.headers().set("Connection", (Object)"close");
            ctx.writeAndFlush((Object)res).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            res.headers().set("Connection", (Object)"keep-alive");
            WebActorHandler.write(ctx, res);
        }
    }

    private static ChannelFuture write(ChannelHandlerContext ctx, Object res) {
        return ctx.writeAndFlush(res);
    }

    private static String match(String uri, Class<?> actorClass) {
        if (uri != null && actorClass != null) {
            for (Pair<String, String> e : WebActorHandler.lookupOrInsert(actorClass)) {
                if (!WebActorHandler.servletMatch((String)e.getFirst(), uri)) continue;
                return (String)e.getSecond();
            }
        }
        return "";
    }

    private static List<Pair<String, String>> lookupOrInsert(Class<?> actorClass) {
        if (actorClass != null) {
            List<Pair<String, String>> lookup = classToUrlPatterns.get(actorClass);
            if (lookup != null) {
                return lookup;
            }
            return WebActorHandler.insert(actorClass);
        }
        return null;
    }

    private static List<Pair<String, String>> insert(Class<?> actorClass) {
        if (actorClass != null) {
            WebActor wa = actorClass.getAnnotation(WebActor.class);
            ArrayList<Pair<String, String>> ret = new ArrayList<Pair<String, String>>(4);
            for (String httpP : wa.httpUrlPatterns()) {
                WebActorHandler.addPattern(ret, httpP, "websocket");
            }
            for (String wsP : wa.webSocketUrlPatterns()) {
                WebActorHandler.addPattern(ret, wsP, "ws");
            }
            classToUrlPatterns.put(actorClass, ret);
            return ret;
        }
        return null;
    }

    private static void addPattern(List<Pair<String, String>> ret, String p, String type) {
        if (p != null) {
            Pair entry = new Pair((Object)p, (Object)type);
            if (p.endsWith("*") || p.startsWith("*.") || p.equals("/")) {
                ret.add((Pair<String, String>)entry);
            } else {
                ret.add(0, (Pair<String, String>)entry);
            }
        }
    }

    private static boolean servletMatch(String pattern, String uri) {
        if (pattern != null && uri != null) {
            if (pattern.startsWith("/") && pattern.endsWith("*")) {
                return uri.startsWith(pattern.substring(0, pattern.length() - 1));
            }
            if (pattern.startsWith("*.")) {
                return uri.endsWith(pattern.substring(2));
            }
            if (pattern.isEmpty()) {
                return uri.equals("/");
            }
            return pattern.equals("/") || pattern.equals(uri);
        }
        return false;
    }

    private static final class HttpStreamChannelAdapter
    implements SendPort<WebDataMessage> {
        private final Charset encoding;
        private final ChannelHandlerContext ctx;
        HttpStreamActorAdapter actor;

        public HttpStreamChannelAdapter(ChannelHandlerContext ctx, FullHttpRequest req) {
            this.ctx = ctx;
            this.encoding = HttpRequestWrapper.extractCharacterEncodingOrDefault(req.headers());
        }

        public final void send(WebDataMessage message) throws SuspendExecution, InterruptedException {
            this.trySend(message);
        }

        public final boolean send(WebDataMessage message, long timeout, TimeUnit unit) throws SuspendExecution, InterruptedException {
            this.send(message);
            return true;
        }

        public final boolean send(WebDataMessage message, Timeout timeout) throws SuspendExecution, InterruptedException {
            return this.send(message, timeout.nanosLeft(), TimeUnit.NANOSECONDS);
        }

        public final boolean trySend(WebDataMessage res) {
            ByteBuf buf;
            String stringBody = res.getStringBody();
            if (stringBody != null) {
                byte[] bs = stringBody.getBytes(this.encoding);
                buf = Unpooled.wrappedBuffer((byte[])bs);
            } else {
                buf = Unpooled.wrappedBuffer((ByteBuffer)res.getByteBufferBody());
            }
            this.ctx.writeAndFlush((Object)buf);
            return true;
        }

        public final void close() {
            if (this.ctx.channel().isOpen()) {
                this.ctx.close();
            }
            this.actor.die(null);
        }

        public final void close(Throwable t) {
            this.actor.die(t);
            this.close();
        }
    }

    private static final class HttpStreamActorAdapter
    extends FakeActor<WebDataMessage> {
        private volatile boolean dead;

        public HttpStreamActorAdapter(ChannelHandlerContext ctx, FullHttpRequest req) {
            super(req.toString(), (SendPort)new HttpStreamChannelAdapter(ctx, req));
            ((HttpStreamChannelAdapter)this.getMailbox()).actor = this;
        }

        protected WebDataMessage handleLifecycleMessage(LifecycleMessage m) {
            if (m instanceof ShutdownMessage) {
                this.die(null);
            }
            return null;
        }

        protected void throwIn(RuntimeException e) {
            this.die(e);
        }

        public void interrupt() {
            this.die(new InterruptedException());
        }

        protected void die(Throwable cause) {
            if (this.dead) {
                return;
            }
            this.dead = true;
            this.mailbox().close();
            super.die(cause);
        }

        public String toString() {
            return "HttpStreamActorAdapter{request + " + this.getName() + "}";
        }
    }

    private static final class HttpChannelAdapter
    implements SendPort<HttpResponse> {
        HttpActorAdapter actor;

        private HttpChannelAdapter() {
        }

        @Suspendable
        public final void send(HttpResponse message) throws SuspendExecution, InterruptedException {
            this.trySend(message);
        }

        @Suspendable
        public final boolean send(HttpResponse message, long timeout, TimeUnit unit) throws SuspendExecution, InterruptedException {
            this.send(message);
            return true;
        }

        @Suspendable
        public final boolean send(HttpResponse message, Timeout timeout) throws SuspendExecution, InterruptedException {
            return this.send(message, timeout.nanosLeft(), TimeUnit.NANOSECONDS);
        }

        @Suspendable
        public final boolean trySend(HttpResponse r) {
            try {
                this.actor.handleReply(r);
            }
            catch (SuspendExecution e) {
                throw new AssertionError((Object)e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        @Suspendable
        public final void close() {
            this.actor.die(null);
        }

        @Suspendable
        public final void close(Throwable t) {
            log.error("Exception while closing HTTP adapter", t);
            this.actor.die(t);
        }
    }

    private static final class HttpActorAdapter
    extends FakeActor<HttpResponse> {
        private static final String replyTimeoutProp = System.getProperty(HttpActorAdapter.class.getName() + ".replyTimeout");
        private static final long REPLY_TIMEOUT = replyTimeoutProp != null ? Long.parseLong(replyTimeoutProp) : 120000L;
        private final AtomicReference<CountDownLatch> gate = new AtomicReference();
        private final String httpResponseEncoderName;
        private volatile ActorRef<? super HttpRequest> userActor;
        private volatile Context context;
        private volatile ChannelHandlerContext ctx;
        private volatile FullHttpRequest req;
        private volatile boolean needsRestart;
        private volatile Object watchToken;
        private volatile boolean dead;
        private volatile ScheduledFuture<?> cancelTask;

        HttpActorAdapter(ActorRef<? super HttpRequest> userActor, Context actorContext, String httpResponseEncoderName) {
            super("HttpActorAdapter", (SendPort)new HttpChannelAdapter());
            ((HttpChannelAdapter)this.getMailbox()).actor = this;
            if (actorContext.watch() != Context.WatchPolicy.DONT_WATCH && userActor != null) {
                this.watchToken = this.watch(userActor);
            }
            this.userActor = userActor;
            this.context = actorContext;
            this.httpResponseEncoderName = httpResponseEncoderName;
        }

        public final String toString() {
            return "HttpActorAdapter{" + this.userActor + "}";
        }

        @Suspendable
        protected final HttpResponse handleLifecycleMessage(LifecycleMessage m) {
            this.handleLifecycle(m);
            return null;
        }

        @Suspendable
        protected final void die(Throwable cause) {
            this.handleDie(cause);
        }

        @Suspendable
        protected final void throwIn(RuntimeException e) {
            this.die(e);
        }

        @Suspendable
        protected final void interrupt() {
            this.die(new InterruptedException());
        }

        final boolean handleLifecycle(LifecycleMessage l) {
            ExitMessage em;
            if (l instanceof ExitMessage && (em = (ExitMessage)l).getActor() != null && em.getActor().equals(this.userActor)) {
                this.possiblyReplyDeadAndUnblock(em.getCause());
                Context.WatchPolicy wp = this.context.watch();
                if (wp == Context.WatchPolicy.RESTART || wp == Context.WatchPolicy.DIE_IF_EXCEPTION_ELSE_RESTART && em.getCause() == null) {
                    this.needsRestart = true;
                } else {
                    this.die(em.getCause());
                    return true;
                }
            }
            return false;
        }

        final void handleRequest(HttpRequestWrapper s) throws SuspendExecution, InterruptedException {
            this.blockSessionRequests();
            this.ctx = s.ctx;
            this.req = s.req;
            if (this.needsRestart) {
                this.context.restart(this.req);
                this.context.getLock().lock();
                WebActorHandler.addActorToContextAndUnlock(this.context, (ActorImpl)this, this.context.getLock());
                this.needsRestart = false;
            }
            this.userActor.send((Object)s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Suspendable
        final void handleReply(HttpResponse message) throws SuspendExecution, InterruptedException {
            block24: {
                try {
                    boolean sseStarted;
                    HttpRequestWrapper nettyRequest = (HttpRequestWrapper)message.getRequest();
                    FullHttpRequest req = nettyRequest.req;
                    ChannelHandlerContext ctx = nettyRequest.ctx;
                    String sessionId = nettyRequest.getSessionId();
                    HttpResponseStatus status = HttpResponseStatus.valueOf((int)message.getStatus());
                    if (message.getStatus() >= 400 && message.getStatus() < 600) {
                        WebActorHandler.sendHttpError(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(req.getProtocolVersion(), status));
                        return;
                    }
                    if (message.getRedirectPath() != null) {
                        WebActorHandler.sendHttpRedirect(ctx, req, message.getRedirectPath());
                        return;
                    }
                    DefaultFullHttpResponse res = message.getStringBody() != null ? new DefaultFullHttpResponse(req.getProtocolVersion(), status, Unpooled.wrappedBuffer((byte[])message.getStringBody().getBytes())) : (message.getByteBufferBody() != null ? new DefaultFullHttpResponse(req.getProtocolVersion(), status, Unpooled.wrappedBuffer((ByteBuffer)message.getByteBufferBody())) : new DefaultFullHttpResponse(req.getProtocolVersion(), status));
                    if (message.getCookies() != null) {
                        ServerCookieEncoder enc = ServerCookieEncoder.STRICT;
                        for (Cookie c : message.getCookies()) {
                            HttpHeaders.setHeader((HttpMessage)res, (String)"Cookie", (Object)enc.encode(WebActorHandler.getNettyCookie(c)));
                        }
                    }
                    if (message.getHeaders() != null) {
                        for (Map.Entry h : message.getHeaders().entries()) {
                            HttpHeaders.setHeader((HttpMessage)res, (String)((String)h.getKey()), h.getValue());
                        }
                    }
                    if (message.getContentType() != null) {
                        String ct = message.getContentType();
                        if (message.getCharacterEncoding() != null) {
                            ct = ct + "; charset=" + message.getCharacterEncoding().name();
                        }
                        HttpHeaders.setHeader((HttpMessage)res, (String)"Content-Type", (Object)ct);
                    }
                    if (WebActorHandler.trackSession(sseStarted = message.shouldStartActor())) {
                        res.headers().add("Set-Cookie", (Object)ServerCookieEncoder.STRICT.encode(WebActorHandler.SESSION_COOKIE_KEY, sessionId));
                        WebActorHandler.startSession(sessionId, this.context);
                    }
                    if (!sseStarted) {
                        String stringBody = message.getStringBody();
                        long contentLength = 0L;
                        if (stringBody != null) {
                            contentLength = stringBody.getBytes().length;
                        } else {
                            ByteBuffer byteBufferBody = message.getByteBufferBody();
                            if (byteBufferBody != null) {
                                contentLength = byteBufferBody.remaining();
                            }
                        }
                        res.headers().add("Content-Length", (Object)contentLength);
                    }
                    HttpStreamActorAdapter httpStreamActorAdapter = sseStarted ? new HttpStreamActorAdapter(ctx, req) : null;
                    WebActorHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
                    if (!sseStarted) break block24;
                    if (this.httpResponseEncoderName != null) {
                        ctx.pipeline().remove(this.httpResponseEncoderName);
                    } else {
                        ChannelPipeline pl = ctx.pipeline();
                        ArrayList handlerKeysToBeRemoved = new ArrayList();
                        for (Map.Entry e : pl) {
                            if (!(e.getValue() instanceof HttpResponseEncoder)) continue;
                            handlerKeysToBeRemoved.add(e.getKey());
                        }
                        for (String k : handlerKeysToBeRemoved) {
                            pl.remove(k);
                        }
                    }
                    try {
                        message.getFrom().send((Object)new HttpStreamOpened(httpStreamActorAdapter.ref(), message));
                    }
                    catch (SuspendExecution e) {
                        throw new AssertionError((Object)e);
                    }
                }
                finally {
                    this.unblockSessionRequests();
                }
            }
        }

        @Suspendable
        final void handleDie(Throwable cause) {
            this.possiblyReplyDeadAndUnblock(cause);
            if (this.dead) {
                return;
            }
            this.dead = true;
            HttpActorAdapter.super.die(cause);
            try {
                this.context.invalidate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.userActor != null && this.watchToken != null) {
                this.unwatch(this.userActor, this.watchToken);
            }
            this.userActor = null;
            this.watchToken = null;
            this.context = null;
            this.ctx = null;
            this.req = null;
        }

        private void possiblyReplyDeadAndUnblock(Throwable cause) {
            if (this.isRequestInProgress()) {
                try {
                    if (cause != null) {
                        WebActorHandler.sendHttpError(this.ctx, this.req, (FullHttpResponse)new DefaultFullHttpResponse(this.req.getProtocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.wrappedBuffer((byte[])("Actor is dead because of " + cause.getMessage()).getBytes())));
                    } else {
                        WebActorHandler.sendHttpError(this.ctx, this.req, (FullHttpResponse)new DefaultFullHttpResponse(this.req.getProtocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.wrappedBuffer((byte[])"Actor has terminated.".getBytes())));
                    }
                }
                finally {
                    this.unblockSessionRequests();
                }
            }
        }

        @Suspendable
        private void blockSessionRequests() throws InterruptedException {
            while (!this.gate.compareAndSet(null, new CountDownLatch(1))) {
                CountDownLatch l = this.gate.get();
                if (l == null) continue;
                l.await();
            }
            final ChannelHandlerContext ctx1 = this.ctx;
            final FullHttpRequest req1 = this.req;
            this.cancelTask = ts.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        WebActorHandler.sendHttpError(ctx1, req1, (FullHttpResponse)new DefaultFullHttpResponse(req1.getProtocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.wrappedBuffer((byte[])"Timeout while waiting for user actor to reply.".getBytes())));
                    }
                    finally {
                        HttpActorAdapter.this.unblockSessionRequests();
                    }
                }
            }, REPLY_TIMEOUT, TimeUnit.MILLISECONDS);
        }

        @Suspendable
        private void unblockSessionRequests() {
            CountDownLatch l;
            if (this.cancelTask != null) {
                this.cancelTask.cancel(true);
            }
            if ((l = (CountDownLatch)this.gate.getAndSet(null)) != null) {
                l.countDown();
            }
        }

        private boolean isRequestInProgress() {
            return this.gate.get() != null;
        }
    }

    private static final class WebSocketChannelAdapter
    implements SendPort<WebDataMessage> {
        private final ChannelHandlerContext ctx;
        WebSocketActorAdapter actor;

        public WebSocketChannelAdapter(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public final void send(WebDataMessage message) throws SuspendExecution, InterruptedException {
            this.trySend(message);
        }

        public final boolean send(WebDataMessage message, long timeout, TimeUnit unit) throws SuspendExecution, InterruptedException {
            return this.trySend(message);
        }

        public final boolean send(WebDataMessage message, Timeout timeout) throws SuspendExecution, InterruptedException {
            return this.send(message, timeout.nanosLeft(), TimeUnit.NANOSECONDS);
        }

        public final boolean trySend(WebDataMessage message) {
            if (!message.isBinary()) {
                this.ctx.writeAndFlush((Object)new TextWebSocketFrame(message.getStringBody()));
            } else {
                this.ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((ByteBuffer)message.getByteBufferBody())));
            }
            return true;
        }

        public final void close() {
            if (this.ctx.channel().isOpen()) {
                this.ctx.close();
            }
            this.actor.die(null);
        }

        public final void close(Throwable t) {
            this.actor.die(t);
            this.close();
        }
    }

    private static final class WebSocketActorAdapter
    extends FakeActor<WebDataMessage> {
        ActorRef<? super WebMessage> userActor;
        private ChannelHandlerContext ctx;

        public WebSocketActorAdapter(ChannelHandlerContext ctx, ActorRef<? super WebMessage> userActor) {
            super(userActor.getName(), (SendPort)new WebSocketChannelAdapter(ctx));
            ((WebSocketChannelAdapter)this.getMailbox()).actor = this;
            this.ctx = ctx;
            this.userActor = userActor;
            this.watch(userActor);
        }

        public final void interrupt() {
            this.die(new InterruptedException());
        }

        public final String toString() {
            return "WebSocketActorAdapter{userActor=" + this.userActor + '}';
        }

        private void onMessage(ByteBuffer message) {
            try {
                this.userActor.send((Object)new WebDataMessage(this.ref(), message));
            }
            catch (SuspendExecution ex) {
                throw new AssertionError((Object)ex);
            }
        }

        private void onMessage(String message) {
            try {
                this.userActor.send((Object)new WebDataMessage(this.ref(), message));
            }
            catch (SuspendExecution ex) {
                throw new AssertionError((Object)ex);
            }
        }

        protected final WebDataMessage handleLifecycleMessage(LifecycleMessage m) {
            ExitMessage em;
            if (m instanceof ExitMessage && (em = (ExitMessage)m).getActor() != null && em.getActor().equals(this.userActor)) {
                this.die(em.getCause());
            }
            return null;
        }

        protected final void throwIn(RuntimeException e) {
            this.die(e);
        }

        protected final void die(Throwable cause) {
            super.die(cause);
            if (this.ctx.channel().isOpen()) {
                this.ctx.close();
            }
            this.userActor = null;
            this.ctx = null;
        }
    }

    public static abstract class DefaultContextImpl
    implements Context {
        private static final String durationProp = System.getProperty(DefaultContextImpl.class.getName() + ".durationMillis");
        private static final long DURATION = durationProp != null ? Long.parseLong(durationProp) : 60000L;
        private final ReentrantLock lock = new ReentrantLock();
        private final long created;
        private final Map<String, Object> attachments = new HashMap<String, Object>();
        protected long renewed = this.created = new Date().getTime();
        private Long validityMS;
        private boolean valid = true;

        @Override
        public void invalidate() throws SuspendExecution, InterruptedException {
            HttpActorAdapter actor = (HttpActorAdapter)((Object)this.attachments.get(WebActorHandler.ACTOR_KEY));
            if (actor != null) {
                actor.handleDie(null);
            }
            this.attachments.clear();
            this.valid = false;
        }

        @Override
        public final boolean isValid() throws SuspendExecution, InterruptedException {
            boolean ret;
            boolean bl = ret = this.valid && new Date().getTime() - this.renewed <= this.getValidityMS();
            if (!ret) {
                this.invalidate();
            }
            return ret;
        }

        @Override
        public final boolean renew() {
            if (!this.valid) {
                return false;
            }
            this.renewed = new Date().getTime();
            return true;
        }

        @Override
        public final Map<String, Object> getAttachments() {
            return this.attachments;
        }

        @Override
        public final ReentrantLock getLock() {
            return this.lock;
        }

        public void setValidityMS(long validityMS) {
            this.validityMS = validityMS;
        }

        public long getValidityMS() {
            return this.validityMS != null ? this.validityMS : DURATION;
        }
    }

    public static interface Context {
        public String getId();

        public ReentrantLock getLock();

        public boolean isValid() throws SuspendExecution, InterruptedException;

        public void invalidate() throws SuspendExecution, InterruptedException;

        public boolean renew();

        public void restart(FullHttpRequest var1);

        public ActorRef<? extends WebMessage> getWebActor();

        public boolean handlesWithHttp(String var1);

        public boolean handlesWithWebSocket(String var1);

        public WatchPolicy watch();

        public Map<String, Object> getAttachments();

        public static enum WatchPolicy {
            DONT_WATCH,
            DIE,
            DIE_IF_EXCEPTION_ELSE_RESTART,
            RESTART;

        }
    }

    public static interface WebActorContextProvider {
        public Context get(FullHttpRequest var1);
    }
}

