/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors.netty;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.comsat.webactors.Cookie;
import co.paralleluniverse.comsat.webactors.HttpRequest;
import co.paralleluniverse.comsat.webactors.HttpResponse;
import co.paralleluniverse.comsat.webactors.WebMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class HttpRequestWrapper
extends HttpRequest {
    public static final String CHARSET_MARKER_STRING = "charset=";
    final ActorRef<? super HttpResponse> actorRef;
    final FullHttpRequest req;
    final ChannelHandlerContext ctx;
    final String sessionId;
    private static final Set<io.netty.handler.codec.http.cookie.Cookie> EMPTY_SET = new HashSet<io.netty.handler.codec.http.cookie.Cookie>();
    private final ByteBuf reqContent;
    private InetSocketAddress sourceAddress;
    private ImmutableMultimap<String, String> params;
    private URI uri;
    private Collection<Cookie> cookies;
    private ListMultimap<String, String> heads;
    private ByteBuffer byteBufferBody;
    private String stringBody;
    private Charset encoding;
    private String contentType;

    public HttpRequestWrapper(ActorRef<? super HttpResponse> actorRef, ChannelHandlerContext ctx, FullHttpRequest req, String sessionId) {
        this.actorRef = actorRef;
        this.ctx = ctx;
        this.req = req;
        this.sessionId = sessionId;
        this.reqContent = Unpooled.copiedBuffer((ByteBuf)req.content());
    }

    public final String getSourceHost() {
        this.fillSourceAddress();
        return this.sourceAddress != null ? this.sourceAddress.getHostString() : null;
    }

    public final int getSourcePort() {
        this.fillSourceAddress();
        return this.sourceAddress != null ? this.sourceAddress.getPort() : -1;
    }

    private void fillSourceAddress() {
        SocketAddress remoteAddress = this.ctx.channel().remoteAddress();
        if (this.sourceAddress == null && remoteAddress instanceof InetSocketAddress) {
            this.sourceAddress = (InetSocketAddress)remoteAddress;
        }
    }

    public final Multimap<String, String> getParameters() {
        if (this.params == null) {
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.req.getUri());
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            Map parameters = queryStringDecoder.parameters();
            for (String k : parameters.keySet()) {
                builder.putAll((Object)k, (Iterable)parameters.get(k));
            }
            this.params = builder.build();
        }
        return this.params;
    }

    public final Map<String, Object> getAttributes() {
        return ImmutableMap.of();
    }

    public final String getScheme() {
        this.initUri();
        return this.uri.getScheme();
    }

    private void initUri() {
        if (this.uri == null) {
            try {
                this.uri = new URI(this.req.getUri());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public final String getMethod() {
        return this.req.getMethod().name();
    }

    public final String getPathInfo() {
        this.initUri();
        return this.uri.getPath();
    }

    public final String getContextPath() {
        return "/";
    }

    public final String getQueryString() {
        this.initUri();
        return this.uri.getQuery();
    }

    public final String getRequestURI() {
        return this.req.getUri();
    }

    public final String getServerName() {
        this.initUri();
        return this.uri.getHost();
    }

    public final int getServerPort() {
        this.initUri();
        return this.uri.getPort();
    }

    public final ActorRef<WebMessage> getFrom() {
        return this.actorRef;
    }

    public final ListMultimap<String, String> getHeaders() {
        if (this.heads == null) {
            this.heads = HttpRequestWrapper.extractHeaders(this.req.headers());
        }
        return this.heads;
    }

    public final Collection<Cookie> getCookies() {
        if (this.cookies == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (io.netty.handler.codec.http.cookie.Cookie c : HttpRequestWrapper.getNettyCookies(this.req)) {
                builder.add((Object)Cookie.cookie((String)c.name(), (String)c.value()).setDomain(c.domain()).setPath(c.path()).setHttpOnly(c.isHttpOnly()).setMaxAge((int)c.maxAge()).setSecure(c.isSecure()).build());
            }
            this.cookies = builder.build();
        }
        return this.cookies;
    }

    static Set<io.netty.handler.codec.http.cookie.Cookie> getNettyCookies(FullHttpRequest req) {
        String head;
        HttpHeaders heads = req.headers();
        String string = head = heads != null ? heads.get("Cookie") : null;
        if (head != null) {
            return ServerCookieDecoder.LAX.decode(head);
        }
        return EMPTY_SET;
    }

    public final int getContentLength() {
        String stringBody = this.getStringBody();
        if (stringBody != null) {
            return stringBody.length();
        }
        ByteBuffer bufferBody = this.getByteBufferBody();
        if (bufferBody != null) {
            return bufferBody.remaining();
        }
        return 0;
    }

    public final Charset getCharacterEncoding() {
        if (this.encoding == null) {
            this.encoding = HttpRequestWrapper.extractCharacterEncoding(this.getHeaders());
        }
        return this.encoding;
    }

    public final String getContentType() {
        if (this.contentType == null) {
            List cts;
            this.getHeaders();
            if (this.heads != null && (cts = this.heads.get((Object)"Content-Type")) != null && cts.size() > 0) {
                this.contentType = (String)cts.get(0);
            }
        }
        return null;
    }

    public final String getStringBody() {
        if (this.stringBody == null) {
            if (this.byteBufferBody != null) {
                return null;
            }
            this.decodeStringBody();
        }
        return this.stringBody;
    }

    public final ByteBuffer getByteBufferBody() {
        if (this.byteBufferBody == null) {
            if (this.stringBody != null) {
                return null;
            }
            if (this.reqContent != null) {
                this.byteBufferBody = this.reqContent.nioBuffer();
            }
        }
        return this.byteBufferBody;
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    private String decodeStringBody() {
        if (this.reqContent != null) {
            try {
                this.stringBody = this.getCharacterEncodingOrDefault().newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(this.reqContent.nioBuffer()).toString();
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
        }
        return this.stringBody;
    }

    Charset getCharacterEncodingOrDefault() {
        return HttpRequestWrapper.getCharacterEncodingOrDefault(this.getCharacterEncoding());
    }

    static Charset extractCharacterEncodingOrDefault(HttpHeaders headers) {
        return HttpRequestWrapper.getCharacterEncodingOrDefault(HttpRequestWrapper.extractCharacterEncoding(HttpRequestWrapper.extractHeaders(headers)));
    }

    static Charset extractCharacterEncoding(ListMultimap<String, String> heads) {
        String ct;
        List cts;
        if (heads != null && (cts = heads.get((Object)"Content-Type")) != null && cts.size() > 0 && (ct = ((String)cts.get(0)).trim().toLowerCase()).contains(CHARSET_MARKER_STRING)) {
            try {
                return Charset.forName(ct.substring(ct.indexOf(CHARSET_MARKER_STRING) + CHARSET_MARKER_STRING.length()).trim());
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return null;
    }

    static ImmutableListMultimap<String, String> extractHeaders(HttpHeaders headers) {
        if (headers != null) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (String n : headers.names()) {
                builder.putAll((Object)n, (Iterable)headers.getAll(n));
            }
            return builder.build();
        }
        return null;
    }

    private static Charset getCharacterEncodingOrDefault(Charset characterEncoding) {
        if (characterEncoding == null) {
            return Charset.defaultCharset();
        }
        return characterEncoding;
    }
}

