/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors.netty;

import co.paralleluniverse.actors.ActorImpl;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.ExitMessage;
import co.paralleluniverse.actors.FakeActor;
import co.paralleluniverse.actors.LifecycleMessage;
import co.paralleluniverse.actors.ShutdownMessage;
import co.paralleluniverse.common.util.Pair;
import co.paralleluniverse.common.util.SystemProperties;
import co.paralleluniverse.comsat.webactors.Cookie;
import co.paralleluniverse.comsat.webactors.HttpRequest;
import co.paralleluniverse.comsat.webactors.HttpResponse;
import co.paralleluniverse.comsat.webactors.HttpStreamOpened;
import co.paralleluniverse.comsat.webactors.WebActor;
import co.paralleluniverse.comsat.webactors.WebDataMessage;
import co.paralleluniverse.comsat.webactors.WebMessage;
import co.paralleluniverse.comsat.webactors.WebSocketOpened;
import co.paralleluniverse.comsat.webactors.netty.AutoWebActorHandler;
import co.paralleluniverse.comsat.webactors.netty.HttpRequestWrapper;
import co.paralleluniverse.fibers.FiberUtil;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.SuspendableRunnable;
import co.paralleluniverse.strands.Timeout;
import co.paralleluniverse.strands.channels.SendPort;
import co.paralleluniverse.strands.concurrent.ReentrantLock;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;

public class WebActorHandler
extends SimpleChannelInboundHandler<Object> {
    protected static final String SESSION_COOKIE_KEY = "JSESSIONID";
    protected static final Map<String, Context> sessions = Collections.synchronizedMap(new WeakHashMap());
    protected static final String TRACK_SESSION_PROP = HttpChannelAdapter.class.getName() + ".trackSession";
    protected static final String trackSession = System.getProperty(TRACK_SESSION_PROP, "sse");
    protected static final String OMIT_DATE_HEADER_PROP = HttpChannelAdapter.class.getName() + ".omitDateHeader";
    protected static final Boolean omitDateHeader = SystemProperties.isEmptyOrTrue((String)OMIT_DATE_HEADER_PROP);
    private static final String ACTOR_KEY = "co.paralleluniverse.comsat.webactors.sessionActor";
    private static final WeakHashMap<Class<?>, List<Pair<String, String>>> classToUrlPatterns = new WeakHashMap();
    private static final InternalLogger log = InternalLoggerFactory.getInstance(AutoWebActorHandler.class);
    private final WebActorContextProvider selector;
    private final String httpResponseEncoderName;
    private WebSocketServerHandshaker handshaker;
    private WebSocketActorAdapter webSocketActor;

    public WebActorHandler(WebActorContextProvider selector) {
        this(selector, null);
    }

    public WebActorHandler(WebActorContextProvider selector, String httpResponseEncoderName) {
        this.selector = selector;
        this.httpResponseEncoderName = httpResponseEncoderName;
    }

    public final void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ctx.channel().isOpen()) {
            ctx.close();
        }
        log.error("Exception caught", cause);
    }

    protected final void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else {
            throw new AssertionError((Object)("Unexpected message " + msg));
        }
    }

    protected static boolean sessionsEnabled() {
        return "always".equals(trackSession) || "sse".equals(trackSession);
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (frame instanceof ContinuationWebSocketFrame) {
            return;
        }
        if (frame instanceof TextWebSocketFrame) {
            this.webSocketActor.onMessage(((TextWebSocketFrame)frame).text());
        } else {
            this.webSocketActor.onMessage(frame.content().nioBuffer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) throws SuspendExecution {
        if (!req.getDecoderResult().isSuccess()) {
            WebActorHandler.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(req.getProtocolVersion(), HttpResponseStatus.BAD_REQUEST), false);
            return;
        }
        String uri = req.getUri();
        Context actorCtx = this.selector.get(ctx, req);
        assert (actorCtx != null);
        ReentrantLock lock = actorCtx.getLock();
        assert (lock != null);
        lock.lock();
        try {
            ActorRef<? extends WebMessage> userActorRef = actorCtx.getRef();
            Object internalActor = (ActorImpl)actorCtx.getAttachments().get(ACTOR_KEY);
            if (userActorRef != null) {
                if (actorCtx.handlesWithWebSocket(uri)) {
                    if (internalActor == null || !(internalActor instanceof WebSocketActorAdapter)) {
                        this.webSocketActor = new WebSocketActorAdapter(ctx, userActorRef);
                        this.addActorToContextAndUnlock(actorCtx, (ActorImpl)this.webSocketActor, lock);
                    }
                    WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(uri, null, true);
                    this.handshaker = wsFactory.newHandshaker((io.netty.handler.codec.http.HttpRequest)req);
                    if (this.handshaker == null) {
                        WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
                    } else {
                        final ActorRef<? super WebMessage> userActorRef0 = this.webSocketActor.userActor;
                        this.handshaker.handshake(ctx.channel(), req).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                FiberUtil.runInFiber((SuspendableRunnable)new SuspendableRunnable(){

                                    public void run() throws SuspendExecution, InterruptedException {
                                        userActorRef0.send((Object)new WebSocketOpened(WebActorHandler.this.webSocketActor.ref()));
                                    }
                                });
                            }
                        });
                    }
                    return;
                }
                if (actorCtx.handlesWithHttp(uri)) {
                    if (internalActor == null || !(internalActor instanceof HttpActorAdapter)) {
                        internalActor = new HttpActorAdapter(userActorRef, actorCtx, this.httpResponseEncoderName);
                        this.addActorToContextAndUnlock(actorCtx, (ActorImpl)internalActor, lock);
                    }
                    ((HttpActorAdapter)((Object)internalActor)).service(ctx, req);
                    return;
                }
            }
        }
        finally {
            if (lock.isHeldByCurrentStrand() && lock.isLocked()) {
                lock.unlock();
            }
        }
        WebActorHandler.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(req.getProtocolVersion(), HttpResponseStatus.NOT_FOUND), false);
    }

    private void addActorToContextAndUnlock(Context actorContext, ActorImpl actor, ReentrantLock lock) {
        actorContext.getAttachments().put(ACTOR_KEY, actor);
        lock.unlock();
    }

    protected static boolean trackSession(boolean sseStarted) {
        return trackSession != null && ("always".equals(trackSession) || sseStarted && "sse".equals(trackSession));
    }

    protected static boolean handlesWithHttp(String uri, Class<?> actorClass) {
        return WebActorHandler.match(uri, actorClass).equals("websocket");
    }

    protected static boolean handlesWithWebSocket(String uri, Class<?> actorClass) {
        return WebActorHandler.match(uri, actorClass).equals("ws");
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res, Boolean close) {
        WebActorHandler.writeHttpResponse(ctx, req, res, close);
    }

    private static void sendHttpRedirect(ChannelHandlerContext ctx, FullHttpRequest req, String newUri) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(req.getProtocolVersion(), HttpResponseStatus.FOUND);
        HttpHeaders.setHeader((HttpMessage)res, (String)"Location", (Object)newUri);
        WebActorHandler.writeHttpResponse(ctx, req, (FullHttpResponse)res, true);
    }

    private static void writeHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res, Boolean close) {
        if (!omitDateHeader.booleanValue() && !res.headers().contains("Date")) {
            DefaultHttpHeaders.addDateHeader((HttpMessage)res, (String)"Date", (Date)new Date());
        }
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().code() != 200 || close == null || close.booleanValue()) {
            res.headers().set("Connection", (Object)"close");
            ctx.writeAndFlush((Object)res).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            res.headers().set("Connection", (Object)"keep-alive");
            WebActorHandler.write(ctx, res);
        }
    }

    private static ChannelFuture write(ChannelHandlerContext ctx, Object res) {
        return ctx.writeAndFlush(res);
    }

    private static String match(String uri, Class<?> actorClass) {
        if (uri != null && actorClass != null) {
            for (Pair<String, String> e : WebActorHandler.lookupOrInsert(actorClass)) {
                if (!WebActorHandler.servletMatch((String)e.getFirst(), uri)) continue;
                return (String)e.getSecond();
            }
        }
        return "";
    }

    private static List<Pair<String, String>> lookupOrInsert(Class<?> actorClass) {
        if (actorClass != null) {
            List<Pair<String, String>> lookup = classToUrlPatterns.get(actorClass);
            if (lookup != null) {
                return lookup;
            }
            return WebActorHandler.insert(actorClass);
        }
        return null;
    }

    private static List<Pair<String, String>> insert(Class<?> actorClass) {
        if (actorClass != null) {
            WebActor wa = actorClass.getAnnotation(WebActor.class);
            ArrayList<Pair<String, String>> ret = new ArrayList<Pair<String, String>>(4);
            for (String httpP : wa.httpUrlPatterns()) {
                WebActorHandler.addPattern(ret, httpP, "websocket");
            }
            for (String wsP : wa.webSocketUrlPatterns()) {
                WebActorHandler.addPattern(ret, wsP, "ws");
            }
            classToUrlPatterns.put(actorClass, ret);
            return ret;
        }
        return null;
    }

    private static void addPattern(List<Pair<String, String>> ret, String p, String type) {
        if (p != null) {
            Pair entry = new Pair((Object)p, (Object)type);
            if (p.endsWith("*") || p.startsWith("*.") || p.equals("/")) {
                ret.add((Pair<String, String>)entry);
            } else {
                ret.add(0, (Pair<String, String>)entry);
            }
        }
    }

    private static boolean servletMatch(String pattern, String uri) {
        if (pattern != null && uri != null) {
            if (pattern.startsWith("/") && pattern.endsWith("*")) {
                return uri.startsWith(pattern.substring(0, pattern.length() - 1));
            }
            if (pattern.startsWith("*.")) {
                return uri.endsWith(pattern.substring(2));
            }
            if (pattern.isEmpty()) {
                return uri.equals("/");
            }
            return pattern.equals("/") || pattern.equals(uri);
        }
        return false;
    }

    private static void startSession(String sessionId, Context actorContext) {
        sessions.put(sessionId, actorContext);
    }

    private static final class HttpStreamChannelAdapter
    implements SendPort<WebDataMessage> {
        private final Charset encoding;
        private final ChannelHandlerContext ctx;
        HttpStreamActorAdapter actor;

        public HttpStreamChannelAdapter(ChannelHandlerContext ctx, FullHttpRequest req) {
            this.ctx = ctx;
            this.encoding = HttpRequestWrapper.extractCharacterEncodingOrDefault(req.headers());
        }

        public final void send(WebDataMessage message) throws SuspendExecution, InterruptedException {
            this.trySend(message);
        }

        public final boolean send(WebDataMessage message, long timeout, TimeUnit unit) throws SuspendExecution, InterruptedException {
            this.send(message);
            return true;
        }

        public final boolean send(WebDataMessage message, Timeout timeout) throws SuspendExecution, InterruptedException {
            return this.send(message, timeout.nanosLeft(), TimeUnit.NANOSECONDS);
        }

        public final boolean trySend(WebDataMessage res) {
            ByteBuf buf;
            String stringBody = res.getStringBody();
            if (stringBody != null) {
                byte[] bs = stringBody.getBytes(this.encoding);
                buf = Unpooled.wrappedBuffer((byte[])bs);
            } else {
                buf = Unpooled.wrappedBuffer((ByteBuffer)res.getByteBufferBody());
            }
            this.ctx.writeAndFlush((Object)buf);
            return true;
        }

        public final void close() {
            if (this.ctx.channel().isOpen()) {
                this.ctx.close();
            }
            if (this.actor != null) {
                this.actor.die(null);
            }
        }

        public final void close(Throwable t) {
            if (this.actor != null) {
                this.actor.die(t);
            }
            this.close();
        }
    }

    private static final class HttpStreamActorAdapter
    extends FakeActor<WebDataMessage> {
        private volatile boolean dead;

        public HttpStreamActorAdapter(ChannelHandlerContext ctx, FullHttpRequest req) {
            super(req.toString(), (SendPort)new HttpStreamChannelAdapter(ctx, req));
            ((HttpStreamChannelAdapter)this.getMailbox()).actor = this;
        }

        protected WebDataMessage handleLifecycleMessage(LifecycleMessage m) {
            if (m instanceof ShutdownMessage) {
                this.die(null);
            }
            return null;
        }

        protected void throwIn(RuntimeException e) {
            this.die(e);
        }

        public void interrupt() {
            this.die(new InterruptedException());
        }

        protected void die(Throwable cause) {
            if (this.dead) {
                return;
            }
            this.dead = true;
            this.mailbox().close();
            super.die(cause);
        }

        public String toString() {
            return "HttpStreamActorAdapter{request + " + this.getName() + "}";
        }
    }

    private static final class HttpChannelAdapter
    implements SendPort<HttpResponse> {
        HttpActorAdapter actor;
        private final String httpResponseEncoderName;
        private Context actorContext;

        public HttpChannelAdapter(Context actorContext, String httpResponseEncoderName) {
            this.actorContext = actorContext;
            this.httpResponseEncoderName = httpResponseEncoderName;
        }

        public final void send(HttpResponse message) throws SuspendExecution, InterruptedException {
            this.trySend(message);
        }

        public final boolean send(HttpResponse message, long timeout, TimeUnit unit) throws SuspendExecution, InterruptedException {
            this.send(message);
            return true;
        }

        public final boolean send(HttpResponse message, Timeout timeout) throws SuspendExecution, InterruptedException {
            return this.send(message, timeout.nanosLeft(), TimeUnit.NANOSECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean trySend(HttpResponse message) {
            try {
                boolean sseStarted;
                HttpRequestWrapper nettyRequest = (HttpRequestWrapper)message.getRequest();
                FullHttpRequest req = nettyRequest.req;
                ChannelHandlerContext ctx = nettyRequest.ctx;
                HttpResponseStatus status = HttpResponseStatus.valueOf((int)message.getStatus());
                if (message.getStatus() >= 400 && message.getStatus() < 600) {
                    WebActorHandler.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(req.getProtocolVersion(), status), false);
                    this.close();
                    boolean bl = true;
                    return bl;
                }
                if (message.getRedirectPath() != null) {
                    WebActorHandler.sendHttpRedirect(ctx, req, message.getRedirectPath());
                    this.close();
                    boolean bl = true;
                    return bl;
                }
                DefaultFullHttpResponse res = message.getStringBody() != null ? new DefaultFullHttpResponse(req.getProtocolVersion(), status, Unpooled.wrappedBuffer((byte[])message.getStringBody().getBytes())) : (message.getByteBufferBody() != null ? new DefaultFullHttpResponse(req.getProtocolVersion(), status, Unpooled.wrappedBuffer((ByteBuffer)message.getByteBufferBody())) : new DefaultFullHttpResponse(req.getProtocolVersion(), status));
                if (message.getCookies() != null) {
                    ServerCookieEncoder enc = ServerCookieEncoder.STRICT;
                    for (Cookie c : message.getCookies()) {
                        HttpHeaders.setHeader((HttpMessage)res, (String)"Cookie", (Object)enc.encode(this.getNettyCookie(c)));
                    }
                }
                if (message.getHeaders() != null) {
                    for (Map.Entry h : message.getHeaders().entries()) {
                        HttpHeaders.setHeader((HttpMessage)res, (String)((String)h.getKey()), h.getValue());
                    }
                }
                if (message.getContentType() != null) {
                    String ct = message.getContentType();
                    if (message.getCharacterEncoding() != null) {
                        ct = ct + "; charset=" + message.getCharacterEncoding().name();
                    }
                    HttpHeaders.setHeader((HttpMessage)res, (String)"Content-Type", (Object)ct);
                }
                if (WebActorHandler.trackSession(sseStarted = message.shouldStartActor())) {
                    String sessionId = UUID.randomUUID().toString();
                    res.headers().add("Set-Cookie", (Object)ServerCookieEncoder.STRICT.encode(WebActorHandler.SESSION_COOKIE_KEY, sessionId));
                    WebActorHandler.startSession(sessionId, this.actorContext);
                }
                if (!sseStarted) {
                    String stringBody = message.getStringBody();
                    long contentLength = 0L;
                    if (stringBody != null) {
                        contentLength = stringBody.getBytes().length;
                    } else {
                        ByteBuffer byteBufferBody = message.getByteBufferBody();
                        if (byteBufferBody != null) {
                            contentLength = byteBufferBody.remaining();
                        }
                    }
                    res.headers().add("Content-Length", (Object)contentLength);
                }
                HttpStreamActorAdapter httpStreamActorAdapter = sseStarted ? new HttpStreamActorAdapter(ctx, req) : null;
                WebActorHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res, false);
                if (sseStarted) {
                    if (this.httpResponseEncoderName != null) {
                        ctx.pipeline().remove(this.httpResponseEncoderName);
                    } else {
                        ChannelPipeline pl = ctx.pipeline();
                        ArrayList handlerKeysToBeRemoved = new ArrayList();
                        for (Map.Entry e : pl) {
                            if (!(e.getValue() instanceof HttpResponseEncoder)) continue;
                            handlerKeysToBeRemoved.add(e.getKey());
                        }
                        for (String k : handlerKeysToBeRemoved) {
                            pl.remove(k);
                        }
                    }
                    try {
                        message.getFrom().send((Object)new HttpStreamOpened(httpStreamActorAdapter.ref(), message));
                    }
                    catch (SuspendExecution e) {
                        throw new AssertionError((Object)e);
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (this.actor != null) {
                    this.actor.unwatch();
                }
            }
        }

        private io.netty.handler.codec.http.cookie.Cookie getNettyCookie(Cookie c) {
            DefaultCookie ret = new DefaultCookie(c.getName(), c.getValue());
            ret.setDomain(c.getDomain());
            ret.setHttpOnly(c.isHttpOnly());
            ret.setMaxAge((long)c.getMaxAge());
            ret.setPath(c.getPath());
            ret.setSecure(c.isSecure());
            return ret;
        }

        public final void close() {
            if (this.actor != null) {
                this.actor.die(null);
            }
            this.actorContext = null;
        }

        public final void close(Throwable t) {
            log.error("Exception while closing HTTP adapter", t);
            if (this.actor != null) {
                this.actor.die(t);
            }
        }
    }

    private static final class HttpActorAdapter
    extends FakeActor<HttpResponse> {
        private ActorRef<? super HttpRequest> userActor;
        private Context context;
        private volatile boolean dead;
        private volatile ChannelHandlerContext ctx;
        private volatile FullHttpRequest req;
        private volatile Object watchToken;

        HttpActorAdapter(ActorRef<? super HttpRequest> userActor, Context actorContext, String httpResponseEncoderName) {
            super("HttpActorAdapter", (SendPort)new HttpChannelAdapter(actorContext, httpResponseEncoderName));
            if (actorContext.watch()) {
                ((HttpChannelAdapter)this.getMailbox()).actor = this;
            }
            this.userActor = userActor;
            this.context = actorContext;
        }

        final void service(ChannelHandlerContext ctx, FullHttpRequest req) throws SuspendExecution {
            if (this.context.watch()) {
                this.watchToken = this.watch(this.userActor);
            }
            this.ctx = ctx;
            this.req = req;
            if (this.isDone()) {
                this.handleDeath(this.getDeathCause());
                return;
            }
            this.userActor.send((Object)new HttpRequestWrapper((ActorRef<? super HttpResponse>)this.ref(), ctx, req));
        }

        final void unwatch() {
            if (this.watchToken != null && this.userActor != null) {
                this.unwatch(this.userActor, this.watchToken);
                this.watchToken = null;
            }
        }

        private void handleDeath(Throwable cause) {
            if (cause != null) {
                WebActorHandler.sendHttpResponse(this.ctx, this.req, (FullHttpResponse)new DefaultFullHttpResponse(this.req.getProtocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.wrappedBuffer((byte[])("Actor is dead because of " + cause.getMessage()).getBytes())), false);
            } else {
                WebActorHandler.sendHttpResponse(this.ctx, this.req, (FullHttpResponse)new DefaultFullHttpResponse(this.req.getProtocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.wrappedBuffer((byte[])"Actor has terminated.".getBytes())), false);
            }
        }

        protected final HttpResponse handleLifecycleMessage(LifecycleMessage m) {
            ExitMessage em;
            if (m instanceof ExitMessage && (em = (ExitMessage)m).getActor() != null && em.getActor().equals(this.userActor)) {
                this.handleDeath(em.getCause());
                this.die(em.getCause());
            }
            return null;
        }

        protected final void die(Throwable cause) {
            if (this.dead) {
                return;
            }
            this.dead = true;
            super.die(cause);
            try {
                this.context.invalidate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unwatch();
            this.userActor = null;
            this.watchToken = null;
            this.context = null;
            this.ctx = null;
            this.req = null;
        }

        protected final void throwIn(RuntimeException e) {
            this.die(e);
        }

        protected final void interrupt() {
            this.die(new InterruptedException());
        }

        public final String toString() {
            return "HttpActorAdapter{" + this.userActor + "}";
        }
    }

    private static final class WebSocketChannelAdapter
    implements SendPort<WebDataMessage> {
        private final ChannelHandlerContext ctx;
        WebSocketActorAdapter actor;

        public WebSocketChannelAdapter(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public final void send(WebDataMessage message) throws SuspendExecution, InterruptedException {
            this.trySend(message);
        }

        public final boolean send(WebDataMessage message, long timeout, TimeUnit unit) throws SuspendExecution, InterruptedException {
            return this.trySend(message);
        }

        public final boolean send(WebDataMessage message, Timeout timeout) throws SuspendExecution, InterruptedException {
            return this.send(message, timeout.nanosLeft(), TimeUnit.NANOSECONDS);
        }

        public final boolean trySend(WebDataMessage message) {
            if (!message.isBinary()) {
                this.ctx.writeAndFlush((Object)new TextWebSocketFrame(message.getStringBody()));
            } else {
                this.ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((ByteBuffer)message.getByteBufferBody())));
            }
            return true;
        }

        public final void close() {
            if (this.ctx.channel().isOpen()) {
                this.ctx.close();
            }
            if (this.actor != null) {
                this.actor.die(null);
            }
        }

        public final void close(Throwable t) {
            if (this.actor != null) {
                this.actor.die(t);
            }
            this.close();
        }
    }

    private static final class WebSocketActorAdapter
    extends FakeActor<WebDataMessage> {
        ActorRef<? super WebMessage> userActor;
        private ChannelHandlerContext ctx;

        public WebSocketActorAdapter(ChannelHandlerContext ctx, ActorRef<? super WebMessage> userActor) {
            super(userActor.getName(), (SendPort)new WebSocketChannelAdapter(ctx));
            ((WebSocketChannelAdapter)this.getMailbox()).actor = this;
            this.ctx = ctx;
            this.userActor = userActor;
            this.watch(userActor);
        }

        public final void interrupt() {
            this.die(new InterruptedException());
        }

        public final String toString() {
            return "WebSocketActorAdapter{userActor=" + this.userActor + '}';
        }

        private void onMessage(ByteBuffer message) {
            try {
                this.userActor.send((Object)new WebDataMessage(this.ref(), message));
            }
            catch (SuspendExecution ex) {
                throw new AssertionError((Object)ex);
            }
        }

        private void onMessage(String message) {
            try {
                this.userActor.send((Object)new WebDataMessage(this.ref(), message));
            }
            catch (SuspendExecution ex) {
                throw new AssertionError((Object)ex);
            }
        }

        protected final WebDataMessage handleLifecycleMessage(LifecycleMessage m) {
            ExitMessage em;
            if (m instanceof ExitMessage && (em = (ExitMessage)m).getActor() != null && em.getActor().equals(this.userActor)) {
                this.die(em.getCause());
            }
            return null;
        }

        protected final void throwIn(RuntimeException e) {
            this.die(e);
        }

        protected final void die(Throwable cause) {
            super.die(cause);
            if (this.ctx.channel().isOpen()) {
                this.ctx.close();
            }
            this.userActor = null;
            this.ctx = null;
        }
    }

    public static abstract class DefaultContextImpl
    implements Context {
        private static final String durationProp = System.getProperty(DefaultContextImpl.class.getName() + ".durationMillis");
        private static final long DURATION = durationProp != null ? Long.parseLong(durationProp) : 60000L;
        private final ReentrantLock lock = new ReentrantLock();
        private final long created;
        private final Map<String, Object> attachments = new HashMap<String, Object>();
        private boolean valid = true;

        public DefaultContextImpl() {
            this.created = new Date().getTime();
        }

        @Override
        public void invalidate() {
            this.attachments.clear();
            this.valid = false;
        }

        @Override
        public final boolean isValid() {
            boolean ret;
            boolean bl = ret = this.valid && new Date().getTime() - this.created <= DURATION;
            if (!ret) {
                this.invalidate();
            }
            return ret;
        }

        @Override
        public final Map<String, Object> getAttachments() {
            return this.attachments;
        }

        @Override
        public final ReentrantLock getLock() {
            return this.lock;
        }

        @Override
        public boolean watch() {
            return true;
        }
    }

    public static interface Context {
        public boolean isValid();

        public void invalidate();

        public ActorRef<? extends WebMessage> getRef();

        public ReentrantLock getLock();

        public Map<String, Object> getAttachments();

        public boolean handlesWithHttp(String var1);

        public boolean handlesWithWebSocket(String var1);

        public boolean watch();
    }

    public static interface WebActorContextProvider {
        public Context get(ChannelHandlerContext var1, FullHttpRequest var2);
    }
}

