/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors.netty;

import co.paralleluniverse.actors.Actor;
import co.paralleluniverse.actors.ActorImpl;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.ActorSpec;
import co.paralleluniverse.common.reflection.AnnotationUtil;
import co.paralleluniverse.common.reflection.ClassLoaderUtil;
import co.paralleluniverse.common.util.Pair;
import co.paralleluniverse.comsat.webactors.WebActor;
import co.paralleluniverse.comsat.webactors.WebMessage;
import co.paralleluniverse.comsat.webactors.netty.WebActorHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AutoWebActorHandler
extends WebActorHandler {
    private static final AttributeKey<WebActorHandler.Context> SESSION_KEY = AttributeKey.newInstance((String)(AutoWebActorHandler.class.getName() + ".session"));
    private static final InternalLogger log = InternalLoggerFactory.getInstance(AutoWebActorHandler.class);
    private static final List<Class<?>> actorClasses = new ArrayList(4);
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public AutoWebActorHandler() {
        this(null, null, null);
    }

    public AutoWebActorHandler(String httpResponseEncoderName) {
        this(httpResponseEncoderName, null, null);
    }

    public AutoWebActorHandler(String httpResponseEncoderName, ClassLoader userClassLoader) {
        this(httpResponseEncoderName, userClassLoader, null);
    }

    public AutoWebActorHandler(String httpResponseEncoderName, Map<Class<?>, Object[]> actorParams) {
        this(httpResponseEncoderName, null, actorParams);
    }

    public AutoWebActorHandler(String httpResponseEncoderName, ClassLoader userClassLoader, Map<Class<?>, Object[]> actorParams) {
        super(new AutoContextProvider(userClassLoader, actorParams), httpResponseEncoderName);
    }

    private static WebActorHandler.Context newActorContext(FullHttpRequest req, ClassLoader userClassLoader, Map<Class<?>, Object[]> actorParams) {
        return new AutoContext(req, actorParams, userClassLoader);
    }

    private static class AutoContext
    extends WebActorHandler.DefaultContextImpl {
        private final Map<Class<?>, Object[]> actorParams;
        private final ClassLoader userClassLoader;
        private Class<? extends ActorImpl<? extends WebMessage>> actorClass;
        private ActorRef<? extends WebMessage> actorRef;

        public AutoContext(FullHttpRequest req, Map<Class<?>, Object[]> actorParams, ClassLoader userClassLoader) {
            this.actorParams = actorParams;
            this.userClassLoader = userClassLoader;
            Pair<ActorRef<? extends WebMessage>, Class<? extends ActorImpl<? extends WebMessage>>> p = this.autoCreateActor(req);
            if (p != null) {
                this.actorRef = (ActorRef)p.getFirst();
                this.actorClass = (Class)p.getSecond();
            }
        }

        @Override
        public final ActorRef<? extends WebMessage> getRef() {
            return this.actorRef;
        }

        @Override
        public final boolean handlesWithHttp(String uri) {
            return WebActorHandler.handlesWithHttp(uri, this.actorClass);
        }

        @Override
        public final boolean handlesWithWebSocket(String uri) {
            return WebActorHandler.handlesWithWebSocket(uri, this.actorClass);
        }

        private Pair<ActorRef<? extends WebMessage>, Class<? extends ActorImpl<? extends WebMessage>>> autoCreateActor(FullHttpRequest req) {
            this.registerActorClasses();
            String uri = req.getUri();
            for (Class c : actorClasses) {
                if (!WebActorHandler.handlesWithHttp(uri, c) && !WebActorHandler.handlesWithWebSocket(uri, c)) continue;
                return new Pair((Object)Actor.newActor((ActorSpec)new ActorSpec(c, this.actorParams != null ? this.actorParams.get(c) : EMPTY_OBJECT_ARRAY)).spawn(), (Object)c);
            }
            return null;
        }

        private synchronized void registerActorClasses() {
            if (actorClasses.isEmpty()) {
                try {
                    ClassLoader classLoader = this.userClassLoader != null ? this.userClassLoader : this.getClass().getClassLoader();
                    ClassLoaderUtil.accept((URLClassLoader)((URLClassLoader)classLoader), (ClassLoaderUtil.Visitor)new ClassLoaderUtil.Visitor(){

                        public final void visit(String resource, URL url, ClassLoader cl) {
                            if (!ClassLoaderUtil.isClassFile((String)resource)) {
                                return;
                            }
                            String className = ClassLoaderUtil.resourceToClass((String)resource);
                            try (InputStream is = cl.getResourceAsStream(resource);){
                                if (AnnotationUtil.hasClassAnnotation(WebActor.class, (InputStream)is)) {
                                    this.registerWebActor(cl.loadClass(className));
                                }
                            }
                            catch (IOException | ClassNotFoundException e) {
                                log.error("Exception while scanning class " + className + " for WebActor annotation", (Throwable)e);
                                throw new RuntimeException(e);
                            }
                        }

                        private void registerWebActor(Class<?> c) {
                            actorClasses.add(c);
                        }
                    });
                }
                catch (IOException e) {
                    log.error("IOException while scanning classes for WebActor annotation", (Throwable)e);
                }
            }
        }
    }

    private static class AutoContextProvider
    implements WebActorHandler.WebActorContextProvider {
        private final ClassLoader userClassLoader;
        private final Map<Class<?>, Object[]> actorParams;

        public AutoContextProvider(ClassLoader userClassLoader, Map<Class<?>, Object[]> actorParams) {
            this.userClassLoader = userClassLoader;
            this.actorParams = actorParams;
        }

        @Override
        public final WebActorHandler.Context get(ChannelHandlerContext ctx, FullHttpRequest req) {
            Attribute s = ctx.attr(SESSION_KEY);
            if (s.get() == null) {
                WebActorHandler.Context actorContext;
                String sessionId = this.getSessionId(req);
                System.err.println("Session ID: " + sessionId);
                System.err.println("Sessions enabled: " + WebActorHandler.sessionsEnabled());
                if (sessionId != null && WebActorHandler.sessionsEnabled() && (actorContext = WebActorHandler.sessions.get(sessionId)) != null) {
                    if (actorContext.isValid()) {
                        s.set((Object)actorContext);
                        return actorContext;
                    }
                    WebActorHandler.sessions.remove(sessionId);
                }
                actorContext = AutoWebActorHandler.newActorContext(req, this.userClassLoader, this.actorParams);
                s.set((Object)actorContext);
                return actorContext;
            }
            return (WebActorHandler.Context)s.get();
        }

        private String getSessionId(FullHttpRequest req) {
            Set cookies;
            String cookiesString = req.headers().get("Cookie");
            if (cookiesString != null && (cookies = ServerCookieDecoder.LAX.decode(cookiesString)) != null) {
                for (Cookie c : cookies) {
                    if (c == null || !"JSESSIONID".equals(c.name())) continue;
                    return c.value();
                }
            }
            return null;
        }
    }
}

