/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors.webbit;

import co.paralleluniverse.comsat.webactors.WebDataMessage;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.Timeout;
import co.paralleluniverse.strands.channels.SendPort;
import java.util.concurrent.TimeUnit;
import org.webbitserver.WebSocketConnection;

class WebbitWebSocketPort
implements SendPort<WebDataMessage> {
    private final WebSocketConnection connection;

    public WebbitWebSocketPort(WebSocketConnection connection) {
        this.connection = connection;
    }

    public void send(WebDataMessage message) throws SuspendExecution, InterruptedException {
        this.trySend(message);
    }

    public boolean send(WebDataMessage message, long timeout, TimeUnit unit) throws SuspendExecution, InterruptedException {
        return this.trySend(message);
    }

    public boolean send(WebDataMessage message, Timeout timeout) throws SuspendExecution, InterruptedException {
        return this.send(message, timeout.nanosLeft(), TimeUnit.NANOSECONDS);
    }

    public boolean trySend(WebDataMessage message) {
        if (!message.isBinary()) {
            this.connection.send(message.getStringBody());
        } else {
            this.connection.send(message.getByteBufferBody().array());
        }
        return true;
    }

    public void close() {
        this.connection.close();
    }
}

