/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors.webbit;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.comsat.webactors.WebDataMessage;
import co.paralleluniverse.comsat.webactors.webbit.WebbitMessageHandler;
import co.paralleluniverse.comsat.webactors.webbit.WebbitWebSocketBinaryPort;
import co.paralleluniverse.comsat.webactors.webbit.WebbitWebSocketPort;
import co.paralleluniverse.comsat.webactors.webbit.WebbitWebSocketStringPort;
import co.paralleluniverse.strands.channels.SendPort;
import java.nio.ByteBuffer;
import org.webbitserver.WebSocketConnection;
import org.webbitserver.WebSocketHandler;

public abstract class WebbitWebSocketHandler
implements WebSocketHandler {
    static final String ACTOR_KEY = "co.paralleluniverse.actor";
    public static final String MH_KEY = "co.paralleluniverse.mh";

    public final void onMessage(WebSocketConnection connection, String msg) throws Throwable {
        WebbitMessageHandler mh = (WebbitMessageHandler)connection.data(MH_KEY);
        if (mh != null) {
            mh.onMessage(connection, msg);
        }
    }

    public final void onMessage(WebSocketConnection connection, byte[] msg) throws Throwable {
        WebbitMessageHandler mh = (WebbitMessageHandler)connection.data(MH_KEY);
        if (mh != null) {
            mh.onMessage(connection, msg);
        }
    }

    public void attachWebSocket(final WebSocketConnection connection, final ActorRef<Object> actor) {
        connection.data(ACTOR_KEY, actor);
        connection.data(MH_KEY, (Object)new WebbitMessageHandler(){
            final SendPort<String> stringPort;
            final SendPort<ByteBuffer> binaryPort;
            final SendPort<WebDataMessage> sp;
            {
                this.stringPort = new WebbitWebSocketStringPort(connection);
                this.binaryPort = new WebbitWebSocketBinaryPort(connection);
                this.sp = new WebbitWebSocketPort(connection);
            }

            @Override
            public void onMessage(WebSocketConnection conn, String msg) throws Throwable {
                actor.send((Object)new WebDataMessage(null, msg));
            }

            @Override
            public void onMessage(WebSocketConnection conn, byte[] msg) throws Throwable {
                actor.send((Object)new WebDataMessage(null, ByteBuffer.wrap(msg)));
            }
        });
    }

    public void onClose(WebSocketConnection connection) throws Throwable {
    }

    public void onPing(WebSocketConnection connection, byte[] msg) throws Throwable {
    }

    public void onPong(WebSocketConnection connection, byte[] msg) throws Throwable {
    }
}

