/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.comsat.webactors.WebMessage;
import java.nio.ByteBuffer;

public class WebDataMessage
extends WebMessage {
    private final ActorRef<WebDataMessage> sender;
    private final String string;
    private final ByteBuffer byteBuffer;

    public WebDataMessage(ActorRef<? super WebDataMessage> from, String body) {
        this.sender = from;
        this.string = body;
        this.byteBuffer = null;
    }

    public WebDataMessage(ActorRef<? super WebDataMessage> from, ByteBuffer body) {
        this.sender = from;
        this.string = null;
        this.byteBuffer = body;
    }

    public ActorRef<WebDataMessage> getFrom() {
        return this.sender;
    }

    public boolean isBinary() {
        return this.byteBuffer != null;
    }

    @Override
    public String getStringBody() {
        return this.string;
    }

    @Override
    public ByteBuffer getByteBufferBody() {
        return this.byteBuffer;
    }

    @Override
    protected String contentString() {
        return super.contentString() + " size: " + (this.string != null ? this.string.length() : (this.byteBuffer != null ? this.byteBuffer.remaining() : 0)) + (this.isBinary() ? "" : " data: " + this.string);
    }
}

