/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.comsat.webactors.Cookie;
import co.paralleluniverse.comsat.webactors.HttpMessage;
import co.paralleluniverse.comsat.webactors.WebMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public abstract class HttpRequest
extends HttpMessage {
    public static final String RFC1123_DATE = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    private static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");

    public abstract Multimap<String, String> getParameters();

    public abstract Map<String, Object> getAttributes();

    public Collection<String> getParametersValues(String name) {
        return this.getParameters().get((Object)name);
    }

    public String getParameter(String name) {
        return (String)HttpRequest.first(this.getParameters().get((Object)name));
    }

    public Object getAttribute(String name) {
        return this.getAttributes().get(name);
    }

    public abstract String getScheme();

    public abstract String getMethod();

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = HttpRequest.parseDate(value);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    public abstract String getPathInfo();

    public abstract String getContextPath();

    public abstract String getQueryString();

    public abstract String getRequestURI();

    public String getRequestURL() {
        StringBuilder url = new StringBuilder();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url.toString();
    }

    public abstract String getServerName();

    public abstract int getServerPort();

    public abstract ActorRef<WebMessage> getFrom();

    @Override
    protected String contentString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(this.getMethod());
        sb.append(" uri: ").append(this.getRequestURI());
        sb.append(" query: ").append(this.getQueryString());
        sb.append(" params: ").append(this.getParameters());
        sb.append(" headers: ").append(this.getHeaders());
        sb.append(" cookies: ").append(this.getCookies());
        sb.append(" contentLength: ").append(this.getContentLength());
        sb.append(" charEncoding: ").append(this.getCharacterEncoding());
        sb.append(" body: ").append(this.getStringBody());
        return super.contentString() + sb;
    }

    private static long parseDate(String value) {
        Date date = null;
        for (int i = 0; date == null && i < formats.length; ++i) {
            try {
                date = formats[i].parse(value);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            return -1L;
        }
        return date.getTime();
    }

    static {
        format.setTimeZone(gmtZone);
        formats[0].setTimeZone(gmtZone);
        formats[1].setTimeZone(gmtZone);
        formats[2].setTimeZone(gmtZone);
    }

    private static class SimpleHttpRequest
    extends HttpRequest {
        private final ActorRef<WebMessage> sender;
        private final String contentType;
        private final Charset charset;
        private final String strBody;
        private final ByteBuffer binBody;
        private final Collection<Cookie> cookies;
        private final ListMultimap<String, String> headers;
        private final Multimap<String, String> params;
        private final String method;
        private final String scheme;
        private final String server;
        private final int port;
        private final String uri;

        public SimpleHttpRequest(ActorRef<? super WebMessage> from, HttpRequest httpRequest) {
            this.sender = from;
            this.contentType = httpRequest.getContentType();
            this.charset = httpRequest.getCharacterEncoding();
            this.strBody = httpRequest.getStringBody();
            this.binBody = httpRequest.getByteBufferBody() != null ? httpRequest.getByteBufferBody().asReadOnlyBuffer() : null;
            this.cookies = httpRequest.getCookies();
            this.headers = httpRequest.getHeaders();
            this.method = httpRequest.getMethod();
            this.scheme = httpRequest.getScheme();
            this.server = httpRequest.getServerName();
            this.port = httpRequest.getServerPort();
            this.params = httpRequest.getParameters();
            this.uri = httpRequest.getRequestURI();
        }

        public SimpleHttpRequest(ActorRef<? super WebMessage> from, Builder builder) {
            this.sender = from;
            this.contentType = builder.contentType;
            this.charset = builder.charset;
            this.strBody = builder.strBody;
            this.binBody = builder.binBody != null ? builder.binBody.asReadOnlyBuffer() : null;
            this.cookies = builder.cookies != null ? ImmutableList.copyOf((Collection)builder.cookies) : null;
            this.headers = builder.headers != null ? ImmutableListMultimap.copyOf((Multimap)builder.headers) : null;
            this.params = builder.params != null ? ImmutableListMultimap.copyOf((Multimap)builder.params) : null;
            this.method = builder.method;
            this.scheme = builder.scheme;
            this.server = builder.server;
            this.port = builder.port;
            this.uri = builder.path;
        }

        @Override
        public ActorRef<WebMessage> getFrom() {
            return this.sender;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public Charset getCharacterEncoding() {
            return this.charset;
        }

        @Override
        public int getContentLength() {
            if (this.binBody != null) {
                return this.binBody.remaining();
            }
            return -1;
        }

        @Override
        public String getStringBody() {
            return this.strBody;
        }

        @Override
        public ByteBuffer getByteBufferBody() {
            return this.binBody != null ? this.binBody.duplicate() : null;
        }

        @Override
        public Collection<Cookie> getCookies() {
            return this.cookies;
        }

        @Override
        public ListMultimap<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public Map<String, Object> getAttributes() {
            return null;
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public String getMethod() {
            return this.method;
        }

        @Override
        public String getServerName() {
            return this.server;
        }

        @Override
        public int getServerPort() {
            return this.port;
        }

        @Override
        public Multimap<String, String> getParameters() {
            return this.params;
        }

        @Override
        public String getRequestURI() {
            return this.uri;
        }

        @Override
        public String getQueryString() {
            if (this.params == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : this.params.entries()) {
                sb.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append('&');
            }
            sb.delete(sb.length() - 1, sb.length());
            return sb.toString();
        }

        @Override
        public String getPathInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContextPath() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Builder {
        private final ActorRef<WebMessage> sender;
        private final String strBody;
        private final ByteBuffer binBody;
        private String contentType;
        private Charset charset;
        private List<Cookie> cookies;
        private ListMultimap<String, String> headers;
        private String method;
        private String scheme;
        private String server;
        private int port;
        private String path;
        private Multimap<String, String> params;

        public Builder(ActorRef<? super WebMessage> from, String body) {
            this.sender = from;
            this.strBody = body;
            this.binBody = null;
        }

        public Builder(ActorRef<? super WebMessage> from, ByteBuffer body) {
            this.sender = from;
            this.binBody = body;
            this.strBody = null;
        }

        public Builder(ActorRef<? super WebMessage> from) {
            this(from, (String)null);
        }

        public Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setCharacterEncoding(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder addHeader(String name, String value) {
            if (this.headers == null) {
                this.headers = LinkedListMultimap.create();
            }
            this.headers.put((Object)name, (Object)value);
            return this;
        }

        public Builder addCookie(Cookie cookie) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<Cookie>();
            }
            this.cookies.add(cookie);
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder setServer(String server) {
            this.server = server;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder addParam(String name, String value) {
            if (this.params == null) {
                this.params = LinkedListMultimap.create();
            }
            this.params.put((Object)name, (Object)value);
            return this;
        }
    }
}

