/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors;

public class Cookie {
    private final String name;
    private final String value;
    private final String path;
    private final String domain;
    private final int maxAge;
    private final String comment;
    private final int version;
    private final boolean httpOnly;
    private final boolean secure;

    public static Builder cookie(String name, String value) {
        return new Builder(name, value);
    }

    private Cookie(Builder builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.path = builder.path;
        this.domain = builder.domain;
        this.maxAge = builder.maxAge;
        this.comment = builder.comment;
        this.version = builder.version;
        this.httpOnly = builder.httpOnly;
        this.secure = builder.secure;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getPath() {
        return this.path;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public String getComment() {
        return this.comment;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cookie[");
        sb.append("name: ").append(this.name);
        sb.append(" value: ").append(this.value);
        if (this.path != null) {
            sb.append(" path: ").append(this.path);
        }
        if (this.domain != null) {
            sb.append(" domain: ").append(this.domain);
        }
        sb.append(" maxAge: ").append(this.maxAge);
        if (this.comment != null) {
            sb.append(" comment: ").append(this.comment);
        }
        sb.append(" version: ").append(this.version);
        if (this.httpOnly) {
            sb.append(" httpOnly: ").append(this.httpOnly);
        }
        sb.append(" secure: ").append(this.secure);
        sb.append(']');
        return sb.toString();
    }

    public static class Builder {
        private final String name;
        private final String value;
        private String path;
        private String domain;
        private int maxAge = -1;
        private String comment;
        private int version;
        private boolean httpOnly;
        private boolean secure;

        private Builder(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public Builder setPath(String uri) {
            this.path = uri;
            return this;
        }

        public Builder setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder setMaxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder setHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public Builder setSecure(boolean flag) {
            this.secure = flag;
            return this;
        }

        public Cookie build() {
            return new Cookie(this);
        }
    }
}

