/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.comsat.webactors.Cookie;
import co.paralleluniverse.comsat.webactors.HttpMessage;
import co.paralleluniverse.comsat.webactors.HttpRequest;
import co.paralleluniverse.comsat.webactors.WebMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class HttpResponse
extends HttpMessage {
    public abstract ActorRef<WebMessage> getFrom();

    public abstract HttpRequest getRequest();

    public abstract int getStatus();

    public abstract Throwable getError();

    public abstract String getRedirectPath();

    public abstract boolean shouldStartActor();

    @Override
    protected String contentString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(this.getStatus());
        sb.append(" headers: ").append(this.getHeaders());
        sb.append(" cookies: ").append(this.getCookies());
        sb.append(" contentLength: ").append(this.getContentLength());
        sb.append(" charEncoding: ").append(this.getCharacterEncoding());
        if (this.getStringBody() != null) {
            sb.append(" body: ").append(this.getStringBody());
        }
        if (this.getRedirectPath() != null) {
            sb.append(" redirectPath: ").append(this.getRedirectPath());
        }
        if (this.getError() != null) {
            sb.append(" error: ").append(this.getError());
        }
        sb.append(" shouldStartActor: ").append(this.shouldStartActor());
        return super.contentString() + sb;
    }

    public static Builder ok(ActorRef<? super WebMessage> from, HttpRequest request, String body) {
        return new Builder(from, request, body);
    }

    public static Builder ok(ActorRef<? super WebMessage> from, HttpRequest request, ByteBuffer body) {
        return new Builder(from, request, body);
    }

    public static Builder error(ActorRef<? super WebMessage> from, HttpRequest request, int status, Throwable cause) {
        return new Builder(from, request).status(status).error(cause);
    }

    public static Builder error(ActorRef<? super WebMessage> from, HttpRequest request, int status, String body) {
        return new Builder(from, request, body).status(status);
    }

    public static Builder redirect(HttpRequest request, String redirectPath) {
        return new Builder(request).redirect(redirectPath);
    }

    private static class SimpleHttpResponse
    extends HttpResponse {
        private final ActorRef<WebMessage> sender;
        private final HttpRequest request;
        private final String contentType;
        private final Charset charset;
        private final String strBody;
        private final ByteBuffer binBody;
        private final Collection<Cookie> cookies;
        private final ListMultimap<String, String> headers;
        private final int status;
        private final Throwable error;
        private final String redirectPath;
        private final boolean startActor;

        public SimpleHttpResponse(ActorRef<? super WebMessage> from, HttpResponse httpResponse) {
            this.sender = from;
            this.request = httpResponse.getRequest();
            this.contentType = httpResponse.getContentType();
            this.charset = httpResponse.getCharacterEncoding();
            this.strBody = httpResponse.getStringBody();
            this.binBody = httpResponse.getByteBufferBody() != null ? httpResponse.getByteBufferBody().asReadOnlyBuffer() : null;
            this.cookies = httpResponse.getCookies();
            this.headers = httpResponse.getHeaders();
            this.error = httpResponse.getError();
            this.status = httpResponse.getStatus();
            this.redirectPath = httpResponse.getRedirectPath();
            this.startActor = httpResponse.shouldStartActor();
        }

        public SimpleHttpResponse(ActorRef<? super WebMessage> from, Builder builder) {
            this.sender = from;
            this.request = builder.request;
            this.contentType = builder.contentType;
            this.charset = builder.charset;
            this.strBody = builder.strBody;
            this.binBody = builder.binBody != null ? builder.binBody.asReadOnlyBuffer() : null;
            this.cookies = builder.cookies != null ? ImmutableList.copyOf((Collection)builder.cookies) : null;
            this.headers = builder.headers != null ? ImmutableListMultimap.copyOf((Multimap)builder.headers) : null;
            this.error = builder.error;
            this.status = builder.status;
            this.redirectPath = builder.redirectPath;
            this.startActor = builder.startActor;
        }

        @Override
        public ActorRef<WebMessage> getFrom() {
            return this.sender;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public Charset getCharacterEncoding() {
            return this.charset;
        }

        @Override
        public int getContentLength() {
            if (this.binBody != null) {
                return this.binBody.remaining();
            }
            return -1;
        }

        @Override
        public String getStringBody() {
            return this.strBody;
        }

        @Override
        public ByteBuffer getByteBufferBody() {
            return this.binBody != null ? this.binBody.duplicate() : null;
        }

        @Override
        public Collection<Cookie> getCookies() {
            return this.cookies;
        }

        @Override
        public ListMultimap<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public HttpRequest getRequest() {
            return this.request;
        }

        @Override
        public int getStatus() {
            return this.status;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public String getRedirectPath() {
            return this.redirectPath;
        }

        @Override
        public boolean shouldStartActor() {
            return this.startActor;
        }
    }

    public static class Builder {
        private final ActorRef<WebMessage> sender;
        private final HttpRequest request;
        private final String strBody;
        private final ByteBuffer binBody;
        private String contentType;
        private Charset charset;
        private List<Cookie> cookies;
        private ListMultimap<String, String> headers;
        private int status;
        private Throwable error;
        private String redirectPath;
        private boolean startActor;

        public Builder(ActorRef<? super WebMessage> from, HttpRequest request, String body) {
            this.sender = from;
            this.request = request;
            this.strBody = body;
            this.binBody = null;
            this.status = 200;
        }

        public Builder(ActorRef<? super WebMessage> from, HttpRequest request, ByteBuffer body) {
            this.sender = from;
            this.request = request;
            this.binBody = body;
            this.strBody = null;
            this.status = 200;
        }

        public Builder(ActorRef<? super WebMessage> from, HttpRequest request) {
            this(from, request, (String)null);
        }

        Builder(HttpRequest request, String body) {
            this(null, request, body);
        }

        Builder(HttpRequest request, ByteBuffer body) {
            this(null, request, body);
        }

        Builder(HttpRequest request) {
            this(request, (String)null);
        }

        public Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setCharacterEncoding(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder addHeader(String name, String value) {
            if (this.headers == null) {
                this.headers = LinkedListMultimap.create();
            }
            this.headers.put((Object)name, (Object)value);
            return this;
        }

        public Builder addCookie(Cookie cookie) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<Cookie>();
            }
            this.cookies.add(cookie);
            return this;
        }

        public Builder status(int sc) {
            this.status = sc;
            return this;
        }

        public Builder error(Throwable error) {
            this.error = error;
            return this;
        }

        public Builder startActor() {
            this.startActor = true;
            return this;
        }

        Builder redirect(String redirectPath) {
            this.redirectPath = redirectPath;
            this.status = 302;
            return this;
        }

        public HttpResponse build() {
            return new SimpleHttpResponse(this.sender, this);
        }
    }
}

