/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors;

import co.paralleluniverse.comsat.webactors.HttpRequest;
import co.paralleluniverse.comsat.webactors.HttpResponse;
import java.nio.charset.Charset;

public final class SSE {
    public static HttpResponse.Builder startSSE(HttpRequest request) {
        return new HttpResponse.Builder(request).setContentType("text/event-stream").setCharacterEncoding(Charset.forName("UTF-8")).startActor();
    }

    public static HttpResponse.Builder startSSE(HttpRequest request, long reconnectTimeout) {
        return new HttpResponse.Builder(request, SSE.retryString(reconnectTimeout) + '\n').setContentType("text/event-stream").setCharacterEncoding(Charset.forName("UTF-8")).startActor();
    }

    public static long getLastEventId(HttpRequest request) {
        String str = request.getHeader("Last-Event-ID");
        if (str == null) {
            return -1L;
        }
        return Long.parseLong(str);
    }

    public static String event(long id, String eventType, String payload) {
        return SSE.idString(id) + SSE.eventString(eventType) + SSE.dataString(payload) + '\n';
    }

    public static String event(String eventType, String payload) {
        return SSE.dataString(payload) + '\n';
    }

    public static String event(long id, String payload) {
        return SSE.idString(id) + SSE.dataString(payload) + '\n';
    }

    public static String event(String payload) {
        return SSE.dataString(payload) + '\n';
    }

    public static String reconnectTimeout(long reconnectTimeout) {
        return SSE.retryString(reconnectTimeout);
    }

    private static String idString(long id) {
        return "id: " + id + '\n';
    }

    private static String eventString(String eventName) {
        return "event: " + eventName + '\n';
    }

    private static String retryString(long reconnectTimeout) {
        return "retry: " + reconnectTimeout + '\n';
    }

    private static String dataString(String payload) {
        String message = payload.trim();
        if (message.charAt(message.length() - 1) == '\n') {
            message = message.substring(0, message.length() - 1);
        }
        message = message.replaceAll("\n", "\ndata: ");
        message = "data: " + message + '\n';
        return message;
    }

    private SSE() {
    }
}

