/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.comsat.webactors;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.comsat.webactors.Cookie;
import co.paralleluniverse.comsat.webactors.HttpMessage;
import co.paralleluniverse.comsat.webactors.HttpRequest;
import co.paralleluniverse.comsat.webactors.WebMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HttpResponse
extends HttpMessage {
    private final ActorRef<WebMessage> sender;
    private final HttpRequest request;
    private final String contentType;
    private final Charset charset;
    private final String strBody;
    private final ByteBuffer binBody;
    private final List<Cookie> cookies;
    private final Multimap<String, String> headers;
    private final int status;
    private final Throwable error;
    private final String redirectPath;
    private final boolean startActor;

    public static Builder ok(HttpRequest request, String body) {
        return new Builder(request, body);
    }

    public static Builder ok(HttpRequest request, ByteBuffer body) {
        return new Builder(request, body);
    }

    public static Builder error(HttpRequest request, int status, Throwable cause) {
        return new Builder(request).status(status).error(cause);
    }

    public static Builder error(HttpRequest request, int status, String body) {
        return new Builder(request, body).status(status);
    }

    public static Builder redirect(HttpRequest request, String redirectPath) {
        return new Builder(request).redirect(redirectPath);
    }

    public HttpResponse(ActorRef<? super WebMessage> from, HttpResponse httpResponse) {
        this.sender = from;
        this.request = httpResponse.request;
        this.contentType = httpResponse.contentType;
        this.charset = httpResponse.charset;
        this.strBody = httpResponse.strBody;
        this.binBody = httpResponse.binBody != null ? httpResponse.binBody.asReadOnlyBuffer() : null;
        this.cookies = httpResponse.cookies;
        this.error = httpResponse.error;
        this.headers = httpResponse.headers;
        this.status = httpResponse.status;
        this.redirectPath = httpResponse.redirectPath;
        this.startActor = httpResponse.startActor;
    }

    public HttpResponse(ActorRef<? super WebMessage> from, Builder builder) {
        this.sender = from;
        this.request = builder.request;
        this.contentType = builder.contentType;
        this.charset = builder.charset;
        this.strBody = builder.strBody;
        this.binBody = builder.binBody != null ? builder.binBody.asReadOnlyBuffer() : null;
        this.cookies = builder.cookies != null ? ImmutableList.copyOf((Collection)builder.cookies) : null;
        this.error = builder.error;
        this.headers = builder.headers != null ? ImmutableMultimap.copyOf((Multimap)builder.headers) : null;
        this.status = builder.status;
        this.redirectPath = builder.redirectPath;
        this.startActor = builder.startActor;
    }

    public ActorRef<WebMessage> getFrom() {
        return this.sender;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public Charset getCharacterEncoding() {
        return this.charset;
    }

    @Override
    public int getContentLength() {
        if (this.binBody != null) {
            return this.binBody.remaining();
        }
        return -1;
    }

    @Override
    public String getStringBody() {
        return this.strBody;
    }

    @Override
    public ByteBuffer getByteBufferBody() {
        return this.binBody != null ? this.binBody.duplicate() : null;
    }

    @Override
    public Collection<Cookie> getCookies() {
        return this.cookies;
    }

    @Override
    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public int getStatus() {
        return this.status;
    }

    public Throwable getError() {
        return this.error;
    }

    public String getRedirectPath() {
        return this.redirectPath;
    }

    public boolean shouldStartActor() {
        return this.startActor;
    }

    @Override
    protected String contentString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(this.getStatus());
        sb.append(" headers: ").append(this.getHeaders());
        sb.append(" cookies: ").append(this.getCookies());
        sb.append(" contentLength: ").append(this.getContentLength());
        sb.append(" charEncoding: ").append(this.getCharacterEncoding());
        if (this.strBody != null) {
            sb.append(" body: ").append(this.strBody);
        }
        if (this.redirectPath != null) {
            sb.append(" redirectPath: ").append(this.getRedirectPath());
        }
        if (this.error != null) {
            sb.append(" error: ").append(this.getError());
        }
        sb.append(" shouldStartActor: ").append(this.shouldStartActor());
        return super.contentString() + sb;
    }

    public static class Builder {
        private final ActorRef<WebMessage> sender;
        private final HttpRequest request;
        private final String strBody;
        private final ByteBuffer binBody;
        private String contentType;
        private Charset charset;
        private List<Cookie> cookies;
        private Multimap<String, String> headers;
        private int status;
        private Throwable error;
        private String redirectPath;
        private boolean startActor;

        public Builder(ActorRef<? super WebMessage> from, HttpRequest request, String body) {
            this.sender = from;
            this.request = request;
            this.strBody = body;
            this.binBody = null;
            this.status = 200;
        }

        public Builder(ActorRef<? super WebMessage> from, HttpRequest request, ByteBuffer body) {
            this.sender = from;
            this.request = request;
            this.binBody = body;
            this.strBody = null;
            this.status = 200;
        }

        public Builder(ActorRef<? super WebMessage> from, HttpRequest request) {
            this(from, request, (String)null);
        }

        Builder(HttpRequest request, String body) {
            this(null, request, body);
        }

        Builder(HttpRequest request, ByteBuffer body) {
            this(null, request, body);
        }

        Builder(HttpRequest request) {
            this(request, (String)null);
        }

        public Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setCharacterEncoding(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder addHeader(String name, String value) {
            if (this.headers == null) {
                this.headers = LinkedHashMultimap.create();
            }
            this.headers.put((Object)name, (Object)value);
            return this;
        }

        public Builder addCookie(Cookie cookie) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<Cookie>();
            }
            this.cookies.add(cookie);
            return this;
        }

        public Builder status(int sc) {
            this.status = sc;
            return this;
        }

        public Builder error(Throwable error) {
            this.error = error;
            return this;
        }

        public Builder startActor() {
            this.startActor = true;
            return this;
        }

        Builder redirect(String redirectPath) {
            this.redirectPath = redirectPath;
            this.status = 302;
            return this;
        }

        public HttpResponse build() {
            return new HttpResponse(this.sender, this);
        }
    }
}

