/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common;

import co.paralleluniverse.common.FlexibleClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class PathClassLoader
extends FlexibleClassLoader {
    private final Object[] paths;

    public PathClassLoader(Path[] paths, ClassLoader parent, boolean childFirst) throws IOException {
        super(parent, childFirst);
        this.paths = PathClassLoader.process(paths);
    }

    public PathClassLoader(Path[] paths, boolean childFirst) throws IOException {
        super(childFirst);
        this.paths = PathClassLoader.process(paths);
    }

    public PathClassLoader(Path[] paths, ClassLoader parent) throws IOException {
        this(paths, parent, false);
    }

    public PathClassLoader(Path[] paths) throws IOException {
        this(paths, false);
    }

    private static Object[] process(Path[] paths) throws IOException {
        try {
            Object[] os = new Object[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                Path p = paths[i];
                Object o = Files.isRegularFile(p, new LinkOption[0]) ? FileSystems.newFileSystem(p, null) : p;
                os[i] = o;
            }
            return os;
        }
        catch (ProviderNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public final void close() {
        IOException ex = null;
        for (Object p : this.paths) {
            if (!(p instanceof FileSystem)) continue;
            try {
                ((FileSystem)p).close();
            }
            catch (IOException e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
    }

    private Path resolve(Object o, String name) {
        Path p = o instanceof FileSystem ? ((FileSystem)o).getPath(name, new String[0]) : ((Path)o).resolve(name);
        return p;
    }

    @Override
    protected URL findResource1(String name) {
        try {
            for (Object o : this.paths) {
                Path p = this.resolve(o, name);
                if (!Files.exists(p, new LinkOption[0])) continue;
                return p.toUri().toURL();
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Enumeration<URL> findResources1(String name) {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Object o : this.paths) {
                Path p = this.resolve(o, name);
                if (!Files.exists(p, new LinkOption[0])) continue;
                urls.add(p.toUri().toURL());
            }
            return Collections.enumeration(urls);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected InputStream findResourceAsStream(String name) {
        try {
            for (Object o : this.paths) {
                Path p = this.resolve(o, name);
                if (!this.isFileResource(p)) continue;
                return Files.newInputStream(p, new OpenOption[0]);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected byte[] readResource(String name) {
        try {
            for (Object o : this.paths) {
                Path p = this.resolve(o, name);
                if (!this.isFileResource(p)) continue;
                return Files.readAllBytes(p);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isFileResource(Path p) {
        return Files.exists(p, new LinkOption[0]) && !Files.isDirectory(p, new LinkOption[0]);
    }
}

