/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common;

import co.paralleluniverse.common.FlexibleClassLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarClassLoader
extends FlexibleClassLoader {
    private final Manifest mf;
    private final byte[] buffer;
    private final Path jarFile;
    private static int[] ZIP_HEADER = new int[]{10, 80, 75, 3, 4};

    public JarClassLoader(byte[] jar, ClassLoader parent, boolean childFirst) throws IOException {
        super(parent, childFirst);
        this.buffer = jar;
        this.jarFile = null;
        this.mf = JarClassLoader.getManifest(this.newInputStream());
    }

    public JarClassLoader(byte[] jar, boolean childFirst) throws IOException {
        super(childFirst);
        this.buffer = jar;
        this.jarFile = null;
        this.mf = JarClassLoader.getManifest(this.newInputStream());
    }

    public JarClassLoader(Path jarFile, ClassLoader parent, boolean childFirst) throws IOException {
        super(parent, childFirst);
        this.buffer = null;
        this.jarFile = jarFile;
        this.mf = JarClassLoader.getManifest(this.newInputStream());
    }

    public JarClassLoader(Path jarFile, boolean childFirst) throws IOException {
        super(childFirst);
        this.buffer = null;
        this.jarFile = jarFile;
        this.mf = JarClassLoader.getManifest(this.newInputStream());
    }

    public Manifest getManifest() {
        return this.mf;
    }

    @Override
    protected URL findResource1(String name) {
        try {
            if (!this.hasResource(name)) {
                return null;
            }
            return new URL("jar:" + this.jarFile.toUri() + "!/" + name);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Enumeration<URL> findResources1(String name) {
        URL url = this.findResource1(name);
        return Collections.enumeration(url != null ? Collections.singleton(url) : Collections.emptySet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasResource(String path) {
        try (InputStream is = this.findResourceAsStream(path);){
            boolean bl = is != null;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected InputStream findResourceAsStream(String path) {
        try {
            ZipEntry entry;
            ZipInputStream jis = new ZipInputStream(this.newInputStream());
            while ((entry = jis.getNextEntry()) != null) {
                if (!path.equalsIgnoreCase(entry.getName())) continue;
                if (entry.isDirectory()) {
                    throw new FileNotFoundException(path + " is a directory");
                }
                return jis;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] readResource(String path) {
        try (ZipInputStream jis = new ZipInputStream(this.newInputStream());){
            ZipEntry entry;
            while ((entry = jis.getNextEntry()) != null) {
                byte[] buf;
                if (!path.equalsIgnoreCase(entry.getName())) continue;
                if (entry.isDirectory()) {
                    throw new FileNotFoundException(path + " is a directory");
                }
                long size = entry.getSize();
                if (size < 0L) {
                    ByteArrayOutputStream bas = new ByteArrayOutputStream();
                    JarClassLoader.copy(jis, bas);
                    bas.close();
                    buf = bas.toByteArray();
                } else {
                    buf = new byte[(int)size];
                    int n = 0;
                    while (n != -1) {
                        n = jis.read(buf, n, buf.length - n);
                    }
                }
                byte[] byArray = buf;
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    private InputStream newInputStream() {
        try {
            InputStream is = this.buffer != null ? new ByteArrayInputStream(this.buffer) : Files.newInputStream(this.jarFile, new OpenOption[0]);
            return JarClassLoader.skipToZipStart(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Manifest getManifest(InputStream is) throws IOException {
        try (JarInputStream jis = new JarInputStream(is);){
            Manifest manifest = jis.getManifest();
            return manifest;
        }
    }

    private static InputStream skipToZipStart(InputStream is) throws IOException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        int state = 1;
        while (true) {
            int b;
            if (state == 1) {
                is.mark(ZIP_HEADER.length);
            }
            if ((b = is.read()) < 0) {
                throw new IllegalArgumentException("Not a JAR/ZIP file");
            }
            if (b == ZIP_HEADER[state]) {
                if (++state != ZIP_HEADER.length) continue;
                break;
            }
            state = 0;
            if (b != ZIP_HEADER[state]) continue;
            ++state;
        }
        is.reset();
        return is;
    }
}

