/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import sun.misc.CompoundEnumeration;

public abstract class FlexibleClassLoader
extends ClassLoader {
    private final boolean childFirst;
    private final ThreadLocal<Boolean> inGetResourceAsStream = new ThreadLocal();

    public FlexibleClassLoader(ClassLoader parent, boolean childFirst) {
        super(parent);
        this.childFirst = childFirst;
    }

    public FlexibleClassLoader(boolean childFirst) {
        this.childFirst = childFirst;
    }

    @Override
    public URL getResource(String name) {
        if (!this.childFirst) {
            return super.getResource(name);
        }
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String name) {
        this.inGetResourceAsStream.set(Boolean.TRUE);
        try {
            InputStream is = null;
            if (!this.childFirst) {
                is = super.getResourceAsStream(name);
            }
            if (is == null) {
                is = this.findResourceAsStream(name);
            }
            if (is == null && this.childFirst) {
                is = super.getResourceAsStream(name);
            }
            InputStream inputStream = is;
            return inputStream;
        }
        finally {
            this.inGetResourceAsStream.remove();
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!this.childFirst) {
            return super.loadClass(name, resolve);
        }
        try {
            Class<?> c = this.findClass(name);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[2];
        tmp[this.childFirst ? 1 : 0] = super.getResources(name);
        tmp[this.childFirst ? 0 : 1] = this.findResources1(name);
        return new CompoundEnumeration(tmp);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] buf = this.readResource(name.replace('.', '/') + ".class");
        if (buf == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, buf, 0, buf.length);
    }

    @Override
    protected URL findResource(String name) {
        if (this.inGetResourceAsStream.get() == Boolean.TRUE) {
            return null;
        }
        return this.findResource1(name);
    }

    protected abstract URL findResource1(String var1);

    protected abstract Enumeration<URL> findResources1(String var1);

    protected abstract InputStream findResourceAsStream(String var1);

    protected abstract byte[] readResource(String var1);
}

