/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.capsule;

import co.paralleluniverse.capsule.ZipFS;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.jar.Pack200;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Jar {
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final String ATTR_MANIFEST_VERSION = "Manifest-Version";
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final Manifest manifest;
    private final Path jar;
    private final JarInputStream jis;
    private JarOutputStream jos;
    private Pack200.Packer packer;
    private String jarPrefixStr;
    private Path jarPrefixFile;
    private boolean sealed;

    public Jar() {
        this.jar = null;
        this.jis = null;
        this.manifest = new Manifest();
    }

    public Jar(InputStream jar) throws IOException {
        this.jar = null;
        this.jis = jar instanceof JarInputStream ? (JarInputStream)jar : new JarInputStream(jar);
        this.manifest = new Manifest(this.jis.getManifest());
    }

    public Jar(Path jar) throws IOException {
        this.jar = jar;
        this.jis = null;
        this.manifest = Jar.getManifest(jar);
    }

    public Jar(File jar) throws IOException {
        this(jar.toPath());
    }

    public Jar(String jar) throws IOException {
        this(Paths.get(jar, new String[0]));
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public final Jar setAttribute(String name, String value) {
        this.verifyNotSealed();
        if (this.jos != null) {
            throw new IllegalStateException("Manifest cannot be modified after entries are added.");
        }
        this.getManifest().getMainAttributes().putValue(name, value);
        return this;
    }

    public final Jar setAttribute(String section, String name, String value) {
        this.verifyNotSealed();
        if (this.jos != null) {
            throw new IllegalStateException("Manifest cannot be modified after entries are added.");
        }
        Attributes attr = this.getManifest().getAttributes(section);
        if (attr == null) {
            attr = new Attributes();
            this.getManifest().getEntries().put(section, attr);
        }
        attr.putValue(name, value);
        return this;
    }

    public Jar setListAttribute(String name, List<String> values) {
        return this.setAttribute(name, Jar.join(values));
    }

    public Jar setListAttribute(String section, String name, List<String> values) {
        return this.setAttribute(name, section, Jar.join(values));
    }

    public Jar setMapAttribute(String name, Map<String, String> values) {
        return this.setAttribute(name, Jar.join(values));
    }

    public Jar setMapAttribute(String section, String name, Map<String, String> values) {
        return this.setAttribute(name, section, Jar.join(values));
    }

    public String getAttribute(String name) {
        return this.getManifest().getMainAttributes().getValue(name);
    }

    public String getAttribute(String section, String name) {
        Attributes attr = this.getManifest().getAttributes(section);
        return attr != null ? attr.getValue(name) : null;
    }

    public List<String> getListAttribute(String name) {
        return Jar.split(this.getAttribute(name));
    }

    public List<String> getListAttribute(String section, String name) {
        return Jar.split(this.getAttribute(section, name));
    }

    public Map<String, String> getMapAttribute(String name, String defaultValue) {
        return Jar.mapSplit(this.getAttribute(name), defaultValue);
    }

    public Map<String, String> getMapAttribute(String section, String name, String defaultValue) {
        return Jar.mapSplit(this.getAttribute(section, name), defaultValue);
    }

    public Jar addEntry(String path, InputStream is) throws IOException {
        this.beginWriting();
        Jar.addEntry(this.jos, path, is);
        return this;
    }

    public Jar addEntry(String path, byte[] content) throws IOException {
        this.beginWriting();
        Jar.addEntry(this.jos, path, content);
        return this;
    }

    public Jar addEntry(Path path, InputStream is) throws IOException {
        return this.addEntry(path != null ? path.toString() : "", is);
    }

    public Jar addEntry(Path path, Path file) throws IOException {
        return this.addEntry(path, Files.newInputStream(file, new OpenOption[0]));
    }

    public Jar addEntry(Path path, String file) throws IOException {
        return this.addEntry(path, Paths.get(file, new String[0]));
    }

    public Jar addEntry(String path, File file) throws IOException {
        return this.addEntry(path, (InputStream)new FileInputStream(file));
    }

    public Jar addEntry(String path, String file) throws IOException {
        return this.addEntry(path, (InputStream)new FileInputStream(file));
    }

    public Jar addClass(Class<?> clazz) throws IOException {
        String resource = clazz.getName().replace('.', '/') + ".class";
        return this.addEntry(resource, clazz.getClassLoader().getResourceAsStream(resource));
    }

    public Jar addEntries(Path path, Path dirOrZip) throws IOException {
        if (Files.isDirectory(dirOrZip, new LinkOption[0])) {
            this.addDir(path, dirOrZip, true);
        } else {
            try (FileSystem zipfs = ZipFS.newZipFileSystem(dirOrZip);){
                for (Path root : zipfs.getRootDirectories()) {
                    this.addDir(path, root, true);
                }
            }
        }
        return this;
    }

    public Jar addEntries(String path, Path dirOrZip) throws IOException {
        return this.addEntries(path != null ? Paths.get(path, new String[0]) : null, dirOrZip);
    }

    public Jar addEntries(Path path, ZipInputStream zip) throws IOException {
        this.beginWriting();
        try (ZipInputStream zis = zip;){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String target;
                String string = target = path != null ? path.resolve(entry.getName()).toString() : entry.getName();
                if (target.equals(MANIFEST_NAME)) continue;
                Jar.addEntryNoClose(this.jos, target, zis);
            }
        }
        return this;
    }

    public Jar addPackageOf(Class<?> clazz) throws IOException {
        try {
            String path = clazz.getPackage().getName().replace('.', '/');
            URL dirURL = clazz.getClassLoader().getResource(path);
            if (dirURL != null && dirURL.getProtocol().equals("file")) {
                this.addDir(Paths.get(path, new String[0]), Paths.get(dirURL.toURI()), false);
            } else {
                if (dirURL == null) {
                    dirURL = clazz.getClassLoader().getResource(clazz.getName().replace(".", "/") + ".class");
                }
                if (dirURL.getProtocol().equals("jar")) {
                    String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
                    try (FileSystem zipfs = ZipFS.newZipFileSystem(Paths.get(jarPath, new String[0]));){
                        this.addDir(Paths.get(path, new String[0]), zipfs.getPath(path, new String[0]), false);
                    }
                } else {
                    throw new AssertionError();
                }
            }
            return this;
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void addDir(final Path path, final Path dir, final boolean recursive) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path d, BasicFileAttributes attrs) throws IOException {
                return recursive || dir.equals(d) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path target;
                Path p = dir.relativize(file);
                Path path2 = target = path != null ? path.resolve(p.toString()) : p;
                if (!target.toString().equals(Jar.MANIFEST_NAME)) {
                    Jar.this.addEntry(target, file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public Jar setPacker(Pack200.Packer packer) {
        this.packer = packer;
        return this;
    }

    public Jar setReallyExecutable(boolean value) {
        this.setJarPrefix(value ? "#!/bin/sh\n\nexec java -jar $0 \"$@\"\n" : null);
        return this;
    }

    public Jar setJarPrefix(String value) {
        this.verifyNotSealed();
        if (this.jos != null) {
            throw new IllegalStateException("Really executable cannot be set after entries are added.");
        }
        if (value != null && this.jarPrefixFile != null) {
            throw new IllegalStateException("A prefix has already been set (" + this.jarPrefixFile + ")");
        }
        this.jarPrefixStr = value;
        return this;
    }

    public Jar setJarPrefix(Path file) {
        this.verifyNotSealed();
        if (this.jos != null) {
            throw new IllegalStateException("Really executable cannot be set after entries are added.");
        }
        if (file != null && this.jarPrefixStr != null) {
            throw new IllegalStateException("A prefix has already been set (" + this.jarPrefixStr + ")");
        }
        this.jarPrefixFile = file;
        return this;
    }

    private void beginWriting() throws IOException {
        this.verifyNotSealed();
        if (this.jos != null) {
            return;
        }
        this.writePrefix(this.baos);
        if (this.getAttribute(ATTR_MANIFEST_VERSION) == null) {
            this.setAttribute(ATTR_MANIFEST_VERSION, "1.0");
        }
        this.jos = new JarOutputStream((OutputStream)this.baos, this.manifest);
        if (this.jar != null) {
            this.addEntries((Path)null, this.jar);
        } else if (this.jis != null) {
            this.addEntries(null, this.jis);
        }
    }

    private void writePrefix(OutputStream os) throws IOException {
        if (this.jarPrefixStr != null) {
            OutputStreamWriter out = new OutputStreamWriter(os, StandardCharsets.UTF_8);
            out.write(this.jarPrefixStr);
            ((Writer)out).flush();
        } else if (this.jarPrefixFile != null) {
            Files.copy(this.jarPrefixFile, os);
        }
        if (this.jarPrefixStr != null || this.jarPrefixFile != null) {
            os.write(10);
            os.flush();
        }
    }

    public <T extends OutputStream> T write(T os) throws IOException {
        this.beginWriting();
        this.jos.close();
        this.sealed = true;
        byte[] content = this.baos.toByteArray();
        if (this.packer != null) {
            this.packer.pack(new JarInputStream(new ByteArrayInputStream(content)), os);
        } else {
            os.write(content);
        }
        os.close();
        return os;
    }

    private void writeManifest() throws IOException {
        this.jos.putNextEntry(new ZipEntry(MANIFEST_NAME));
        this.manifest.write(new BufferedOutputStream(this.jos));
        this.jos.closeEntry();
    }

    private void verifyNotSealed() {
        if (this.sealed) {
            throw new IllegalStateException("This JAR has been sealed (when it was written)");
        }
    }

    public File write(File file) throws IOException {
        this.write(new FileOutputStream(file));
        return file;
    }

    public Path write(Path path) throws IOException {
        this.write(Files.newOutputStream(path, new OpenOption[0]));
        return path;
    }

    public void write(String file) throws IOException {
        this.write(Paths.get(file, new String[0]));
    }

    public byte[] toByteArray() {
        try {
            return this.write(new ByteArrayOutputStream()).toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    private static void addEntry(JarOutputStream jarOut, String path, InputStream is) throws IOException {
        jarOut.putNextEntry(new JarEntry(path));
        Jar.copy(is, jarOut);
        jarOut.closeEntry();
    }

    private static void addEntryNoClose(JarOutputStream jarOut, String path, InputStream is) throws IOException {
        jarOut.putNextEntry(new JarEntry(path));
        Jar.copy0(is, jarOut);
        jarOut.closeEntry();
    }

    private static void addEntry(JarOutputStream jarOut, String path, byte[] data) throws IOException {
        jarOut.putNextEntry(new JarEntry(path));
        jarOut.write(data);
        jarOut.flush();
        jarOut.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream is, OutputStream os) throws IOException {
        try {
            Jar.copy0(is, os);
        }
        finally {
            is.close();
        }
    }

    private static Manifest getManifest(Path jarFile) throws IOException {
        try (FileSystem zipfs = ZipFS.newZipFileSystem(jarFile);){
            InputStream is = Files.newInputStream(zipfs.getPath(MANIFEST_NAME, new String[0]), new OpenOption[0]);
            Manifest manifest = is != null ? new Manifest(is) : null;
            return manifest;
        }
    }

    private static void copy0(InputStream is, OutputStream os) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer)) != -1) {
            os.write(buffer, 0, bytesRead);
        }
        os.flush();
    }

    public static InputStream toInputStream(String str, Charset charset) {
        return new ByteArrayInputStream(str.getBytes(charset));
    }

    private static String join(List<String> list, String separator) {
        if (list == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String element : list) {
            sb.append(element).append(separator);
        }
        sb.delete(sb.length() - separator.length(), sb.length());
        return sb.toString();
    }

    private static String join(Map<String, String> map, String kvSeparator, String separator) {
        if (map == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(entry.getKey()).append(kvSeparator).append(entry.getValue()).append(separator);
        }
        sb.delete(sb.length() - separator.length(), sb.length());
        return sb.toString();
    }

    private static String join(List<String> list) {
        return Jar.join(list, " ");
    }

    private static String join(Map<String, String> map) {
        return Jar.join(map, "=", " ");
    }

    private static List<String> split(String str, String separator) {
        if (str == null) {
            return null;
        }
        String[] es = str.split(separator);
        ArrayList<String> list = new ArrayList<String>(es.length);
        for (String e : es) {
            if ((e = e.trim()).isEmpty()) continue;
            list.add(e);
        }
        return list;
    }

    private static List<String> split(String list) {
        return Jar.split(list, " ");
    }

    private static Map<String, String> mapSplit(String map, char kvSeparator, String separator, String defaultValue) {
        if (map == null) {
            return null;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        for (String entry : Jar.split(map, separator)) {
            String key = Jar.getBefore(entry, kvSeparator);
            String value = Jar.getAfter(entry, kvSeparator);
            if (value == null) {
                if (defaultValue != null) {
                    value = defaultValue;
                } else {
                    throw new IllegalArgumentException("Element " + entry + " in \"" + map + "\" is not a key-value entry separated with " + kvSeparator + " and no default value provided");
                }
            }
            m.put(key, value);
        }
        return m;
    }

    private static Map<String, String> mapSplit(String map, String defaultValue) {
        return Jar.mapSplit(map, '=', " ", defaultValue);
    }

    private static String getBefore(String s, char separator) {
        int i = s.indexOf(separator);
        if (i < 0) {
            return s;
        }
        return s.substring(0, i);
    }

    private static String getAfter(String s, char separator) {
        int i = s.indexOf(separator);
        if (i < 0) {
            return null;
        }
        return s.substring(i + 1);
    }
}

