/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.capsule;

import co.paralleluniverse.capsule.CapsuleContainer;
import co.paralleluniverse.capsule.MBeanCapsuleContainer;
import co.paralleluniverse.common.ProcessUtil;
import com.sun.jdmk.remote.cascading.CascadingService;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;

public class CascadingCapsuleContainer
extends MBeanCapsuleContainer {
    private final CascadingService cascade;

    public CascadingCapsuleContainer(Path cacheDir, MBeanServer mbeanServer) {
        super(cacheDir);
        this.cascade = mbeanServer != null ? new CascadingService(mbeanServer) : null;
    }

    public CascadingCapsuleContainer(Path cacheDir) {
        this(cacheDir, ManagementFactory.getPlatformMBeanServer());
    }

    @Override
    protected CapsuleContainer.ProcessInfo mountProcess(Process p, String id) throws IOException, InstanceAlreadyExistsException {
        JMXServiceURL connectorAddress = ProcessUtil.getLocalConnectorAddress(p, false);
        String mountId = this.cascade != null ? this.cascade.mount(connectorAddress, null, ObjectName.WILDCARD, id) : null;
        return new ProcessInfo(p, connectorAddress, mountId);
    }

    @Override
    protected ProcessInfo getProcessInfo(String id) {
        return (ProcessInfo)super.getProcessInfo(id);
    }

    protected static class ProcessInfo
    extends MBeanCapsuleContainer.ProcessInfo {
        final String mountPoint;

        public ProcessInfo(Process process, JMXServiceURL connectorAddress, String mountPoint) {
            super(process, connectorAddress);
            this.mountPoint = mountPoint;
        }
    }
}

