/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.capsule;

import co.paralleluniverse.capsule.CapsuleContainerMBean;
import co.paralleluniverse.capsule.CapsuleLauncher;
import co.paralleluniverse.capsule.CapsuleProcessKilled;
import co.paralleluniverse.capsule.CapsuleProcessLaunched;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.StandardEmitterMBean;

public class CapsuleContainer
implements CapsuleContainerMBean {
    private final AtomicLong notificationSequence = new AtomicLong();
    private final ConcurrentMap<String, ProcessInfo> processes = new ConcurrentHashMap<String, ProcessInfo>();
    private final AtomicInteger counter = new AtomicInteger();
    private final Path cacheDir;
    private final NotificationBroadcasterSupport emitter;

    public CapsuleContainer(Path cacheDir) {
        this.cacheDir = cacheDir;
        this.emitter = this.createEmitter();
        this.registerMBean("co.paralleluniverse:type=CapsuleContainer", this.getMBeanInterface());
    }

    protected Class<?> getMBeanInterface() {
        return CapsuleContainerMBean.class;
    }

    protected NotificationBroadcasterSupport createEmitter() {
        MBeanNotificationInfo launch = new MBeanNotificationInfo(new String[]{"capsule.launch"}, CapsuleProcessLaunched.class.getName(), "Notification about a capsule process having launched.");
        MBeanNotificationInfo death = new MBeanNotificationInfo(new String[]{"capsule.death"}, CapsuleProcessKilled.class.getName(), "Notification about a capsule process having launched.");
        return new NotificationBroadcasterSupport(launch, death);
    }

    private void registerMBean(String name, Class<?> mbeanInterface) {
        try {
            StandardEmitterMBean mbean = new StandardEmitterMBean(this, mbeanInterface, (NotificationEmitter)this.emitter);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName(name);
            mbs.registerMBean(mbean, mxbeanName);
        }
        catch (InstanceAlreadyExistsException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanRegistrationException ex) {
            throw new RuntimeException(ex);
        }
        catch (NotCompliantMBeanException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public String launchCapsule(Path capsulePath, List<String> cmdLine, List<String> args) throws IOException {
        return this.launchCapsule(CapsuleLauncher.newCapsule(capsulePath, this.cacheDir), cmdLine, args);
    }

    private String launchCapsule(Object capsule, List<String> cmdLine, List<String> args) throws IOException {
        if (cmdLine == null) {
            cmdLine = Collections.emptyList();
        }
        try {
            ProcessBuilder pb = CapsuleLauncher.prepareForLaunch(capsule, CapsuleLauncher.enableJMX(cmdLine), args.toArray(new String[args.size()]));
            pb = this.configureCapsuleProcess(pb);
            Process p = pb.start();
            String id = this.createProcessId(CapsuleLauncher.getAppId(capsule), p);
            ProcessInfo pi = this.mountProcess(p, id);
            this.processes.put(id, pi);
            this.emitter.sendNotification(new CapsuleProcessLaunched(this, this.notificationSequence.incrementAndGet(), id));
            this.onProcessLaunch(id, pi);
            this.monitorProcess(id, p);
            return id;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected ProcessInfo mountProcess(Process p, String id) throws IOException, InstanceAlreadyExistsException {
        return new ProcessInfo(p);
    }

    protected ProcessBuilder configureCapsuleProcess(ProcessBuilder pb) throws IOException {
        return pb;
    }

    protected void processDied(String id, Process p, int exitValue) {
        this.emitter.sendNotification(new CapsuleProcessKilled(this, this.notificationSequence.incrementAndGet(), id, exitValue));
        this.onProcessDeath(id, this.getProcessInfo(id), exitValue);
    }

    protected void onProcessLaunch(String id, ProcessInfo pi) {
    }

    protected void onProcessDeath(String id, ProcessInfo pi, int exitValue) {
    }

    private void monitorProcess(final String id, final Process p) {
        new Thread("process-monitor-" + id){

            @Override
            public void run() {
                try {
                    int exit = p.waitFor();
                    CapsuleContainer.this.processDied(id, p, exit);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    protected String createProcessId(String appId, Process p) {
        return appId + "-" + this.counter.incrementAndGet();
    }

    public final Map<String, Process> getProcessInfo() {
        HashMap m = new HashMap();
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            Process p = (Process)e.getValue();
            if (CapsuleContainer.isAlive(p)) {
                m.put(e.getKey(), p);
                continue;
            }
            it.remove();
        }
        return Collections.unmodifiableMap(m);
    }

    protected ProcessInfo getProcessInfo(String id) {
        ProcessInfo pi = (ProcessInfo)this.processes.get(id);
        if (pi == null) {
            return null;
        }
        if (CapsuleContainer.isAlive(pi.process)) {
            return pi;
        }
        this.processes.remove(id, pi);
        return null;
    }

    public final Process getProcess(String id) {
        ProcessInfo pi = this.getProcessInfo(id);
        return pi != null ? pi.process : null;
    }

    @Override
    public Set<String> getProcesses() {
        return this.processes.keySet();
    }

    @Override
    public void killProcess(String id) {
        ProcessInfo pi = this.getProcessInfo(id);
        if (pi != null) {
            pi.process.destroy();
        }
    }

    private static boolean isAlive(Process p) {
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    protected static class ProcessInfo {
        final Process process;

        public ProcessInfo(Process process) {
            this.process = process;
        }
    }
}

