/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public final class ProcessUtil {
    private static volatile Field pidField;
    private static final String PROP_LOCAL_CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private static final String PROP_JAVA_HOME = "java.home";
    private static final Path MANAGEMENT_AGENT;

    public static int getPid(Process process) {
        if (!process.getClass().getName().equals("java.lang.UNIXProcess")) {
            throw new UnsupportedOperationException("This operation is only supported in POSIX environments (Linux/Unix/MacOS");
        }
        if (pidField == null) {
            try {
                Field f = process.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pidField = f;
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return pidField.getInt(process);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static JMXServiceURL getLocalConnectorAddress(String id, boolean startAgent) {
        VirtualMachine vm = null;
        try {
            vm = VirtualMachine.attach(id);
            String connectorAddr = vm.getAgentProperties().getProperty(PROP_LOCAL_CONNECTOR_ADDRESS);
            if (connectorAddr == null && startAgent) {
                String agent = Paths.get(vm.getSystemProperties().getProperty(PROP_JAVA_HOME), new String[0]).resolve(MANAGEMENT_AGENT).toString();
                vm.loadAgent(agent);
                connectorAddr = vm.getAgentProperties().getProperty(PROP_LOCAL_CONNECTOR_ADDRESS);
            }
            JMXServiceURL url = connectorAddr != null ? new JMXServiceURL(connectorAddr) : null;
            vm.detach();
            return url;
        }
        catch (AttachNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (Exception e) {
            try {
                if (vm != null) {
                    vm.detach();
                }
            }
            catch (IOException ex) {
                e.addSuppressed(ex);
            }
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public static JMXServiceURL getLocalConnectorAddress(Process p, boolean startAgent) {
        return ProcessUtil.getLocalConnectorAddress(Integer.toString(ProcessUtil.getPid(p)), startAgent);
    }

    public static MBeanServerConnection getMBeanServerConnection(Process p, boolean startAgent) {
        try {
            JMXServiceURL serviceURL = ProcessUtil.getLocalConnectorAddress(p, startAgent);
            JMXConnector connector = JMXConnectorFactory.connect(serviceURL);
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            return mbsc;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ProcessUtil() {
    }

    static {
        MANAGEMENT_AGENT = Paths.get("lib", "management-agent.jar");
    }
}

