/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import sun.misc.CompoundEnumeration;

public class PathClassLoader
extends ClassLoader {
    private final Object[] paths;
    private final boolean childFirst;
    private final ThreadLocal<Boolean> inGetResourceAsStream = new ThreadLocal();

    public PathClassLoader(Path[] paths, ClassLoader parent, boolean childFirst) throws IOException {
        super(parent);
        this.paths = PathClassLoader.process(paths);
        this.childFirst = childFirst;
    }

    public PathClassLoader(Path[] paths, boolean childFirst) throws IOException {
        this.paths = PathClassLoader.process(paths);
        this.childFirst = childFirst;
    }

    public PathClassLoader(Path[] paths, ClassLoader parent) throws IOException {
        this(paths, parent, false);
    }

    public PathClassLoader(Path[] paths) throws IOException {
        this(paths, false);
    }

    private static Object[] process(Path[] paths) throws IOException {
        try {
            Object[] os = new Object[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                Path p = paths[i];
                Object o = Files.isRegularFile(p, new LinkOption[0]) ? FileSystems.newFileSystem(p, null) : p;
                os[i] = o;
            }
            return os;
        }
        catch (ProviderNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public final void close() {
        IOException ex = null;
        for (Object p : this.paths) {
            if (!(p instanceof FileSystem)) continue;
            try {
                ((FileSystem)p).close();
            }
            catch (IOException e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
    }

    @Override
    public URL getResource(String name) {
        if (!this.childFirst) {
            return super.getResource(name);
        }
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String name) {
        this.inGetResourceAsStream.set(Boolean.TRUE);
        try {
            InputStream is = null;
            if (!this.childFirst) {
                is = super.getResourceAsStream(name);
            }
            if (is == null) {
                is = this.findResourceAsStream(name);
            }
            if (is == null && this.childFirst) {
                is = super.getResourceAsStream(name);
            }
            InputStream inputStream = is;
            return inputStream;
        }
        finally {
            this.inGetResourceAsStream.remove();
        }
    }

    private Path resolve(Object o, String name) {
        Path p = o instanceof FileSystem ? ((FileSystem)o).getPath(name, new String[0]) : ((Path)o).resolve(name);
        return p;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!this.childFirst) {
            return super.loadClass(name, resolve);
        }
        try {
            Class<?> c = this.findClass(name);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] buf = this.readResource(name.replace('.', '/') + ".class");
        if (buf == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, buf, 0, buf.length);
    }

    @Override
    protected URL findResource(String name) {
        if (this.inGetResourceAsStream.get() == Boolean.TRUE) {
            return null;
        }
        try {
            for (Object o : this.paths) {
                Path p = this.resolve(o, name);
                if (!Files.exists(p, new LinkOption[0])) continue;
                return p.toUri().toURL();
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[2];
        tmp[this.childFirst ? 1 : 0] = super.getResources(name);
        tmp[this.childFirst ? 0 : 1] = this.findResources1(name);
        return new CompoundEnumeration(tmp);
    }

    protected Enumeration<URL> findResources1(String name) throws IOException {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Object o : this.paths) {
                Path p = this.resolve(o, name);
                if (!Files.exists(p, new LinkOption[0])) continue;
                urls.add(p.toUri().toURL());
            }
            return Collections.enumeration(urls);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream findResourceAsStream(String name) {
        try {
            for (Object o : this.paths) {
                Path p = this.resolve(o, name);
                if (!this.isFileResource(p)) continue;
                return Files.newInputStream(p, new OpenOption[0]);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] readResource(String name) {
        try {
            for (Object o : this.paths) {
                Path p = this.resolve(o, name);
                if (!this.isFileResource(p)) continue;
                return Files.readAllBytes(p);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isFileResource(Path p) {
        return Files.exists(p, new LinkOption[0]) && !Files.isDirectory(p, new LinkOption[0]);
    }
}

