/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarClassLoader
extends ClassLoader {
    private final Manifest mf;
    private final byte[] jar;

    public JarClassLoader(byte[] jar, ClassLoader parent) {
        super(parent);
        this.jar = jar;
        try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(jar));){
            this.mf = jis.getManifest();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public JarClassLoader(byte[] jar) {
        this.jar = jar;
        try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(jar));){
            this.mf = jis.getManifest();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Manifest getManifest() {
        return this.mf;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = super.getResourceAsStream(name);
        if (is == null) {
            is = this.getEntryAsStream(name);
        }
        return is;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] buf = this.getEntry(name.replace('.', '/') + ".class");
        if (buf == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, buf, 0, buf.length);
    }

    private InputStream getEntryAsStream(String path) {
        try {
            ZipEntry entry;
            ZipInputStream jis = new ZipInputStream(new ByteArrayInputStream(this.jar));
            while ((entry = jis.getNextEntry()) != null) {
                if (!path.equalsIgnoreCase(entry.getName())) continue;
                if (entry.isDirectory()) {
                    throw new FileNotFoundException(path + " is a directory");
                }
                return jis;
            }
            return null;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getEntry(String path) {
        try (ZipInputStream jis = new ZipInputStream(new ByteArrayInputStream(this.jar));){
            ZipEntry entry;
            while ((entry = jis.getNextEntry()) != null) {
                if (!path.equalsIgnoreCase(entry.getName())) continue;
                if (entry.isDirectory()) {
                    throw new FileNotFoundException(path + " is a directory");
                }
                byte[] buf = new byte[(int)entry.getSize()];
                int n = 0;
                while (true) {
                    if (n == -1) {
                        byte[] byArray = buf;
                        return byArray;
                    }
                    n = jis.read(buf, n, buf.length - n);
                }
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

