/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.capsule;

import co.paralleluniverse.capsule.CapsuleContainer;
import co.paralleluniverse.common.ProcessUtil;
import java.io.IOException;
import java.nio.file.Path;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class MBeanCapsuleContainer
extends CapsuleContainer {
    public MBeanCapsuleContainer(Path cacheDir) {
        super(cacheDir);
    }

    @Override
    protected String createProcessId(String appId, Process p) {
        return super.createProcessId(appId, p) + "@" + ProcessUtil.getPid(p);
    }

    @Override
    protected CapsuleContainer.ProcessInfo mountProcess(Process p, String id) throws IOException, InstanceAlreadyExistsException {
        JMXServiceURL connectorAddress = ProcessUtil.getLocalConnectorAddress(p, false);
        return new ProcessInfo(p, connectorAddress);
    }

    @Override
    protected ProcessInfo getProcessInfo(String id) {
        return (ProcessInfo)super.getProcessInfo(id);
    }

    public final MBeanServerConnection getProcessMBeans(String id) {
        ProcessInfo pi = this.getProcessInfo(id);
        return pi != null ? pi.getJMX() : null;
    }

    protected static class ProcessInfo
    extends CapsuleContainer.ProcessInfo {
        final JMXServiceURL connectorAddress;
        private MBeanServerConnection jmx;

        public ProcessInfo(Process process, JMXServiceURL connectorAddress) {
            super(process);
            this.connectorAddress = connectorAddress;
        }

        public synchronized MBeanServerConnection getJMX() {
            try {
                if (this.jmx == null) {
                    this.jmx = JMXConnectorFactory.connect(this.connectorAddress).getMBeanServerConnection();
                }
                return this.jmx;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

