/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.capsule;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class CapsuleLauncher {
    private static final String CAPSULE_CLASS_NAME = "Capsule";
    private static final String OPT_JMX_REMOTE = "com.sun.management.jmxremote";
    private static final String ATTR_MAIN_CLASS = "Main-Class";

    public static Object getCapsule(Path path, Path cacheDir) {
        try {
            Manifest mf;
            try (JarFile jar = new JarFile(path.toFile());){
                mf = jar.getManifest();
            }
            URLClassLoader cl = new URLClassLoader(new URL[]{path.toUri().toURL()});
            Class clazz = CapsuleLauncher.loadCapsuleClass(mf, cl);
            if (clazz == null) {
                throw new RuntimeException(path + " does not appear to be a valid capsule.");
            }
            return CapsuleLauncher.getCapsuleConstructor(clazz, Path.class, Path.class).newInstance(path, cacheDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not create capsule instance.", e);
        }
    }

    public static ProcessBuilder prepareForLaunch(Object capsule, List<String> cmdLine, String[] args) {
        Method launch = CapsuleLauncher.getCapsuleMethod(capsule, "prepareForLaunch", List.class, String[].class);
        return (ProcessBuilder)CapsuleLauncher.invoke(capsule, launch, cmdLine, args);
    }

    public static String getAppId(Object capsule) {
        Method appId = CapsuleLauncher.getCapsuleMethod(capsule, "appId", String[].class);
        return (String)CapsuleLauncher.invoke(capsule, appId, new Object[]{null});
    }

    private static Class loadCapsuleClass(Manifest mf, ClassLoader cl) {
        String mainClass;
        String string = mainClass = mf.getMainAttributes() != null ? mf.getMainAttributes().getValue(ATTR_MAIN_CLASS) : null;
        if (mainClass == null) {
            return null;
        }
        try {
            Class<?> clazz = cl.loadClass(mainClass);
            if (!CapsuleLauncher.isCapsuleClass(clazz)) {
                clazz = null;
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static boolean isCapsuleClass(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (CAPSULE_CLASS_NAME.equals(clazz.getName())) {
            return true;
        }
        return CapsuleLauncher.isCapsuleClass(clazz.getSuperclass());
    }

    private static Constructor<?> getCapsuleConstructor(Class<?> capsuleClass, Class<?> ... paramTypes) throws NoSuchMethodException {
        Constructor<?> ctor = capsuleClass.getDeclaredConstructor(paramTypes);
        ctor.setAccessible(true);
        return ctor;
    }

    private static Method getCapsuleMethod(Object capsule, String name, Class<?> ... paramTypes) {
        Method m = CapsuleLauncher.getMethod(capsule.getClass(), name, paramTypes);
        if (m == null) {
            throw new RuntimeException("Could not call " + name + " on " + capsule + ". It does not appear to be a valid capsule.");
        }
        return m;
    }

    private static Method getMethod(Class clazz, String name, Class<?> ... paramTypes) {
        try {
            Method method = clazz.getDeclaredMethod(name, paramTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            return clazz.getSuperclass() != null ? CapsuleLauncher.getMethod(clazz.getSuperclass(), name, paramTypes) : null;
        }
    }

    private static Object invoke(Object obj, Method method, Object ... params) {
        try {
            return method.invoke(obj, params);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }

    public static List<String> enableJMX(List<String> cmdLine) {
        String arg = "-Dcom.sun.management.jmxremote";
        if (cmdLine.contains("-Dcom.sun.management.jmxremote")) {
            return cmdLine;
        }
        ArrayList<String> cmdLine2 = new ArrayList<String>(cmdLine);
        cmdLine2.add("-Dcom.sun.management.jmxremote");
        return cmdLine2;
    }

    private CapsuleLauncher() {
    }
}

