/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.capsule;

import co.paralleluniverse.capsule.CapsuleLauncher;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.InstanceAlreadyExistsException;

public class CapsuleContainer {
    private final ConcurrentMap<String, ProcessInfo> processes = new ConcurrentHashMap<String, ProcessInfo>();
    private final AtomicInteger counter = new AtomicInteger();
    private final Path cacheDir;

    public CapsuleContainer(Path cacheDir) {
        this.cacheDir = cacheDir;
    }

    public String launchCapsule(Path capsulePath, List<String> cmdLine, String[] args) throws IOException {
        return this.launchCapsule(CapsuleLauncher.getCapsule(capsulePath, this.cacheDir), cmdLine, args);
    }

    private String launchCapsule(Object capsule, List<String> cmdLine, String[] args) throws IOException {
        try {
            ProcessBuilder pb = this.configureCapsuleProcess(CapsuleLauncher.prepareForLaunch(capsule, CapsuleLauncher.enableJMX(cmdLine), args));
            Process p = pb.start();
            String id = this.createProcessId(CapsuleLauncher.getAppId(capsule), p);
            ProcessInfo pi = this.mountProcess(p, id);
            this.processes.put(id, pi);
            return id;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected ProcessInfo mountProcess(Process p, String id) throws IOException, InstanceAlreadyExistsException {
        return new ProcessInfo(p);
    }

    protected ProcessBuilder configureCapsuleProcess(ProcessBuilder pb) throws IOException {
        return pb;
    }

    protected String createProcessId(String appId, Process p) {
        return appId + "-" + this.counter.incrementAndGet();
    }

    public final Map<String, Process> getProcesses() {
        HashMap m = new HashMap();
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            Process p = (Process)e.getValue();
            if (CapsuleContainer.isAlive(p)) {
                m.put(e.getKey(), p);
                continue;
            }
            it.remove();
        }
        return Collections.unmodifiableMap(m);
    }

    protected ProcessInfo getProcessInfo(String id) {
        ProcessInfo pi = (ProcessInfo)this.processes.get(id);
        if (pi == null) {
            return null;
        }
        if (CapsuleContainer.isAlive(pi.process)) {
            return pi;
        }
        this.processes.remove(id, pi);
        return null;
    }

    public final Process getProcess(String id) {
        ProcessInfo pi = this.getProcessInfo(id);
        return pi != null ? pi.process : null;
    }

    private static boolean isAlive(Process p) {
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    protected static class ProcessInfo {
        final Process process;

        public ProcessInfo(Process process) {
            this.process = process;
        }
    }
}

