/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ShieldedCapsule
extends Capsule {
    private static final String SEP = File.separator;
    private static final String PROP_JAVA_VERSION = "java.version";
    private static final String PROP_JAVA_HOME = "java.home";
    private static final String PROP_OS_NAME = "os.name";
    private static final String PROP_UID_MAP_START = "capsule.shield.lxc.unprivileged.uidMapStart";
    private static final String PROP_UID_MAP_START_DEFAULT = "100000";
    private static final String PROP_GID_MAP_START = "capsule.shield.lxc.unprivileged.gidMapStart";
    private static final String PROP_GID_MAP_START_DEFAULT = "100000";
    private static final String PROP_UID_MAP_SIZE = "capsule.shield.lxc.unprivileged.uidMapSize";
    private static final String PROP_UID_MAP_SIZE_DEFAULT = "65536";
    private static final String PROP_GID_MAP_SIZE = "capsule.shield.lxc.unprivileged.gidMapSize";
    private static final String PROP_GID_MAP_SIZE_DEFAULT = "65535";
    private static final String PROP_LXC_PRIVILEGED = "capsule.shield.lxc.privileged";
    private static final String PROP_LXC_PRIVILEGED_DEFAULT = "false";
    private static final String PROP_LXC_SYSSHAREDIR = "capsule.shield.lxc.sysShareDir";
    private static final String PROP_LXC_SYSSHAREDIR_DEFAULT = "/usr/share/lxc";
    private static final String PROP_LXC_NETWORKING_TYPE = "capsule.shield.lxc.networkingType";
    private static final Map.Entry<String, String> ATTR_LXC_NETWORKING_TYPE = ShieldedCapsule.ATTRIBUTE("LXC-Networking-Type", ShieldedCapsule.T_STRING(), "veth", true, "");
    private static final String PROP_LXC_NETWORK_BRIDGE = "capsule.shield.lxc.networkBridge";
    private static final Map.Entry<String, String> ATTR_LXC_NETWORK_BRIDGE = ShieldedCapsule.ATTRIBUTE("LXC-Network-Bridge", ShieldedCapsule.T_STRING(), "lxcbr0", true, "");
    private static final String PROP_LXC_ALLOW_TTY = "capsule.shield.lxc.allowTTY";
    private static final Map.Entry<String, Boolean> ATTR_LXC_ALLOW_TTY = ShieldedCapsule.ATTRIBUTE("LXC-Allow-TTY", ShieldedCapsule.T_BOOL(), false, true, "");
    private static final String PROP_HOSTNAME = "capsule.shield.hostname";
    private static final Map.Entry<String, String> ATTR_HOSTNAME = ShieldedCapsule.ATTRIBUTE("Hostname", ShieldedCapsule.T_STRING(), null, true, "");
    private static final String PROP_ALLOWED_DEVICES = "capsule.shield.allowedDevices";
    private static final Map.Entry<String, List<String>> ATTR_ALLOWED_DEVICES = ShieldedCapsule.ATTRIBUTE("Allowed-Devices", ShieldedCapsule.T_LIST(ShieldedCapsule.T_STRING()), null, true, "");
    private static final String PROP_CPU_SHARES = "capsule.shield.cpuShares";
    private static final Map.Entry<String, Long> ATTR_CPU_SHARES = ShieldedCapsule.ATTRIBUTE("CPU-Shares", ShieldedCapsule.T_LONG(), null, true, "");
    private static final String PROP_MEMORY_LIMIT = "capsule.shield.memoryLimit";
    private static final Map.Entry<String, Long> ATTR_MEMORY_LIMIT = ShieldedCapsule.ATTRIBUTE("Memory-Limit", ShieldedCapsule.T_LONG(), null, true, "");
    private static final String CONTAINER_NAME = "lxc";
    private static final String HOST_APPCACHE_RELATIVE_CONTAINER_DIR_PARENT = "capsule-shield";
    private static final String HOST_APPCACHE_RELATIVE_CONTAINER_DIR = "capsule-shield" + SEP + "lxc";
    private static final Path CONTAINER_ABSOLUTE_JAVA_HOME = Paths.get(SEP + "java", new String[0]);
    private static final Path CONTAINER_ABSOLUTE_JAR_HOME = Paths.get(SEP + "capsule" + SEP + "jar", new String[0]);
    private static final Path CONTAINER_ABSOLUTE_WRAPPER_HOME = Paths.get(SEP + "capsule" + SEP + "wrapper", new String[0]);
    private static final Path CONTAINER_ABSOLUTE_CAPSULE_HOME = Paths.get(SEP + "capsule" + SEP + "app", new String[0]);
    private static final Path CONTAINER_ABSOLUTE_DEP_HOME = Paths.get(SEP + "capsule" + SEP + "deps", new String[0]);
    private static String distroType;
    private static Boolean isLXCInstalled;
    private static Path hostAbsoluteContainerDir;
    private static Path hostAbsoluteOwnJarFile;
    private Path origJavaHome;
    private Path localRepo;

    public ShieldedCapsule(Capsule pred) {
        super(pred);
        if (!ShieldedCapsule.isLinux()) {
            throw new RuntimeException("Unsupported environment: Currently shielded capsules are only supported on linux.");
        }
        if (!ShieldedCapsule.isLXCInstalled()) {
            throw new RuntimeException("Unsupported environment: LXC tooling not found");
        }
    }

    @Override
    protected final ProcessBuilder prelaunch(List<String> jvmArgs, List<String> args) {
        this.localRepo = this.getLocalRepo();
        try {
            if (this.isBuildNeeded()) {
                this.createContainer();
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        ProcessBuilder pb = super.prelaunch(jvmArgs, args);
        pb.command().addAll(0, Arrays.asList("lxc-execute", "--logfile=lxc.log", "--logpriority=" + ShieldedCapsule.lxcLogLevel(ShieldedCapsule.getLogLevel()), "-P", this.getContainerParentDir().toString(), "-n", CONTAINER_NAME, "--", "/networked"));
        return pb;
    }

    private boolean isBuildNeeded() {
        if (!Files.exists(this.getConfFile(), new LinkOption[0])) {
            return true;
        }
        try {
            FileTime confTime;
            FileTime wrapperTime;
            FileTime jarTime = Files.getLastModifiedTime(this.getJarFile(), new LinkOption[0]);
            if (this.isWrapperCapsule() && (wrapperTime = Files.getLastModifiedTime(ShieldedCapsule.findOwnJarFile(), new LinkOption[0])).compareTo(jarTime) > 0) {
                jarTime = wrapperTime;
            }
            return (confTime = Files.getLastModifiedTime(this.getConfFile(), new LinkOption[0])).compareTo(jarTime) < 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createContainer() throws IOException, InterruptedException {
        if (this.isThereSuchContainerAlready()) {
            ShieldedCapsule.log(2, "Destroying existing LXC container");
            ShieldedCapsule.exec("lxc-destroy", "-n", CONTAINER_NAME, "-P", this.getContainerParentDir().toString());
        }
        this.getWritableAppCache();
        ShieldedCapsule.log(2, "Writing LXC configuration");
        this.writeConfFile();
        ShieldedCapsule.log(2, "Written conf file: " + this.getConfFile());
        ShieldedCapsule.log(2, "Creating rootfs");
        this.createRootFS();
        ShieldedCapsule.log(2, "Rootfs created at: " + this.getRootFSDir());
    }

    private void createRootFS() throws IOException, InterruptedException {
        this.createRootFSLayout();
        this.chownRootFS();
    }

    private void createRootFSLayout() throws IOException {
        Path ret = this.getRootFSDir();
        Files.createDirectories(ret.resolve("bin"), new FileAttribute[0]);
        Path capsule = ret.resolve("capsule");
        Files.createDirectories(capsule.resolve("app"), new FileAttribute[0]);
        Files.createDirectory(capsule.resolve("deps"), new FileAttribute[0]);
        Files.createDirectory(capsule.resolve("jar"), new FileAttribute[0]);
        Files.createDirectory(capsule.resolve("wrapper"), new FileAttribute[0]);
        Path run = ret.resolve("run");
        Files.createDirectories(run.resolve("network"), new FileAttribute[0]);
        Files.createDirectories(run.resolve("resolveconf").resolve("interface"), new FileAttribute[0]);
        Files.createDirectory(run.resolve("lock"), new FileAttribute[0]);
        ShieldedCapsule.exec("chmod", "+t", run.resolve("lock").toAbsolutePath().normalize().toString());
        Files.createDirectory(run.resolve("shm"), new FileAttribute[0]);
        ShieldedCapsule.exec("chmod", "+t", run.resolve("shm").toAbsolutePath().normalize().toString());
        Path dev = ret.resolve("dev");
        Files.createDirectories(dev.resolve("mqueue"), new FileAttribute[0]);
        Files.createDirectory(dev.resolve("pts"), new FileAttribute[0]);
        Files.createSymbolicLink(dev.resolve("shm"), dev.relativize(run.resolve("shm")), new FileAttribute[0]);
        Path var = ret.resolve("var");
        Files.createDirectory(var, new FileAttribute[0]);
        Files.createSymbolicLink(var.resolve("run"), var.relativize(run), new FileAttribute[0]);
        Path etc = ret.resolve("etc");
        Files.createDirectory(etc, new FileAttribute[0]);
        Files.createFile(etc.resolve("fstab"), new FileAttribute[0]);
        Files.createDirectory(etc.resolve("dhcp"), new FileAttribute[0]);
        Path dhclientconf = etc.resolve("dhcp").resolve("dhclient.conf");
        try (PrintWriter out = new PrintWriter(Files.newOutputStream(dhclientconf, StandardOpenOption.CREATE));){
            out.println("option rfc3442-classless-static-routes code 121 = array of unsigned integer 8;");
            out.println("send host-name = gethostname();");
            out.println("request subnet-mask, broadcast-address, time-offset, routers,\n        domain-name, domain-name-servers, domain-search, host-name,\n        dhcp6.name-servers, dhcp6.domain-search,\n        netbios-name-servers, netbios-scope, interface-mtu,\n        rfc3442-classless-static-routes, ntp-servers,\n        dhcp6.fqdn, dhcp6.sntp-servers;");
        }
        Files.createDirectory(ret.resolve("java"), new FileAttribute[0]);
        Files.createDirectory(ret.resolve("lib"), new FileAttribute[0]);
        Files.createDirectory(ret.resolve("lib64"), new FileAttribute[0]);
        Files.createDirectory(ret.resolve("proc"), new FileAttribute[0]);
        Files.createDirectory(ret.resolve("sbin"), new FileAttribute[0]);
        Files.createDirectory(ret.resolve("sys"), new FileAttribute[0]);
        Files.createDirectory(ret.resolve("usr"), new FileAttribute[0]);
        Path tmp = ret.resolve("tmp");
        Files.createDirectory(tmp, new FileAttribute[0]);
        ShieldedCapsule.exec("chmod", "+t", tmp.toAbsolutePath().normalize().toString());
        Path networked = ret.resolve("networked");
        Files.createFile(networked, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxr-x")));
        try (PrintWriter out = new PrintWriter(Files.newOutputStream(networked, StandardOpenOption.APPEND));){
            out.println("#!/bin/bash\n\n#\n# Copyright (c) 2015, Parallel Universe Software Co. and Contributors. All rights reserved.\n#\n# This program and the accompanying materials are licensed under the terms\n# of the Eclipse Public License v1.0, available at\n# http://www.eclipse.org/legal/epl-v10.html\n#\n\n# Execute a command with networking enabled.\n#\n# @author circlespainter\n\n/sbin/ifconfig lo 127.0.0.1\n/sbin/route add -net 127.0.0.0 netmask 255.0.0.0 lo\n/sbin/dhclient\nexport JAVA_HOME=/java\n\"$@\"\nRET=$?\nif [ -f \"/run/dhclient.pid\" ]; then\n    DHCLIENT_PID=`/bin/cat /run/dhclient.pid`;\n    if [ -n $DHCLIENT_PID ]; then\n        /bin/kill `/bin/cat /run/dhclient.pid`;\n    fi\nfi\nexit $RET\n");
        }
    }

    private void chownRootFS() throws IOException, InterruptedException {
        Long gidMapStart;
        Long uidMapStart;
        try {
            uidMapStart = Long.parseLong(System.getProperty(PROP_UID_MAP_START, "100000"));
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot parse sysprop capsule.shield.lxc.unprivileged.uidMapStart into a Long value", t);
        }
        try {
            gidMapStart = Long.parseLong(System.getProperty(PROP_GID_MAP_START, "100000"));
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot parse sysprop capsule.shield.lxc.unprivileged.gidMapStart into a Long value", t);
        }
        Long currentUID = ShieldedCapsule.getCurrentUID();
        Long currentGID = ShieldedCapsule.getCurrentGID();
        String meAsNSRootUIDMap = "u:0:" + currentUID + ":1";
        String meAsNSRootGIDMap = "g:0:" + currentGID + ":1";
        String nsRootAs1UIDMap = "u:1:" + uidMapStart + ":1";
        String nsRootAs1GIDMap = "g:1:" + gidMapStart + ":1";
        ShieldedCapsule.exec("lxc-usernsexec", "-m", meAsNSRootUIDMap, "-m", meAsNSRootGIDMap, "-m", nsRootAs1UIDMap, "-m", nsRootAs1GIDMap, "--", "chown", "-R", "1:1", this.getRootFSDir().toString());
    }

    private void writeConfFile() throws IOException {
        Files.createDirectories(this.getContainerDir(), new FileAttribute[0]);
        try (PrintWriter out = new PrintWriter(Files.newOutputStream(this.getConfFile(), StandardOpenOption.CREATE));){
            Long cpuShares;
            Long sizeGidMap;
            Long sizeUidMap;
            Long gidMapStart;
            Long uidMapStart;
            String lxcConfig = System.getProperty(PROP_LXC_SYSSHAREDIR, PROP_LXC_SYSSHAREDIR_DEFAULT) + SEP + "config";
            boolean privileged = false;
            try {
                privileged = Boolean.parseBoolean(System.getProperty(PROP_LXC_PRIVILEGED, PROP_LXC_PRIVILEGED_DEFAULT));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String networkType = this.getPropertyOrAttributeString(PROP_LXC_NETWORKING_TYPE, ATTR_LXC_NETWORKING_TYPE);
            String networkBridge = this.getPropertyOrAttributeString(PROP_LXC_NETWORK_BRIDGE, ATTR_LXC_NETWORK_BRIDGE);
            boolean tty = this.getPropertyOrAttributeBool(PROP_LXC_ALLOW_TTY, ATTR_LXC_ALLOW_TTY);
            String hostname = this.getPropertyOrAttributeString(PROP_HOSTNAME, ATTR_HOSTNAME);
            try {
                uidMapStart = Long.parseLong(System.getProperty(PROP_UID_MAP_START, "100000"));
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot parse sysprop capsule.shield.lxc.unprivileged.uidMapStart into a Long value", t);
            }
            try {
                gidMapStart = Long.parseLong(System.getProperty(PROP_GID_MAP_START, "100000"));
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot parse sysprop capsule.shield.lxc.unprivileged.gidMapStart into a Long value", t);
            }
            try {
                sizeUidMap = Long.parseLong(System.getProperty(PROP_UID_MAP_SIZE, PROP_UID_MAP_SIZE_DEFAULT));
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot parse sysprop capsule.shield.lxc.unprivileged.uidMapSize into a Long value", t);
            }
            try {
                sizeGidMap = Long.parseLong(System.getProperty(PROP_GID_MAP_SIZE, PROP_GID_MAP_SIZE_DEFAULT));
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot parse sysprop capsule.shield.lxc.unprivileged.gidMapSize into a Long value", t);
            }
            out.println("#\n# Copyright (c) 2015, Parallel Universe Software Co. and Contributors. All rights reserved.\n#\n# This program and the accompanying materials are licensed under the terms\n# of the Eclipse Public License v1.0, available at\n# http://www.eclipse.org/legal/epl-v10.html\n#\n\n# Container configuration file\n#\n# @author circlespainter\n");
            out.println("\n## Distro includes");
            out.println("lxc.include = " + lxcConfig + SEP + ShieldedCapsule.getDistroType() + ".common.conf");
            out.println("lxc.include = " + lxcConfig + SEP + ShieldedCapsule.getDistroType() + ".userns.conf");
            if (!privileged) {
                out.println("\n## Unprivileged container user map");
                out.println("lxc.id_map = u 0 " + uidMapStart + " " + sizeUidMap + "\n" + "lxc.id_map = g 0 " + gidMapStart + " " + sizeGidMap);
            }
            out.println("\n## System mounts\nlxc.mount.entry = " + SEP + "sbin sbin none bind 0 0\n" + "lxc.mount.entry = " + SEP + "usr usr none bind 0 0\n" + "lxc.mount.entry = " + SEP + "bin bin none bind 0 0\n" + "lxc.mount.entry = " + SEP + "lib lib none bind 0 0\n" + "lxc.mount.entry = " + SEP + "lib64 lib64 none bind 0 0\n");
            out.println("\n## Capsule mounts");
            this.getJavaHome();
            out.println("lxc.mount.entry = " + this.origJavaHome + " " + CONTAINER_ABSOLUTE_JAVA_HOME.toString().substring(1) + " none ro,bind 0 0");
            out.println("lxc.mount.entry = " + this.getJarFile().getParent() + " " + CONTAINER_ABSOLUTE_JAR_HOME.toString().substring(1) + " none ro,bind 0 0");
            if (this.isWrapperCapsule()) {
                out.println("lxc.mount.entry = " + ShieldedCapsule.findOwnJarFile().getParent() + " " + CONTAINER_ABSOLUTE_WRAPPER_HOME.toString().substring(1) + " none ro,bind 0 0");
            }
            out.println("lxc.mount.entry = " + this.appDir() + " " + CONTAINER_ABSOLUTE_CAPSULE_HOME.toString().substring(1) + " none ro,bind 0 0");
            if (this.localRepo != null) {
                out.println("lxc.mount.entry = " + this.localRepo + " " + CONTAINER_ABSOLUTE_DEP_HOME.toString().substring(1) + " none ro,bind 0 0");
            }
            out.println("\n## Console");
            out.println("lxc.console = none");
            out.println("lxc.pts = 1024");
            out.println("lxc.tty = 1");
            if (tty) {
                out.println("lxc.mount.entry = dev" + SEP + "console " + SEP + "dev" + SEP + "console none bind,rw 0 0");
            }
            out.println("\n## Hostname");
            out.println("lxc.utsname = " + (hostname != null ? hostname : this.getAppId()));
            out.println("\n## Network");
            if ("veth".equals(networkType)) {
                out.println("lxc.network.type = veth\nlxc.network.flags = up\nlxc.network.link = " + networkBridge + "\n" + "lxc.network.name = eth0");
            } else if ("host".equals(networkType)) {
                out.println("lxc.network.type = none");
            } else {
                out.println("lxc.network.type = empty\nlxc.network.flags = up");
            }
            out.println("\n## Perms");
            if (privileged) {
                out.println("lxc.cgroup.devices.allow = a");
            } else {
                out.println("lxc.cgroup.devices.deny = a");
                List<String> allowedDevices = this.getPropertyOrAttributeStringList(PROP_ALLOWED_DEVICES, ATTR_ALLOWED_DEVICES);
                if (allowedDevices != null) {
                    for (String device : this.getAttribute(ATTR_ALLOWED_DEVICES)) {
                        out.println("lxc.cgroup.devices.allow = " + device);
                    }
                } else {
                    out.println("lxc.cgroup.devices.allow = c 1:3 rwm\nlxc.cgroup.devices.allow = c 1:5 rwm");
                    out.println("lxc.cgroup.devices.allow = c 5:1 rwm\nlxc.cgroup.devices.allow = c 5:0 rwm\nlxc.cgroup.devices.allow = c 4:0 rwm\nlxc.cgroup.devices.allow = c 4:1 rwm");
                    out.println("lxc.cgroup.devices.allow = c 1:9 rwm\nlxc.cgroup.devices.allow = c 1:8 rwm");
                    out.println("lxc.cgroup.devices.allow = c 136:* rwm\nlxc.cgroup.devices.allow = c 5:2 rwm");
                    out.println("lxc.cgroup.devices.allow = c 10:200 rwm");
                }
            }
            if (privileged) {
                out.println("lxc.aa_profile = unconfined");
            }
            out.println("\n## Security");
            out.println("lxc.seccomp = " + lxcConfig + SEP + "common.seccomp");
            out.println("lxc.cap.drop = audit_control audit_write mac_admin mac_override mknod setfcap setpcap sys_boot sys_module sys_nice sys_pacct sys_rawio sys_resource sys_time sys_tty_config");
            out.println("\n## Limits");
            Long memLimit = this.getPropertyOrAttributeLong(PROP_MEMORY_LIMIT, ATTR_MEMORY_LIMIT);
            if (memLimit != null) {
                int maxMem = memLimit.intValue();
                out.println("lxc.cgroup.memory.limit_in_bytes = " + maxMem + "\n" + "lxc.cgroup.memory.soft_limit_in_bytes = " + maxMem + "\n" + "lxc.cgroup.memory.memsw.limit_in_bytes = " + ShieldedCapsule.getMemorySwap(maxMem, true));
            }
            if ((cpuShares = this.getPropertyOrAttributeLong(PROP_CPU_SHARES, ATTR_CPU_SHARES)) != null) {
                out.println("lxc.cgroup.cpu.shares = " + cpuShares);
            }
            out.println("\n## Misc");
            out.println("lxc.kmsg = 0");
            out.println("\n## Root FS");
            out.println("lxc.rootfs = " + this.getRootFSDir());
        }
    }

    private boolean isThereSuchContainerAlready() throws IOException, InterruptedException {
        return new ProcessBuilder("lxc-info", "-n", CONTAINER_NAME, "-P", this.getContainerParentDir().toString()).start().waitFor() == 0;
    }

    @Override
    protected Map.Entry<String, Path> chooseJavaHome() {
        Map.Entry<String, Path> res = super.chooseJavaHome();
        if (res == null) {
            res = ShieldedCapsule.entry(ShieldedCapsule.getProperty(PROP_JAVA_VERSION), Paths.get(ShieldedCapsule.getProperty(PROP_JAVA_HOME), new String[0]));
        }
        this.origJavaHome = res.getValue();
        return ShieldedCapsule.entry(res.getKey(), CONTAINER_ABSOLUTE_JAVA_HOME);
    }

    @Override
    protected List<Path> resolve0(Object x) {
        if (x instanceof Path && ((Path)x).isAbsolute()) {
            Path p = (Path)x;
            p = this.move(p);
            return super.resolve0(p);
        }
        return super.resolve0(x);
    }

    private Path move(Path p) {
        if (p == null) {
            return null;
        }
        if ((p = p.normalize().toAbsolutePath()).startsWith(Paths.get("/capsule", new String[0])) || p.startsWith(Paths.get("/java", new String[0]))) {
            return p;
        }
        if (p.equals(this.getJarFile())) {
            return this.moveJarFile(p);
        }
        if (p.equals(ShieldedCapsule.findOwnJarFile())) {
            return this.moveWrapperFile(p);
        }
        if (this.getAppDir() != null && p.startsWith(this.getAppDir())) {
            return ShieldedCapsule.move(p, this.getAppDir(), CONTAINER_ABSOLUTE_CAPSULE_HOME);
        }
        if (this.localRepo != null && p.startsWith(this.localRepo)) {
            return ShieldedCapsule.move(p, this.localRepo, CONTAINER_ABSOLUTE_DEP_HOME);
        }
        if (this.getPlatformNativeLibraryPath().contains(p)) {
            return p;
        }
        if (p.startsWith(this.getJavaHome())) {
            return p;
        }
        throw new IllegalArgumentException("Unexpected file " + p);
    }

    private Path moveJarFile(Path p) {
        return CONTAINER_ABSOLUTE_JAR_HOME.resolve(p.getFileName());
    }

    private Path moveWrapperFile(Path p) {
        return CONTAINER_ABSOLUTE_WRAPPER_HOME.resolve(p.getFileName());
    }

    private Path getLocalRepo() {
        Capsule mavenCaplet = this.sup("MavenCapsule");
        if (mavenCaplet == null) {
            return null;
        }
        try {
            return (Path)ShieldedCapsule.accessible(mavenCaplet.getClass().getDeclaredMethod("getLocalRepo", new Class[0])).invoke((Object)mavenCaplet, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPropertyOrAttributeString(String propName, Map.Entry<String, String> attr) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return this.getAttribute(attr);
        }
        return propValue;
    }

    private List<String> getPropertyOrAttributeStringList(String propName, Map.Entry<String, List<String>> attr) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return this.getAttribute(attr);
        }
        return Arrays.asList(propValue.split(":"));
    }

    private Long getPropertyOrAttributeLong(String propName, Map.Entry<String, Long> attr) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return this.getAttribute(attr);
        }
        try {
            return Long.parseLong(propValue);
        }
        catch (Throwable t) {
            return this.getAttribute(attr);
        }
    }

    private Boolean getPropertyOrAttributeBool(String propName, Map.Entry<String, Boolean> attr) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return this.getAttribute(attr);
        }
        try {
            return Boolean.parseBoolean(propValue);
        }
        catch (Throwable t) {
            return this.getAttribute(attr);
        }
    }

    private static String lxcLogLevel(int loglevel) {
        loglevel = Math.min(loglevel, 3);
        switch (loglevel) {
            case 0: {
                return "ERROR";
            }
            case 1: {
                return "NOTICE";
            }
            case 2: {
                return "INFO";
            }
            case 3: {
                return "DEBUG";
            }
        }
        throw new IllegalArgumentException("Unrecognized log level: " + loglevel);
    }

    private static boolean isLXCInstalled() {
        if (isLXCInstalled == null) {
            try {
                ShieldedCapsule.exec("lxc-checkconfig");
                isLXCInstalled = true;
                return isLXCInstalled;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                isLXCInstalled = false;
                return isLXCInstalled;
            }
        }
        return isLXCInstalled;
    }

    private static long getMemorySwap(long maxMem, boolean swap) {
        return swap ? maxMem * 2L : 0L;
    }

    private static boolean isLinux() {
        return System.getProperty(PROP_OS_NAME).toLowerCase().contains("nux");
    }

    private static <K, V> Map.Entry<K, V> entry(K k, V v) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k, v);
    }

    private static <T extends AccessibleObject> T accessible(T obj) {
        if (obj == null) {
            return null;
        }
        obj.setAccessible(true);
        return obj;
    }

    private static Path findOwnJarFile() {
        if (hostAbsoluteOwnJarFile == null) {
            URL url = ShieldedCapsule.class.getClassLoader().getResource(ShieldedCapsule.class.getName().replace('.', '/') + ".class");
            if (url != null) {
                if (!"jar".equals(url.getProtocol())) {
                    throw new IllegalStateException("The Capsule class must be in a JAR file, but was loaded from: " + url);
                }
                String path = url.getPath();
                if (path == null) {
                    throw new IllegalStateException("The Capsule class must be in a local JAR file, but was loaded from: " + url);
                }
                try {
                    URI jarUri = new URI(path.substring(0, path.indexOf(33)));
                    hostAbsoluteOwnJarFile = Paths.get(jarUri);
                }
                catch (URISyntaxException e) {
                    throw new AssertionError((Object)e);
                }
            } else {
                throw new RuntimeException("Can't locate capsule's own class");
            }
        }
        return hostAbsoluteOwnJarFile;
    }

    private Path getContainerDir() {
        if (hostAbsoluteContainerDir == null) {
            hostAbsoluteContainerDir = this.getCacheDir().resolve("apps").resolve(this.getAppId()).resolve(HOST_APPCACHE_RELATIVE_CONTAINER_DIR).toAbsolutePath().normalize();
        }
        return hostAbsoluteContainerDir;
    }

    private Path getContainerParentDir() {
        return this.getContainerDir().getParent();
    }

    private Path getRootFSDir() {
        return this.getContainerDir().resolve("rootfs");
    }

    private Path getConfFile() {
        return this.getContainerDir().resolve("config");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDistroType() {
        if (distroType == null) {
            BufferedReader bri = null;
            try {
                String line;
                Process p = new ProcessBuilder("/bin/sh", "-c", "cat /etc/*-release").start();
                bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = bri.readLine()) != null) {
                    if (!line.startsWith("ID=")) continue;
                    String string = distroType = line.substring(3).trim().toLowerCase();
                    return string;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (bri != null) {
                        bri.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return distroType;
    }

    private static Long getCurrentUID() throws IOException, InterruptedException {
        return ShieldedCapsule.getPosixSubjectID("-u");
    }

    private static Long getCurrentGID() throws IOException, InterruptedException {
        return ShieldedCapsule.getPosixSubjectID("-g");
    }

    private static Long getPosixSubjectID(String type) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder("id", type);
        Process p = pb.start();
        if (p.waitFor() != 0) {
            throw new RuntimeException("'id " + type + "' exited with non-zero status");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));){
            Long l = Long.parseLong(reader.readLine());
            return l;
        }
    }
}

