/*
 * Decompiled with CFR 0.152.
 */
import java.io.FilePermission;
import java.net.SocketPermission;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyPermission;

public class SecureCapsule
extends Capsule {
    private static final String PROP_SECURITY_POLICY = "capsule.security.policy";
    private static final String PROP_JAVA_SECURITY_POLICY = "java.security.policy";
    private static final String PROP_JAVA_SECURITY_MANAGER = "java.security.manager";
    private static final String ENV_CAPSULE_REPOS = "CAPSULE_REPOS";
    private static final String ENV_CAPSULE_LOCAL_REPO = "CAPSULE_LOCAL_REPO";
    private final Path jarFile;

    public SecureCapsule(Path jarFile) {
        super(jarFile);
        this.initSecurity();
        this.jarFile = this.getJarFile();
    }

    public SecureCapsule(Capsule pred) {
        super(pred);
        this.initSecurity();
        this.jarFile = this.getJarFile();
    }

    private void initSecurity() {
        Policy.setPolicy(new SandboxSecurityPolicy());
        System.setSecurityManager(new SecurityManager());
    }

    @Override
    protected Capsule loadTargetCapsule(ClassLoader parent, Path jarFile) {
        return super.loadTargetCapsule(new CapletLoader(parent), jarFile);
    }

    @Override
    protected <T> T attribute(Map.Entry<String, T> attr) {
        if (ATTR_SYSTEM_PROPERTIES == attr) {
            HashMap<String, String> props = new HashMap<String, String>((Map)super.attribute(ATTR_SYSTEM_PROPERTIES));
            props.put(PROP_JAVA_SECURITY_MANAGER, "");
            props.put(PROP_JAVA_SECURITY_POLICY, this.getPolicyFile());
            return (T)props;
        }
        if (ATTR_SECURITY_POLICY == attr) {
            return (T)this.getPolicyFile();
        }
        return super.attribute(attr);
    }

    private String getPolicyFile() {
        return SecureCapsule.getProperty(PROP_SECURITY_POLICY) != null ? SecureCapsule.getProperty(PROP_SECURITY_POLICY) : this.toJarUrl("security.policy");
    }

    @Override
    protected ProcessBuilder prelaunch(List<String> jvmArgs, List<String> args) {
        ProcessBuilder pb = super.prelaunch(jvmArgs, args);
        Path exec = Paths.get(pb.command().get(0), new String[0]);
        this.verify(!exec.startsWith(this.appDir()) && !exec.startsWith(this.getWritableAppCache()), "Local command: " + exec);
        return pb;
    }

    private void verify(boolean cond, String message) {
        if (!cond) {
            throw new SecurityException(message);
        }
    }

    private String toJarUrl(String relPath) {
        return "jar:file:" + this.jarFile.toAbsolutePath() + "!/" + relPath;
    }

    private static class CapletLoader
    extends ClassLoader {
        public CapletLoader(ClassLoader parent) {
            super(parent);
        }
    }

    private class SandboxSecurityPolicy
    extends Policy {
        private SandboxSecurityPolicy() {
        }

        @Override
        public PermissionCollection getPermissions(ProtectionDomain domain) {
            return this.isWrapped(domain) ? this.pluginPermissions() : this.applicationPermissions();
        }

        private boolean isWrapped(ProtectionDomain domain) {
            return domain.getClassLoader() instanceof CapletLoader;
        }

        private PermissionCollection pluginPermissions() {
            Permissions permissions = new Permissions();
            permissions.add(new PropertyPermission("*", "read"));
            permissions.add(new FilePermission(SecureCapsule.this.getAppDir().toString(), "read"));
            permissions.add(new RuntimePermission("getenv.CAPSULE_REPOS"));
            permissions.add(new RuntimePermission("getenv.CAPSULE_LOCAL_REPO"));
            permissions.add(new SocketPermission("https://repo1.maven.org/", "connect"));
            return permissions;
        }

        private PermissionCollection applicationPermissions() {
            Permissions permissions = new Permissions();
            permissions.add(new AllPermission());
            return permissions;
        }
    }
}

