/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OsvCapsule
extends Capsule {
    private static final String CONF_FILE = "Capstanfile";
    private static final String PROP_JAVA_VERSION = "java.version";
    private static final String PROP_JAVA_HOME = "java.home";
    private static final String PROP_ONLY_BUILD = "capsule.osv.onlyBuild";
    private static final String PROP_HYPERVISOR = "capsule.osv.hypervisor";
    private static final String PROP_PORT_FORWARD = "capsule.osv.portForward";
    private static final String PROP_NETWORK_TYPE = "capsule.osv.networkType";
    private static final String PROP_PHYSICAL_NIC_NAME = "capsule.osv.physicalNICName";
    private static final Path PATH_ROOT = Paths.get(File.separator, new String[0]);
    private static final Path PATH_APP = PATH_ROOT.resolve("capsule").resolve("app");
    private static final Path PATH_DEP = PATH_ROOT.resolve("capsule").resolve("dep");
    private static final Path PATH_WRAPPER = PATH_ROOT.resolve("capsule").resolve("wrapper");
    private static final Map.Entry<String, String> ATTR_PORT_FORWARD = OsvCapsule.ATTRIBUTE("Port-Forward", OsvCapsule.T_STRING(), null, true, "Configure OSv port forwarding.");
    private static final Map.Entry<String, String> ATTR_NETWORK_TYPE = OsvCapsule.ATTRIBUTE("Network-Type", OsvCapsule.T_STRING(), null, true, "Configure OSv network type.");
    private static final Map.Entry<String, String> ATTR_PHYSICAL_NIC_NAME = OsvCapsule.ATTRIBUTE("Physical-NIC-Name", OsvCapsule.T_STRING(), null, true, "Configure OSv physical NIC name (f.e. mandatory under VirtualBox hypervisor).");
    private static Path hostAbsoluteOwnJarFile;
    private final Set<Path> deps = new HashSet<Path>();
    private Path localRepo;

    public OsvCapsule(Capsule pred) {
        super(pred);
    }

    @Override
    protected Map.Entry<String, Path> chooseJavaHome() {
        Map.Entry<String, Path> res = super.chooseJavaHome();
        if (res == null) {
            res = OsvCapsule.entry(OsvCapsule.getProperty(PROP_JAVA_VERSION), Paths.get(OsvCapsule.getProperty(PROP_JAVA_HOME), new String[0]));
        }
        return OsvCapsule.entry(res.getKey(), Paths.get(File.separator, new String[0]));
    }

    private static <K, V> Map.Entry<K, V> entry(K k, V v) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k, v);
    }

    @Override
    protected List<Path> resolve0(Object x) {
        if (x instanceof Path && ((Path)x).isAbsolute()) {
            Path p = (Path)x;
            if (this.localRepo != null && p.startsWith(this.localRepo)) {
                this.deps.add(p);
            }
            p = this.move(p);
            return super.resolve0(p);
        }
        return super.resolve0(x);
    }

    @Override
    protected final Path getJavaExecutable() {
        return Paths.get("/java.so", new String[0]);
    }

    @Override
    protected final ProcessBuilder prelaunch(List<String> jvmArgs, List<String> args) {
        try {
            String physicalNICName;
            String networkType;
            String portForward;
            this.localRepo = this.getLocalRepo();
            ArrayList<String> newJvmArgs = new ArrayList<String>();
            newJvmArgs.addAll(jvmArgs);
            newJvmArgs.remove("-server");
            newJvmArgs.remove("-client");
            ProcessBuilder pb = super.prelaunch(newJvmArgs, args);
            boolean onlyBuild = false;
            try {
                onlyBuild = Boolean.parseBoolean(System.getProperty(PROP_ONLY_BUILD));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String newCapstanFile = this.getCapstanfile(pb);
            if (this.isBuildNeeded(newCapstanFile)) {
                OsvCapsule.log(2, "OSV image needs to be re-created");
                OsvCapsule.dump(newCapstanFile, this.getConfFile());
                OsvCapsule.log(2, "Conf file written: " + this.getConfFile());
                if (!onlyBuild) {
                    this.buildImage();
                }
            }
            ProcessBuilder pb1 = new ProcessBuilder(new String[0]);
            pb1.directory(this.getConfDir().toFile());
            pb1.command().add("capstan");
            pb1.command().add(onlyBuild ? "onlyBuild" : "run");
            if (System.getProperty(PROP_HYPERVISOR) != null) {
                pb1.command().addAll(Arrays.asList("-p", System.getProperty(PROP_HYPERVISOR)));
            }
            if ((portForward = this.getPropertyOrAttributeString(PROP_PORT_FORWARD, ATTR_PORT_FORWARD)) != null) {
                pb1.command().addAll(Arrays.asList("-f", portForward));
            }
            if ((networkType = this.getPropertyOrAttributeString(PROP_NETWORK_TYPE, ATTR_NETWORK_TYPE)) != null) {
                pb1.command().addAll(Arrays.asList("-n", networkType));
            }
            if ((physicalNICName = this.getPropertyOrAttributeString(PROP_PHYSICAL_NIC_NAME, ATTR_PHYSICAL_NIC_NAME)) != null) {
                pb1.command().addAll(Arrays.asList("-b", physicalNICName));
            }
            if (onlyBuild) {
                pb1.command().add(this.getAppId());
            }
            return pb1;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void buildImage() throws IOException {
        OsvCapsule.log(2, "Re-creating OSV image");
        ProcessBuilder pb1 = new ProcessBuilder(new String[0]);
        pb1.directory(this.getConfDir().toFile());
        pb1.command().add("capstan");
        pb1.command().add("build");
        try {
            if (pb1.start().waitFor() != 0) {
                throw new RuntimeException("Image build failed");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        OsvCapsule.log(2, "OSV image re-created");
    }

    private Path getConfDir() throws IOException {
        Path ret = this.appDir().resolve("osv");
        if (!Files.exists(ret, new LinkOption[0])) {
            Files.createDirectories(ret, new FileAttribute[0]);
        }
        return ret;
    }

    private Path getConfFile() throws IOException {
        return this.getConfDir().resolve(CONF_FILE);
    }

    private boolean isBuildNeeded(String capstanFile) throws IOException {
        if (!Files.exists(this.getConfFile(), new LinkOption[0])) {
            OsvCapsule.log(2, "Conf file " + this.getConfFile() + " is not present");
            return true;
        }
        if (!new String(Files.readAllBytes(this.getConfFile()), Charset.defaultCharset()).equals(capstanFile)) {
            OsvCapsule.log(2, "Conf file content " + this.getConfFile() + " has changed");
            return true;
        }
        try {
            FileTime confTime;
            boolean buildNeeded;
            FileTime wrapperTime;
            FileTime jarTime = Files.getLastModifiedTime(this.getJarFile(), new LinkOption[0]);
            if (this.isWrapperCapsule() && (wrapperTime = Files.getLastModifiedTime(OsvCapsule.findOwnJarFile(), new LinkOption[0])).compareTo(jarTime) > 0) {
                jarTime = wrapperTime;
            }
            boolean bl = buildNeeded = (confTime = Files.getLastModifiedTime(this.getConfFile(), new LinkOption[0])).compareTo(jarTime) < 0;
            if (buildNeeded) {
                OsvCapsule.log(2, "Application " + this.getJarFile() + " has changed");
            }
            return buildNeeded;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected List<Path> getPlatformNativeLibraryPath() {
        return OsvCapsule.splitClassPath("/usr/java/packages/lib/amd64:/usr/lib64:/lib64:/lib:/usr/lib");
    }

    private String getCapstanfile(ProcessBuilder pb) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("base: ").append(this.getBaseImage()).append("\n\n");
        sb.append("cmdline: ").append(OsvCapsule.getCommand(pb)).append("\n\n");
        sb.append("files:\n");
        sb.append(this.file(this.getJarFile())).append("\n");
        Path appDir = this.appDir();
        if (appDir != null) {
            for (Path p : OsvCapsule.listDir(appDir, "**", true)) {
                sb.append(this.file(p)).append("\n");
            }
        }
        for (Path p : this.deps) {
            sb.append(this.file(p)).append("\n");
        }
        return sb.toString();
    }

    private String file(Path p) {
        return "  " + this.move(p) + ": " + p;
    }

    private Path move(Path p) {
        if (p == null) {
            return null;
        }
        if ((p = p.normalize().toAbsolutePath()).startsWith(Paths.get("/dep", new String[0])) || p.startsWith(Paths.get("/app", new String[0]))) {
            return p;
        }
        if (p.equals(this.getJavaExecutable().toAbsolutePath())) {
            return PATH_ROOT.resolve(this.getJavaExecutable());
        }
        if (p.equals(this.getJarFile())) {
            return OsvCapsule.moveJarFile(p);
        }
        if (p.equals(OsvCapsule.findOwnJarFile())) {
            return OsvCapsule.moveWrapperFile(p);
        }
        if (this.appDir() != null && p.startsWith(this.appDir())) {
            return OsvCapsule.move(p, this.appDir(), PATH_APP);
        }
        if (this.localRepo != null && p.startsWith(this.localRepo)) {
            return OsvCapsule.move(p, this.localRepo, PATH_DEP);
        }
        if (this.getPlatformNativeLibraryPath().contains(p)) {
            return p;
        }
        if (p.startsWith(this.getJavaHome())) {
            return p;
        }
        throw new IllegalArgumentException("Unexpected file " + p);
    }

    private String getBaseImage() {
        if (this.hasAttribute(Capsule.ATTR_JAVA_VERSION)) {
            switch (OsvCapsule.javaVersion(this.getAttribute(Capsule.ATTR_JAVA_VERSION))) {
                case 7: {
                    return "cloudius/osv-openjdk";
                }
                case 8: {
                    return "cloudius/osv-openjdk8";
                }
            }
            throw new RuntimeException("No known OSv image for Java version " + this.getAttribute(Capsule.ATTR_JAVA_VERSION));
        }
        return "cloudius/osv-openjdk8";
    }

    private static String getCommand(ProcessBuilder pb) {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(pb.command());
        command.remove("-server");
        command.remove("-client");
        Iterator iter = command.iterator();
        StringBuilder sb = new StringBuilder();
        if (iter.hasNext()) {
            sb.append((String)iter.next());
            while (iter.hasNext()) {
                sb.append(" ").append((String)iter.next());
            }
        }
        return sb.toString();
    }

    private Path getLocalRepo() {
        Capsule mavenCaplet = this.sup("MavenCapsule");
        if (mavenCaplet == null) {
            return null;
        }
        try {
            return (Path)OsvCapsule.accessible(mavenCaplet.getClass().getDeclaredMethod("getLocalRepo", new Class[0])).invoke((Object)mavenCaplet, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void dump(String content, Path loc) throws IOException {
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(loc, new OpenOption[0]), Charset.defaultCharset()));){
            out.print(content);
        }
    }

    private static Path moveJarFile(Path p) {
        return PATH_ROOT.resolve(p.getFileName());
    }

    private static Path moveWrapperFile(Path p) {
        return PATH_WRAPPER.resolve(p.getFileName());
    }

    private static <T extends AccessibleObject> T accessible(T obj) {
        if (obj == null) {
            return null;
        }
        obj.setAccessible(true);
        return obj;
    }

    private static Path findOwnJarFile() {
        if (hostAbsoluteOwnJarFile == null) {
            URL url = OsvCapsule.class.getClassLoader().getResource(OsvCapsule.class.getName().replace('.', '/') + ".class");
            if (url != null) {
                if (!"jar".equals(url.getProtocol())) {
                    throw new IllegalStateException("The Capsule class must be in a JAR file, but was loaded from: " + url);
                }
                String path = url.getPath();
                if (path == null) {
                    throw new IllegalStateException("The Capsule class must be in a local JAR file, but was loaded from: " + url);
                }
                try {
                    URI jarUri = new URI(path.substring(0, path.indexOf(33)));
                    hostAbsoluteOwnJarFile = Paths.get(jarUri);
                }
                catch (URISyntaxException e) {
                    throw new AssertionError((Object)e);
                }
            } else {
                throw new RuntimeException("Can't locate capsule's own class");
            }
        }
        return hostAbsoluteOwnJarFile;
    }

    private static int javaVersion(String v) {
        String[] vs = v.split("\\.");
        if (vs.length == 1) {
            if (Integer.parseInt(vs[0]) < 5) {
                throw new RuntimeException("Unrecognized major Java version: " + v);
            }
            return Integer.parseInt(vs[0]);
        }
        return Integer.parseInt(vs[1]);
    }

    private static List<Path> splitClassPath(String classPath) {
        String[] ps = classPath.split(":");
        ArrayList<Path> res = new ArrayList<Path>(ps.length);
        for (String p : ps) {
            res.add(Paths.get(p, new String[0]));
        }
        return res;
    }

    protected static List<Path> listDir(Path dir, String glob, boolean regular) {
        return OsvCapsule.listDir(dir, glob, false, regular, new ArrayList<Path>());
    }

    private static List<Path> listDir(Path dir, String glob, boolean recursive, boolean regularFile, List<Path> res) {
        return OsvCapsule.listDir(dir, OsvCapsule.splitGlob(glob), recursive, regularFile, res);
    }

    private static List<String> splitGlob(String glob) {
        return glob != null ? Arrays.asList(glob.split("\\".equals(File.separator) ? "\\\\" : File.separator)) : null;
    }

    private static List<Path> listDir(Path dir, List<String> globs, boolean recursive, boolean regularFile, List<Path> res) {
        PathMatcher matcher = null;
        if (globs != null) {
            while (!globs.isEmpty() && "**".equals(globs.get(0))) {
                recursive = true;
                globs = globs.subList(1, globs.size());
            }
            if (!globs.isEmpty()) {
                matcher = dir.getFileSystem().getPathMatcher("glob:" + globs.get(0));
            }
        }
        List<Object> ms = matcher != null || recursive ? new ArrayList() : res;
        ArrayList<Path> mds = matcher != null ? new ArrayList<Path>() : null;
        ArrayList<Path> rds = recursive ? new ArrayList<Path>() : null;
        try (DirectoryStream<Path> fs = Files.newDirectoryStream(dir);){
            for (Path f : fs) {
                if (recursive && Files.isDirectory(f, new LinkOption[0])) {
                    rds.add(f);
                }
                if (matcher == null) {
                    if (regularFile && !Files.isRegularFile(f, new LinkOption[0])) continue;
                    ms.add(f);
                    continue;
                }
                if (!matcher.matches(f.getFileName())) continue;
                if (globs.size() == 1 && (!regularFile || Files.isRegularFile(f, new LinkOption[0]))) {
                    ms.add(f);
                    continue;
                }
                if (!Files.isDirectory(f, new LinkOption[0])) continue;
                mds.add(f);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Collections.sort(ms);
        if (res != ms) {
            res.addAll(ms);
            for (List ds : Arrays.asList(mds, rds)) {
                if (ds == null) continue;
                Collections.sort(ds);
                List<String> gls = ds == mds ? globs.subList(1, globs.size()) : globs;
                for (Path d : ds) {
                    OsvCapsule.listDir(d, gls, recursive, regularFile, res);
                }
            }
        }
        return res;
    }

    private String getPropertyOrAttributeString(String propName, Map.Entry<String, String> attr) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return this.getAttribute(attr);
        }
        return propValue;
    }
}

