/*
 * Decompiled with CFR 0.152.
 */
import co.paralleluniverse.capsule.daemon.DaemonAdapter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DaemonCapsule
extends Capsule {
    private static final String CONF_FILE = "WindowsServiceCmdline";
    private static final Pattern CAPSULE_PORT_PATTERN = Pattern.compile("-Dcapsule\\.port=\\d+");
    private static final Map.Entry<String, String> ATTR_START_CLASS = DaemonCapsule.ATTRIBUTE("Daemon-Start-Class", DaemonCapsule.T_STRING(), null, true, "Class containing the start method (default: app's main)");
    private static final Map.Entry<String, String> ATTR_START_METHOD = DaemonCapsule.ATTRIBUTE("Daemon-Start-Method", DaemonCapsule.T_STRING(), null, true, "Static 'String[] -> void' service start method short name run as the specified, if any (default: app's main)");
    private static final Map.Entry<String, String> ATTR_STOP_CLASS = DaemonCapsule.ATTRIBUTE("Daemon-Stop-Class", DaemonCapsule.T_STRING(), null, true, "Class containing the stop method, if any (default: none)");
    private static final Map.Entry<String, String> ATTR_STOP_METHOD = DaemonCapsule.ATTRIBUTE("Daemon-Stop-Method", DaemonCapsule.T_STRING(), null, true, "Static 'String[] -> void' service stop method short name run as the specified, if any (default: none)");
    private static final String PROP_USER = "capsule.daemon.user";
    private static final Map.Entry<String, String> ATTR_USER = DaemonCapsule.ATTRIBUTE("Daemon-User", DaemonCapsule.T_STRING(), null, true, "The username under which the service will run");
    private static final String PROP_CWD = "capsule.daemon.cwd";
    private static final Map.Entry<String, String> ATTR_CWD = DaemonCapsule.ATTRIBUTE("Daemon-Cwd", DaemonCapsule.T_STRING(), null, true, "Working dir (default: / on Unix)");
    private static final String PROP_STDOUT_FILE = "capsule.daemon.stdoutFile";
    private static final Map.Entry<String, String> ATTR_STDOUT_FILE = DaemonCapsule.ATTRIBUTE("Daemon-Stdout-File", DaemonCapsule.T_STRING(), null, true, "stdout (default: /dev/null on Unix, <logpath>/service-stdout.YEAR-MONTH-DAY.log on Windows)");
    private static final String PROP_STDERR_FILE = "capsule.daemon.stderrFile";
    private static final Map.Entry<String, String> ATTR_STDERR_FILE = DaemonCapsule.ATTRIBUTE("Daemon-Stderr-File", DaemonCapsule.T_STRING(), null, true, "stderr (default: /dev/null on Unix, <logpath>/service-stderr.YEAR-MONTH-DAY.log on Windows))");
    private static final String PROP_PID_FILE = "capsule.daemon.pidFile";
    private static final Map.Entry<String, String> ATTR_PID_FILE = DaemonCapsule.ATTRIBUTE("Daemon-PID-File", DaemonCapsule.T_STRING(), null, true, "PID file (default: /var/run/<appid>.pid on Unix, <logpath>/<appid>.pid on Windows)");
    private static final String PROP_PASSWORD = "capsule.daemon.password";
    private static final Map.Entry<String, String> ATTR_PASSWORD = DaemonCapsule.ATTRIBUTE("Daemon-Password", DaemonCapsule.T_STRING(), null, true, "The password of the user under which the service will run (default: none, Windows only)");
    private static final String PROP_JAVA_EXEC_USER = "capsule.daemon.javaExecUser";
    private static final Map.Entry<String, String> ATTR_JAVA_EXEC_USER = DaemonCapsule.ATTRIBUTE("Daemon-Java-Exec-User", DaemonCapsule.T_STRING(), null, true, "The password of the user that will execute the final Java process (default: none, Windows only)");
    private static final String PROP_JAVA_EXEC_PASSWORD = "capsule.daemon.javaExecPassword";
    private static final Map.Entry<String, String> ATTR_JAVA_EXEC_PASSWORD = DaemonCapsule.ATTRIBUTE("Daemon-Java-Exec-Password", DaemonCapsule.T_STRING(), null, true, "The password of the user that will execute the final Java process (default: none, Windows only)");
    private static final String PROP_SERVICE_NAME = "capsule.daemon.serviceName";
    private static final Map.Entry<String, String> ATTR_SERVICE_NAME = DaemonCapsule.ATTRIBUTE("Daemon-Service-Name", DaemonCapsule.T_STRING(), null, true, "The service internal name (default: app ID, Windows only)");
    private static final String PROP_DISPLAY_NAME = "capsule.daemon.displayName";
    private static final Map.Entry<String, String> ATTR_DISPLAY_NAME = DaemonCapsule.ATTRIBUTE("Daemon-Display-Name", DaemonCapsule.T_STRING(), null, true, "The service display name (default: app ID, Windows only)");
    private static final String PROP_DESCRIPTION = "capsule.daemon.description";
    private static final Map.Entry<String, String> ATTR_DESCRIPTION = DaemonCapsule.ATTRIBUTE("Daemon-Description", DaemonCapsule.T_STRING(), null, true, "The service description (default: app ID, Windows only)");
    private static final String PROP_STARTUP = "capsule.daemon.startup";
    private static final Map.Entry<String, String> ATTR_STARTUP = DaemonCapsule.ATTRIBUTE("Daemon-Startup", DaemonCapsule.T_STRING(), null, true, "The service startup mode, either 'auto' or 'manual' (default: manual, Windows only)");
    private static final String PROP_TYPE = "capsule.daemon.type";
    private static final Map.Entry<String, String> ATTR_TYPE = DaemonCapsule.ATTRIBUTE("Daemon-Type", DaemonCapsule.T_STRING(), null, true, "The service type, it can be 'interactive' (default: none, Windows only)");
    private static final String PROP_DEPENDS_ON = "capsule.daemon.dependsOn";
    private static final Map.Entry<String, List<String>> ATTR_DEPENDS_ON = DaemonCapsule.ATTRIBUTE("Daemon-Depends-On", DaemonCapsule.T_LIST(DaemonCapsule.T_STRING()), null, true, "The service dependencies, as a list (default: none, Windows only)");
    private static final String PROP_STOP_PARAMS = "capsule.daemon.stopParams";
    private static final Map.Entry<String, List<String>> ATTR_STOP_PARAMS = DaemonCapsule.ATTRIBUTE("Daemon-Stop-Params", DaemonCapsule.T_LIST(DaemonCapsule.T_STRING()), null, true, "The service stop parameters (default: none, Windows only)");
    private static final String PROP_STOP_TIMEOUT = "capsule.daemon.stopTimeout";
    private static final Map.Entry<String, Long> ATTR_STOP_TIMEOUT = DaemonCapsule.ATTRIBUTE("Daemon-Stop-Timeout", DaemonCapsule.T_LONG(), null, true, "Service stop timeout in seconds (default: none, Windows only)");
    private static final String PROP_LOG_PATH = "capsule.daemon.logPath";
    private static final Map.Entry<String, String> ATTR_LOG_PATH = DaemonCapsule.ATTRIBUTE("Daemon-Log-Path", DaemonCapsule.T_STRING(), null, true, "The log path (default: %SystemRoot%\\System32\\LogFiles\\Apache, Windows only)");
    private static final String PROP_LOG_PREFIX = "capsule.daemon.logPrefix";
    private static final Map.Entry<String, String> ATTR_LOG_PREFIX = DaemonCapsule.ATTRIBUTE("Daemon-Log-Prefix", DaemonCapsule.T_STRING(), null, true, "The log prefix (default: app ID, Windows only)");
    private static final String PROP_LOG_LEVEL = "capsule.daemon.logLevel";
    private static final Map.Entry<String, String> ATTR_LOG_LEVEL = DaemonCapsule.ATTRIBUTE("Daemon-Log-Level", DaemonCapsule.T_STRING(), null, true, "The log level between 'error', 'info', 'warn' and 'debug' (default: info, Windows only)");
    private static final String PROP_CHECK_ONLY = "capsule.daemon.checkOnly";
    private static final String PROP_DEBUG = "capsule.daemon.debug";
    private static final String PROP_VERBOSE = "capsule.daemon.verbose";
    private static final Map.Entry<String, String> ATTR_INIT_CLASS = DaemonCapsule.ATTRIBUTE("Init-Class", DaemonCapsule.T_STRING(), null, true, "Class containing the init method (default: none, Unix only)");
    private static final Map.Entry<String, String> ATTR_INIT_METHOD = DaemonCapsule.ATTRIBUTE("Init-Method", DaemonCapsule.T_STRING(), null, true, "Static 'String[] -> String[]' service initialization method short name run as 'root'; the return value will be passed to the 'Start' method (default: none, Unix only)");
    private static final Map.Entry<String, String> ATTR_DESTROY_CLASS = DaemonCapsule.ATTRIBUTE("Destroy-Class", DaemonCapsule.T_STRING(), null, true, "Class containing the destroy method (default: none, Unix only)");
    private static final Map.Entry<String, String> ATTR_DESTROY_METHOD = DaemonCapsule.ATTRIBUTE("Destroy-Method", DaemonCapsule.T_STRING(), null, true, "Static service cleanup method short name run as 'root' (default: none, Unix only)");
    private static final String PROP_NO_DETACH = "capsule.daemon.noDetach";
    private static final Map.Entry<String, Boolean> ATTR_NO_DETACH = DaemonCapsule.ATTRIBUTE("No-Detach", DaemonCapsule.T_BOOL(), false, true, "Don't detach from parent process (default: false, Unix only)");
    private static final String PROP_KEEP_STDIN = "capsule.daemon.keepStdin";
    private static final Map.Entry<String, Boolean> ATTR_KEEP_STDIN = DaemonCapsule.ATTRIBUTE("Keep-Stdin", DaemonCapsule.T_BOOL(), false, true, "Don't redirect stdin to /dev/null (default: false, Unix only)");
    private static final String PROP_WAIT_SECS = "capsule.daemon.waitSecs";
    private static final Map.Entry<String, Long> ATTR_WAIT_SECS = DaemonCapsule.ATTRIBUTE("Wait-Secs", DaemonCapsule.T_LONG(), null, true, "Wait seconds for service, must be multiple of 10 (default: 10 secs, Unix only)");
    private static Path hostAbsoluteOwnJarFile;
    private static Path svcExec;
    private Map<String, String> env;

    public DaemonCapsule(Capsule pred) {
        super(pred);
    }

    @Override
    protected Path getJavaExecutable() {
        if (svcExec == null) {
            svcExec = this.setupBinDir().resolve(this.platformExecPath()).toAbsolutePath().normalize();
        }
        return svcExec;
    }

    @Override
    protected Map<String, String> buildEnvironmentVariables(Map<String, String> env) {
        this.env = env;
        return super.buildEnvironmentVariables(env);
    }

    @Override
    protected <T> T attribute(Map.Entry<String, T> attr) {
        if (ATTR_APP_CLASS_PATH == attr && this.isWrapperCapsule()) {
            ArrayList<Path> cp = new ArrayList<Path>((Collection)super.attribute(ATTR_APP_CLASS_PATH));
            cp.add(DaemonCapsule.findOwnJarFile().toAbsolutePath().normalize());
            return (T)cp;
        }
        return super.attribute(attr);
    }

    @Override
    protected final ProcessBuilder prelaunch(List<String> jvmArgs, List<String> args) {
        List<String> svcCmd;
        ProcessBuilder pb = super.prelaunch(jvmArgs, args);
        try {
            svcCmd = this.toSvc(pb.command());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ProcessBuilder(svcCmd);
    }

    @Override
    protected Process postlaunch(Process child) {
        return null;
    }

    private Path setupBinDir() {
        Path libdir = DaemonCapsule.findOwnJarFile().toAbsolutePath().getParent().resolve("bin");
        try {
            Object[] ress = new String[]{"jsvc/linux64-brew/jsvc", "jsvc/macosx-yosemite-brew/jsvc", "procrun/prunsrv.exe"};
            DaemonCapsule.log(2, "Copying daemon native helpers " + Arrays.toString(ress) + " in " + libdir.toAbsolutePath().normalize().toString());
            if (Files.exists(libdir, new LinkOption[0])) {
                DaemonCapsule.delete(libdir);
            }
            this.addTempFile(Files.createDirectory(libdir, new FileAttribute[0]));
            for (Object filename : ress) {
                DaemonCapsule.copy((String)filename, "bin", libdir, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            DaemonCapsule.log(2, "WARNING: Could not extract jsvc/procrun executables: " + e.getMessage());
        }
        return libdir;
    }

    /*
     * Exception decompiling
     */
    private static Path copy(String filename, String resourceDir, Path targetDir, OpenOption ... opts) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> toSvc(List<String> cmd) throws IOException {
        if (DaemonCapsule.isWindows()) {
            return this.setupWindowsCmd(cmd);
        }
        return this.setupUnixCmd(cmd);
    }

    private List<String> setupWindowsCmd(List<String> cmd) throws IOException {
        Long stopTimeout;
        List<String> stopParams;
        String stopM;
        String svcName = this.getPropertyOrAttributeString(PROP_SERVICE_NAME, ATTR_SERVICE_NAME);
        if (svcName == null) {
            svcName = this.getAppId();
        }
        ArrayList<String> installCmd = new ArrayList<String>();
        installCmd.add(DaemonCapsule.doubleQuote(svcExec.toString()));
        installCmd.add("install");
        installCmd.add(DaemonCapsule.doubleQuote(svcName));
        ArrayList<String> jvmOpts = new ArrayList<String>();
        ArrayList<String> appOpts = new ArrayList<String>();
        String appClass = this.parseWindows(cmd, installCmd, jvmOpts, appOpts);
        int i = installCmd.size();
        installCmd.add(i++, "--JavaHome");
        installCmd.add(i++, DaemonCapsule.doubleQuote(this.getJavaHome().toAbsolutePath().normalize().toString()));
        installCmd.add(i++, "--Description");
        String desc = this.getPropertyOrAttributeString(PROP_DESCRIPTION, ATTR_DESCRIPTION);
        installCmd.add(i++, DaemonCapsule.doubleQuote(desc != null ? desc : this.getAppId()));
        installCmd.add(i++, "--DisplayName");
        String dName = this.getPropertyOrAttributeString(PROP_DISPLAY_NAME, ATTR_DISPLAY_NAME);
        installCmd.add(i++, DaemonCapsule.doubleQuote(dName != null ? dName : this.getAppId()));
        i = this.addPropertyOrAttributeStringAsOptionDoubleQuote(installCmd, PROP_STARTUP, ATTR_STARTUP, "--Startup", i);
        i = this.addPropertyOrAttributeStringAsOptionDoubleQuote(installCmd, PROP_TYPE, ATTR_TYPE, "--Type", i);
        List<String> dependsOn = this.getPropertyOrAttributeStringList(PROP_DEPENDS_ON, ATTR_DEPENDS_ON);
        if (dependsOn != null && !dependsOn.isEmpty()) {
            installCmd.add(i++, "++DependsOn");
            installCmd.add(i++, DaemonCapsule.doubleQuote(DaemonCapsule.join(dependsOn, ";", "'")));
        }
        if (this.env != null && !this.env.isEmpty()) {
            ArrayList<String> envL = new ArrayList<String>();
            for (String e : this.env.keySet()) {
                envL.add(e + "=" + this.env.get(e));
            }
            if (!envL.isEmpty()) {
                installCmd.add(i++, "++Environment");
                installCmd.add(i++, DaemonCapsule.doubleQuote(DaemonCapsule.join(envL, ";", "'")));
            }
        }
        i = this.addPropertyOrAttributeStringAsOptionDoubleQuote(installCmd, PROP_JAVA_EXEC_USER, ATTR_JAVA_EXEC_USER, "--User", i);
        i = this.addPropertyOrAttributeStringAsOptionDoubleQuote(installCmd, PROP_JAVA_EXEC_PASSWORD, ATTR_JAVA_EXEC_PASSWORD, "--Password", i);
        i = this.addPropertyOrAttributeStringAsOptionDoubleQuote(installCmd, PROP_USER, ATTR_USER, "--ServiceUser", i);
        i = this.addPropertyOrAttributeStringAsOptionDoubleQuote(installCmd, PROP_PASSWORD, ATTR_PASSWORD, "--ServicePassword", i);
        installCmd.add(i++, "--StartMode");
        installCmd.add(i++, "Java");
        i = this.addPropertyOrAttributeStringAsOptionDoubleQuote(installCmd, PROP_CWD, ATTR_CWD, "--StartPath", i);
        installCmd.add(i++, "--StartClass");
        String startC = this.getAttribute(ATTR_START_CLASS);
        installCmd.add(i++, startC != null ? startC : appClass);
        String startM = this.getAttribute(ATTR_START_METHOD);
        if (startM != null) {
            installCmd.add(i++, "--StartMethod");
            installCmd.add(i++, startM);
        }
        if (!appOpts.isEmpty()) {
            installCmd.add(i++, "++StartParams");
            installCmd.add(i++, DaemonCapsule.doubleQuote(DaemonCapsule.join(appOpts, ";", "'")));
        }
        installCmd.add(i++, "--StopMode");
        installCmd.add(i++, "Java");
        i = this.addPropertyOrAttributeStringAsOptionDoubleQuote(installCmd, PROP_CWD, ATTR_CWD, "--StopPath", i);
        String stopC = this.getAttribute(ATTR_STOP_CLASS);
        if (stopC != null) {
            installCmd.add(i++, "--StopClass");
            installCmd.add(i++, stopC);
        }
        if ((stopM = this.getAttribute(ATTR_STOP_METHOD)) != null) {
            installCmd.add(i++, "--StopMethod");
            installCmd.add(i++, stopM);
        }
        if ((stopParams = this.getPropertyOrAttributeStringList(PROP_STOP_PARAMS, ATTR_STOP_PARAMS)) != null && !stopParams.isEmpty()) {
            installCmd.add(i++, "++StopParams");
            installCmd.add(i++, DaemonCapsule.doubleQuote(DaemonCapsule.join(stopParams, ";", "'")));
        }
        if ((stopTimeout = this.getPropertyOrAttributeLong(PROP_STOP_TIMEOUT, ATTR_STOP_TIMEOUT)) != null) {
            installCmd.add(i++, "++StopTimeout");
            installCmd.add(i++, stopTimeout.toString());
        }
        i = this.addPropertyOrAttributeStringAsOptionDoubleQuote(installCmd, PROP_LOG_PATH, ATTR_LOG_PATH, "--LogPath", i);
        installCmd.add(i++, "--LogPrefix");
        String logPrefix = this.getPropertyOrAttributeString(PROP_LOG_PREFIX, ATTR_LOG_PREFIX);
        installCmd.add(i++, DaemonCapsule.doubleQuote(logPrefix != null ? logPrefix : this.getAppId()));
        i = this.addPropertyOrAttributeStringAsOption(installCmd, PROP_LOG_LEVEL, ATTR_LOG_LEVEL, "--LogLevel", i);
        installCmd.add(i++, "--StdOutput");
        String stdout = this.getPropertyOrAttributeString(PROP_STDOUT_FILE, ATTR_STDOUT_FILE);
        installCmd.add(i++, DaemonCapsule.doubleQuote(stdout != null ? stdout : "auto"));
        installCmd.add(i++, "--StdError");
        String stderr = this.getPropertyOrAttributeString(PROP_STDERR_FILE, ATTR_STDERR_FILE);
        installCmd.add(i++, DaemonCapsule.doubleQuote(stderr != null ? stderr : "auto"));
        installCmd.add(i++, "--PidFile");
        String pid = this.getPropertyOrAttributeString(PROP_PID_FILE, ATTR_PID_FILE);
        installCmd.add(i++, DaemonCapsule.doubleQuote(pid != null ? pid : this.getAppId() + ".pid"));
        installCmd.add(i++, "++JvmOptions");
        installCmd.add(i, DaemonCapsule.doubleQuote(DaemonCapsule.join(jvmOpts, ";")));
        String installCmdline = DaemonCapsule.join(installCmd, " ");
        if (this.isReinstallNeeded(installCmdline)) {
            DaemonCapsule.log(2, "Windows: service " + svcName + " needs re-installation, writing cmdline in " + this.getCmdlineFile().toString());
            DaemonCapsule.dump(installCmdline, this.getCmdlineFile());
            try {
                ProcessBuilder pb = new ProcessBuilder(new String[0]).command(DaemonCapsule.doubleQuote(svcExec.toString()), "delete", DaemonCapsule.doubleQuote(svcName));
                Process p = pb.start();
                if (p.waitFor() != 0) {
                    DaemonCapsule.log(2, "Windows: couldn't delete service " + svcName + ".\n\tstderr:\n\t\t" + DaemonCapsule.slurp(p.getErrorStream()) + "\n\tstdout:\n\t\t" + DaemonCapsule.slurp(p.getInputStream()));
                } else {
                    DaemonCapsule.log(2, "Windows: service " + svcName + " successfully deleted");
                }
            }
            catch (IOException | InterruptedException ignored) {
                DaemonCapsule.log(2, "Windows: couldn't delete service " + svcName + ", exception message: " + ignored.getMessage());
            }
            try {
                DaemonCapsule.log(2, "Windows: installing service " + svcName + " with command: " + ((Object)installCmd).toString());
                Process p = new ProcessBuilder(installCmd).start();
                if (p.waitFor() != 0) {
                    DaemonCapsule.log(2, "Windows: couldn't install install " + svcName + ".\n\tstderr:\n\t\t" + DaemonCapsule.slurp(p.getErrorStream()) + "\n\tstdout:\n\t\t" + DaemonCapsule.slurp(p.getInputStream()));
                } else {
                    DaemonCapsule.log(2, "Windows: service " + svcName + " successfully installed");
                }
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(svcExec.toString());
        ret.add("start");
        ret.add(svcName);
        return ret;
    }

    private boolean isReinstallNeeded(String cmdLine) throws IOException {
        if (!Files.exists(this.getCmdlineFile(), new LinkOption[0])) {
            DaemonCapsule.log(2, "Windows: service install cmdline file " + this.getCmdlineFile() + " is not present");
            return true;
        }
        try (FileInputStream is = new FileInputStream(this.getCmdlineFile().toFile());){
            String cmdlineFile = DaemonCapsule.slurp(is);
            if (!DaemonCapsule.removeCapsulePort(cmdlineFile).equals(DaemonCapsule.removeCapsulePort(cmdLine))) {
                DaemonCapsule.log(2, "Windows: service install cmdline file content " + this.getCmdlineFile() + " has changed");
                boolean bl = true;
                return bl;
            }
        }
        try {
            FileTime confTime;
            boolean buildNeeded;
            FileTime wrapperTime;
            FileTime jarTime = Files.getLastModifiedTime(this.getJarFile(), new LinkOption[0]);
            if (this.isWrapperCapsule() && (wrapperTime = Files.getLastModifiedTime(DaemonCapsule.findOwnJarFile(), new LinkOption[0])).compareTo(jarTime) > 0) {
                jarTime = wrapperTime;
            }
            boolean bl = buildNeeded = (confTime = Files.getLastModifiedTime(this.getCmdlineFile(), new LinkOption[0])).compareTo(jarTime) < 0;
            if (buildNeeded) {
                DaemonCapsule.log(2, "Windows: application " + this.getJarFile() + " has changed");
            }
            return buildNeeded;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path getDaemonDir() throws IOException {
        Path ret = this.getCacheDir().resolve("daemon");
        if (!Files.exists(ret, new LinkOption[0])) {
            Files.createDirectories(ret, new FileAttribute[0]);
        }
        return ret;
    }

    private Path getCmdlineFile() throws IOException {
        return this.getDaemonDir().resolve(CONF_FILE);
    }

    private int addPropertyOrAttributeStringAsOption(List<String> outCmd, String prop, Map.Entry<String, String> attr, String opt, int pos) {
        String v = this.getPropertyOrAttributeString(prop, attr);
        if (v != null) {
            outCmd.add(pos++, opt);
            outCmd.add(pos++, v);
        }
        return pos;
    }

    private int addPropertyOrAttributeStringAsOptionDoubleQuote(List<String> outCmd, String prop, Map.Entry<String, String> attr, String opt, int pos) {
        String v = this.getPropertyOrAttributeString(prop, attr);
        if (v != null) {
            outCmd.add(pos++, opt);
            outCmd.add(pos++, DaemonCapsule.doubleQuote(v));
        }
        return pos;
    }

    private int addAttributeStringAsProperty(List<String> outCmd, Map.Entry<String, String> inAttr, String outPropKey, int pos) {
        String v = this.getAttribute(inAttr);
        if (v != null) {
            outCmd.add(pos++, "-D" + outPropKey + "=" + v);
        }
        return pos;
    }

    private String parseWindows(List<String> cmds, List<String> outCmdOpts, List<String> outJvmOpts, List<String> outAppOpts) {
        ArrayList<String> otherJvmOpts = new ArrayList<String>();
        boolean addToCmdOpts = false;
        for (String c : cmds.subList(1, cmds.size())) {
            if (addToCmdOpts) {
                addToCmdOpts = false;
                outCmdOpts.add(DaemonCapsule.doubleQuote(c));
                continue;
            }
            if ("-cp".equals(c) || "-classpath".equals(c)) {
                outCmdOpts.add("--Classpath");
                addToCmdOpts = true;
                continue;
            }
            if ("-Xmx".equals(c)) {
                outJvmOpts.add("--JvmMx");
                continue;
            }
            if ("-Xms".equals(c)) {
                outJvmOpts.add("--JvmMs");
                continue;
            }
            if ("-Xss".equals(c)) {
                outJvmOpts.add("--JvmSs");
                continue;
            }
            if (c.startsWith("-Djava.library.path=")) {
                outCmdOpts.add("--LibraryPath");
                outCmdOpts.add(DaemonCapsule.doubleQuote(c.substring("-Djava.library.path=".length())));
                continue;
            }
            if (c.startsWith("-D") || c.startsWith("-X") || "-server".equals(c) || "-client".equals(c) || "-d32".equals(c) || "-d64".equals(c) || "-?".equals(c) || "-help".equals(c) || "-showversion".equals(c) || "-esa".equals(c) || "-dsa".equals(c) || "-enablesystemassertions".equals(c) || "-disablesystemassertions".equals(c) || c.startsWith("-agentlib") || c.startsWith("-agentpath") || c.startsWith("-javaagent") || c.startsWith("-ea") || c.startsWith("-da") || c.startsWith("-enableassertions") || c.startsWith("-disableassertions") || c.startsWith("-version") || c.startsWith("-verbose:") || c.startsWith("-splash:")) {
                otherJvmOpts.add(c);
                continue;
            }
            outAppOpts.add(DaemonCapsule.doubleQuote(c));
        }
        outJvmOpts.add(DaemonCapsule.join(otherJvmOpts, ";", "'"));
        return outAppOpts.remove(outAppOpts.indexOf(DaemonCapsule.doubleQuote((String)this.getAttribute(ATTR_APP_CLASS))));
    }

    private List<String> setupUnixCmd(List<String> cmd) {
        String verbose;
        String debug;
        String checkOnly;
        ArrayList<String> ret = new ArrayList<String>(cmd);
        int i = 1;
        ret.add(i++, "-java-home");
        Path javaHome = this.getJavaHome().toAbsolutePath().normalize();
        if (DaemonCapsule.isMac() && javaHome.toString().endsWith("/Home/jre")) {
            javaHome = javaHome.getParent();
        }
        ret.add(i++, javaHome.toString());
        i = this.addPropertyOrAttributeStringAsOption(ret, PROP_USER, ATTR_USER, "-user", i);
        if (this.getPropertyOrAttributeBool(PROP_KEEP_STDIN, ATTR_KEEP_STDIN).booleanValue()) {
            ret.add(i++, "-keepstdin");
        }
        if (this.getPropertyOrAttributeBool(PROP_NO_DETACH, ATTR_NO_DETACH).booleanValue()) {
            ret.add(i++, "-nodetach");
        }
        if ((checkOnly = System.getProperty(PROP_CHECK_ONLY)) != null && !"false".equals(checkOnly)) {
            ret.add(i++, "-check");
        }
        if ((debug = System.getProperty(PROP_DEBUG)) != null && !"false".equals(debug)) {
            ret.add(i++, "-debug");
        }
        if ((verbose = System.getProperty(PROP_VERBOSE)) != null) {
            if (verbose.length() == 0) {
                ret.add(i++, "-verbose");
            } else {
                ret.add(i++, "-verbose:" + verbose);
            }
        }
        i = this.addPropertyOrAttributeStringAsOption(ret, PROP_CWD, ATTR_CWD, "-cwd", i);
        i = this.addPropertyOrAttributeStringAsOption(ret, PROP_STDOUT_FILE, ATTR_STDOUT_FILE, "-outfile", i);
        i = this.addPropertyOrAttributeStringAsOption(ret, PROP_STDERR_FILE, ATTR_STDERR_FILE, "-errfile", i);
        ret.add(i++, "-pidfile");
        String pid = this.getPropertyOrAttributeString(PROP_PID_FILE, ATTR_PID_FILE);
        ret.add(i++, pid != null ? pid : "/var/run/" + this.getAppId() + ".pid");
        Long wait = this.getPropertyOrAttributeLong(PROP_WAIT_SECS, ATTR_WAIT_SECS);
        if (wait != null) {
            ret.add(i++, "-wait");
            ret.add(i++, wait.toString());
        }
        i = this.addAttributeStringAsProperty(ret, ATTR_INIT_CLASS, "capsule.daemon.initClass", i);
        i = this.addAttributeStringAsProperty(ret, ATTR_INIT_METHOD, "capsule.daemon.initMethod", i);
        String startC = this.getAttribute(ATTR_START_CLASS);
        int appClassIdx = ret.indexOf(this.getAttribute(ATTR_APP_CLASS));
        String appClass = (String)ret.remove(appClassIdx);
        ret.add(appClassIdx, DaemonAdapter.class.getName());
        ret.add(i++, "-Dcapsule.daemon.startClass=" + (startC != null ? startC : appClass));
        String startM = this.getAttribute(ATTR_START_METHOD);
        ret.add(i++, "-Dcapsule.daemon.startMethod=" + (startM != null ? startM : "main"));
        i = this.addAttributeStringAsProperty(ret, ATTR_STOP_CLASS, "capsule.daemon.stopMethod", i);
        i = this.addAttributeStringAsProperty(ret, ATTR_DESTROY_CLASS, "capsule.daemon.destroyClass", i);
        this.addAttributeStringAsProperty(ret, ATTR_DESTROY_METHOD, "capsule.daemon.destroyMethod", i);
        return ret;
    }

    private String getPropertyOrAttributeString(String propName, Map.Entry<String, String> attr) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return this.getAttribute(attr);
        }
        return propValue;
    }

    private List<String> getPropertyOrAttributeStringList(String propName, Map.Entry<String, List<String>> attr) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return this.getAttribute(attr);
        }
        return Arrays.asList(propValue.split(";"));
    }

    private Boolean getPropertyOrAttributeBool(String propName, Map.Entry<String, Boolean> attr) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return this.getAttribute(attr);
        }
        try {
            return Boolean.parseBoolean(propValue);
        }
        catch (Throwable t) {
            return this.getAttribute(attr);
        }
    }

    private Long getPropertyOrAttributeLong(String propName, Map.Entry<String, Long> attr) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return this.getAttribute(attr);
        }
        try {
            return Long.parseLong(propValue);
        }
        catch (Throwable t) {
            return this.getAttribute(attr);
        }
    }

    private boolean isLinux64() {
        return "linux".equals(this.getPlatform()) && System.getProperty("os.arch").contains("64");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path platformExecPath() {
        if (DaemonCapsule.isMac()) {
            return Paths.get("jsvc", "macosx-yosemite-brew", "jsvc");
        }
        if (DaemonCapsule.isWindows()) {
            return Paths.get("procrun", "prunsrv.exe");
        }
        if (this.isLinux64()) {
            return Paths.get("jsvc", "linux64-brew", "jsvc");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ProcessBuilder("which", "jsvc").start().getInputStream(), Charset.defaultCharset()));){
            Path path = Paths.get(reader.readLine(), new String[0]);
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path findOwnJarFile() {
        if (hostAbsoluteOwnJarFile == null) {
            URL url = DaemonCapsule.class.getClassLoader().getResource(DaemonCapsule.class.getName().replace('.', '/') + ".class");
            if (url != null) {
                if (!"jar".equals(url.getProtocol())) {
                    throw new IllegalStateException("The Capsule class must be in a JAR file, but was loaded from: " + url);
                }
                String path = url.getPath();
                if (path == null) {
                    throw new IllegalStateException("The Capsule class must be in a local JAR file, but was loaded from: " + url);
                }
                try {
                    URI jarUri = new URI(path.substring(0, path.indexOf(33)));
                    hostAbsoluteOwnJarFile = Paths.get(jarUri).toAbsolutePath().normalize();
                }
                catch (URISyntaxException e) {
                    throw new AssertionError((Object)e);
                }
            } else {
                throw new RuntimeException("Can't locate capsule's own class");
            }
        }
        return hostAbsoluteOwnJarFile;
    }

    private static String join(List<String> values, String sep) {
        return DaemonCapsule.join(values, sep, "", "");
    }

    private static String join(List<String> values, String sep, String prePostfix) {
        return DaemonCapsule.join(values, sep, prePostfix, prePostfix);
    }

    private static String join(List<String> values, String sep, String prefix, String postfix) {
        ArrayList<String> vals = values != null ? new ArrayList<String>(values) : new ArrayList();
        String v0 = vals.size() > 0 ? prefix + vals.remove(0) + postfix : "";
        StringBuilder sb = new StringBuilder(v0);
        for (String v : vals) {
            sb.append(sep).append(prefix).append(v).append(postfix);
        }
        return sb.toString();
    }

    private static String slurp(InputStream in) throws IOException {
        int n;
        StringBuilder out = new StringBuilder();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    private static void dump(String content, Path loc) throws IOException {
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(loc, new OpenOption[0]), Charset.defaultCharset()));){
            out.print(content);
        }
    }

    private static String doubleQuote(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            if (DaemonCapsule.escaped("\"", s)) {
                return s;
            }
            return s.replace("\"", "\\\"");
        }
        return "\"" + s.replace("\"", "\\\"") + "\"";
    }

    private static boolean escaped(String s, String in) {
        int idx = 0;
        while ((idx = in.indexOf(s, idx)) != -1) {
            if (idx != 0 && in.charAt(idx - 1) == '\\') continue;
            return false;
        }
        return true;
    }

    private static String removeCapsulePort(String s) {
        Matcher m = CAPSULE_PORT_PATTERN.matcher(s);
        return m.replaceFirst("");
    }
}

