/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.capsule.container;

import co.paralleluniverse.capsule.container.CapsuleContainer;
import co.paralleluniverse.common.ProcessUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class MBeanCapsuleContainer
extends CapsuleContainer {
    protected MBeanCapsuleContainer(Path cacheDir) {
        super(cacheDir);
    }

    @Override
    protected String createProcessId(String appId, Process p) {
        return super.createProcessId(appId, p) + "@" + ProcessUtil.getPid((Process)p);
    }

    @Override
    protected CapsuleContainer.ProcessInfo mountProcess(Process p, String id, String capsuleId, List<String> jvmArgs, List<String> args) throws IOException, InstanceAlreadyExistsException {
        JMXServiceURL connectorAddress = null;
        try {
            Thread.sleep(1000L);
            connectorAddress = ProcessUtil.getLocalConnectorAddress((Process)p, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ProcessInfo(p, capsuleId, jvmArgs, args, connectorAddress);
    }

    @Override
    protected ProcessInfo getProcessInfo(String id) {
        return (ProcessInfo)super.getProcessInfo(id);
    }

    public final MBeanServerConnection getProcessMBeans(String id) {
        ProcessInfo pi = this.getProcessInfo(id);
        return pi != null ? pi.getJMX() : null;
    }

    protected static class ProcessInfo
    extends CapsuleContainer.ProcessInfo {
        final JMXServiceURL connectorAddress;
        private MBeanServerConnection jmx;

        public ProcessInfo(Process process, String capsuleId, List<String> jvmArgs, List<String> args, JMXServiceURL connectorAddress) {
            super(process, capsuleId, jvmArgs, args);
            this.connectorAddress = connectorAddress;
        }

        public synchronized MBeanServerConnection getJMX() {
            try {
                if (this.jmx == null) {
                    this.jmx = JMXConnectorFactory.connect(this.connectorAddress).getMBeanServerConnection();
                }
                return this.jmx;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

