/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.capsule.container;

import co.paralleluniverse.capsule.CapsuleLauncher;
import co.paralleluniverse.capsule.container.CapsuleContainerMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.StandardEmitterMBean;

public class CapsuleContainer
implements CapsuleContainerMXBean {
    public static final String CAPSULE_PROCESS_LAUNCHED = "capsule.launch";
    public static final String CAPSULE_PROCESS_KILLED = "capsule.death";
    private final AtomicLong notificationSequence = new AtomicLong();
    private final ConcurrentMap<String, ProcessInfo> processes = new ConcurrentHashMap<String, ProcessInfo>();
    private final AtomicInteger counter = new AtomicInteger();
    private final Path cacheDir;
    private final StandardEmitterMBean mbean;
    private final Map<String, Path> javaHomes;

    public CapsuleContainer(Path cacheDir) {
        this.cacheDir = cacheDir;
        this.mbean = this.registerMBean("co.paralleluniverse:type=CapsuleContainer", this.getMBeanInterface());
        this.javaHomes = CapsuleLauncher.getJavaHomes();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                CapsuleContainer.this.killAll();
            }
        }));
    }

    protected Class<?> getMBeanInterface() {
        return CapsuleContainerMXBean.class;
    }

    protected NotificationBroadcasterSupport createEmitter() {
        MBeanNotificationInfo launch = new MBeanNotificationInfo(new String[]{CAPSULE_PROCESS_LAUNCHED}, Notification.class.getName(), "Notification about a capsule process having launched.");
        MBeanNotificationInfo death = new MBeanNotificationInfo(new String[]{CAPSULE_PROCESS_KILLED}, Notification.class.getName(), "Notification about a capsule process having launched.");
        return new NotificationBroadcasterSupport(launch, death);
    }

    private StandardEmitterMBean registerMBean(String name, Class<?> mbeanInterface) {
        try {
            StandardEmitterMBean _mbean = new StandardEmitterMBean(this, mbeanInterface, (NotificationEmitter)this.createEmitter());
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = ObjectName.getInstance(name);
            mbs.registerMBean(_mbean, mxbeanName);
            return _mbean;
        }
        catch (InstanceAlreadyExistsException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanRegistrationException ex) {
            throw new RuntimeException(ex);
        }
        catch (NotCompliantMBeanException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public String launchCapsule(Path capsulePath, List<String> jvmArgs, List<String> args) throws IOException {
        Object capsule = CapsuleLauncher.newCapsule((Path)capsulePath, (Path)this.cacheDir, this.javaHomes);
        return this.launchCapsule(capsule, jvmArgs, args);
    }

    private String launchCapsule(Object capsule, List<String> jvmArgs, List<String> args) throws IOException {
        if (jvmArgs == null) {
            jvmArgs = Collections.emptyList();
        }
        if (args == null) {
            args = Collections.emptyList();
        }
        try {
            String capsuleId = CapsuleLauncher.getAppId((Object)capsule);
            ProcessBuilder pb = CapsuleLauncher.prepareForLaunch((Object)capsule, (List)CapsuleLauncher.enableJMX(jvmArgs), args);
            pb = this.configureCapsuleProcess(pb);
            Process p = pb.start();
            String id = this.createProcessId(capsuleId, p);
            ProcessInfo pi = this.mountProcess(p, id, capsuleId, jvmArgs, args);
            this.processes.put(id, pi);
            this.mbean.sendNotification(this.processLaunchedNotification(id, jvmArgs, args));
            this.onProcessLaunch(id, pi);
            this.monitorProcess(id, p);
            return id;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected ProcessInfo mountProcess(Process p, String id, String capsuleId, List<String> jvmArgs, List<String> args) throws IOException, InstanceAlreadyExistsException {
        return new ProcessInfo(p, capsuleId, jvmArgs, args);
    }

    protected ProcessBuilder configureCapsuleProcess(ProcessBuilder pb) throws IOException {
        return pb;
    }

    void processDied(String id, Process p, int exitValue) {
        this.mbean.sendNotification(this.processDiedNotification(id, exitValue));
        this.onProcessDeath(id, this.getProcessInfo(id), exitValue);
    }

    protected void onProcessLaunch(String id, ProcessInfo pi) {
    }

    protected void onProcessDeath(String id, ProcessInfo pi, int exitValue) {
    }

    private Notification processLaunchedNotification(String id, List<String> jvmArgs, List<String> args) {
        return new Notification(CAPSULE_PROCESS_LAUNCHED, this.mbean, this.notificationSequence.incrementAndGet(), System.currentTimeMillis(), id + " args: " + args + " jvmArgs: " + jvmArgs);
    }

    private Notification processDiedNotification(String id, int exitValue) {
        return new Notification(CAPSULE_PROCESS_KILLED, this.mbean, this.notificationSequence.incrementAndGet(), System.currentTimeMillis(), id + "exitValue: " + exitValue);
    }

    private void monitorProcess(final String id, final Process p) {
        new Thread("process-monitor-" + id){

            @Override
            public void run() {
                try {
                    int exit = p.waitFor();
                    CapsuleContainer.this.processDied(id, p, exit);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    protected String createProcessId(String appId, Process p) {
        return appId + "-" + this.counter.incrementAndGet();
    }

    protected final Map<String, ProcessInfo> getProcessInfo() {
        HashMap m = new HashMap();
        Iterator it = this.processes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            ProcessInfo pi = (ProcessInfo)e.getValue();
            if (CapsuleContainer.isAlive(pi.process)) {
                m.put(e.getKey(), pi);
                continue;
            }
            it.remove();
        }
        return Collections.unmodifiableMap(m);
    }

    protected ProcessInfo getProcessInfo(String id) {
        ProcessInfo pi = (ProcessInfo)this.processes.get(id);
        if (pi == null) {
            return null;
        }
        if (CapsuleContainer.isAlive(pi.process)) {
            return pi;
        }
        this.processes.remove(id, pi);
        return null;
    }

    public final Process getProcess(String id) {
        ProcessInfo pi = this.getProcessInfo(id);
        return pi != null ? pi.process : null;
    }

    private void killAll() {
        for (ProcessInfo pi : this.getProcessInfo().values()) {
            pi.process.destroy();
        }
    }

    @Override
    public final Set<String> getProcesses() {
        HashSet<String> ps = new HashSet<String>();
        for (Map.Entry<String, ProcessInfo> entry : this.getProcessInfo().entrySet()) {
            ps.add(entry.getKey() + " " + entry.getValue());
        }
        return ps;
    }

    @Override
    public final void killProcess(String id) {
        ProcessInfo pi = this.getProcessInfo(id);
        if (pi != null) {
            pi.process.destroy();
        }
    }

    private static boolean isAlive(Process p) {
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    protected static class ProcessInfo {
        final Process process;
        final String capsuleId;
        final List<String> jvmArgs;
        final List<String> args;

        public ProcessInfo(Process process, String capsuleId, List<String> jvmArgs, List<String> args) {
            this.process = process;
            this.capsuleId = capsuleId;
            this.jvmArgs = Collections.unmodifiableList(new ArrayList<String>(jvmArgs));
            this.args = Collections.unmodifiableList(new ArrayList<String>(args));
        }

        public String toString() {
            return "(capsule: " + this.capsuleId + " args: " + this.args + " jvmArgs:" + this.jvmArgs + ')';
        }
    }
}

