/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.capsule.container;

import co.paralleluniverse.capsule.container.CapsuleContainer;
import co.paralleluniverse.capsule.container.MBeanCapsuleContainer;
import co.paralleluniverse.common.ProcessUtil;
import com.sun.jdmk.remote.cascading.CascadingService;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;

public class CascadingCapsuleContainer
extends MBeanCapsuleContainer {
    private final CascadingService cascade;

    public CascadingCapsuleContainer(Path cacheDir, MBeanServer mbeanServer) {
        super(cacheDir);
        this.cascade = mbeanServer != null ? new CascadingService(mbeanServer) : null;
    }

    public CascadingCapsuleContainer(Path cacheDir) {
        this(cacheDir, ManagementFactory.getPlatformMBeanServer());
    }

    @Override
    protected CapsuleContainer.ProcessInfo mountProcess(Process p, String id, String capsuleId, List<String> jvmArgs, List<String> args) throws IOException, InstanceAlreadyExistsException {
        String mountId = null;
        JMXServiceURL connectorAddress = null;
        try {
            Thread.sleep(1000L);
            connectorAddress = ProcessUtil.getLocalConnectorAddress((Process)p, (boolean)false);
            mountId = this.cascade != null ? this.cascade.mount(connectorAddress, null, ObjectName.WILDCARD, "capsule/" + id) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ProcessInfo(p, capsuleId, jvmArgs, args, connectorAddress, mountId);
    }

    @Override
    protected ProcessInfo getProcessInfo(String id) {
        return (ProcessInfo)super.getProcessInfo(id);
    }

    protected static class ProcessInfo
    extends MBeanCapsuleContainer.ProcessInfo {
        final String mountPoint;

        public ProcessInfo(Process process, String capsuleId, List<String> jvmArgs, List<String> args, JMXServiceURL connectorAddress, String mountPoint) {
            super(process, capsuleId, jvmArgs, args, connectorAddress);
            this.mountPoint = mountPoint;
        }
    }
}

