/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.log4j;

import co.elastic.logging.EcsJsonSerializer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class EcsLayout
extends Layout {
    private boolean stackTraceAsArray = false;
    private String serviceName;
    private Set<String> topLevelLabels = new HashSet<String>(EcsJsonSerializer.DEFAULT_TOP_LEVEL_LABELS);
    private boolean includeOrigin;

    public String format(LoggingEvent event) {
        ThrowableInformation throwableInformation;
        LocationInfo locationInformation;
        StringBuilder builder = new StringBuilder();
        EcsJsonSerializer.serializeObjectStart((StringBuilder)builder, (long)event.getTimeStamp());
        EcsJsonSerializer.serializeLogLevel((StringBuilder)builder, (String)event.getLevel().toString());
        EcsJsonSerializer.serializeFormattedMessage((StringBuilder)builder, (String)event.getRenderedMessage());
        EcsJsonSerializer.serializeServiceName((StringBuilder)builder, (String)this.serviceName);
        EcsJsonSerializer.serializeThreadName((StringBuilder)builder, (String)event.getThreadName());
        EcsJsonSerializer.serializeLoggerName((StringBuilder)builder, (String)event.getLoggerName());
        EcsJsonSerializer.serializeLabels((StringBuilder)builder, (Map)event.getProperties(), this.topLevelLabels);
        EcsJsonSerializer.serializeTag((StringBuilder)builder, (String)event.getNDC());
        if (this.includeOrigin && (locationInformation = event.getLocationInformation()) != null) {
            EcsJsonSerializer.serializeOrigin((StringBuilder)builder, (String)locationInformation.getFileName(), (String)locationInformation.getMethodName(), (int)EcsLayout.getLineNumber(locationInformation));
        }
        if ((throwableInformation = event.getThrowableInformation()) != null) {
            EcsJsonSerializer.serializeException((StringBuilder)builder, (Throwable)throwableInformation.getThrowable(), (boolean)this.stackTraceAsArray);
        }
        EcsJsonSerializer.serializeObjectEnd((StringBuilder)builder);
        return builder.toString();
    }

    private static int getLineNumber(LocationInfo locationInformation) {
        int lineNumber = -1;
        String lineNumberString = locationInformation.getLineNumber();
        if (!"?".equals(lineNumberString)) {
            try {
                lineNumber = Integer.parseInt(lineNumberString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return lineNumber;
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setIncludeOrigin(boolean includeOrigin) {
        this.includeOrigin = includeOrigin;
    }

    public void setStackTraceAsArray(boolean stackTraceAsArray) {
        this.stackTraceAsArray = stackTraceAsArray;
    }
}

