/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.jboss.logmanager;

import co.elastic.logging.EcsJsonSerializer;
import java.util.Map;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogManager;

public class EcsFormatter
extends ExtFormatter {
    private String serviceName = this.getProperty("co.elastic.logging.jboss.logmanager.EcsFormatter.serviceName", null);
    private String eventDataset = EcsJsonSerializer.computeEventDataset((String)this.eventDataset, (String)this.serviceName);
    private boolean includeOrigin = Boolean.getBoolean(this.getProperty("co.elastic.logging.jboss.logmanager.EcsFormatter.includeOrigin", "false"));
    private boolean stackTraceAsArray = Boolean.getBoolean(this.getProperty("co.elastic.logging.jboss.logmanager.EcsFormatter.stackTraceAsArray", "false"));

    public String format(ExtLogRecord record) {
        Throwable throwable;
        StringBuilder builder = new StringBuilder();
        EcsJsonSerializer.serializeObjectStart((StringBuilder)builder, (long)record.getMillis());
        EcsJsonSerializer.serializeLogLevel((StringBuilder)builder, (String)record.getLevel().getName());
        EcsJsonSerializer.serializeFormattedMessage((StringBuilder)builder, (String)record.getFormattedMessage());
        EcsJsonSerializer.serializeServiceName((StringBuilder)builder, (String)this.serviceName);
        EcsJsonSerializer.serializeEventDataset((StringBuilder)builder, (String)this.eventDataset);
        EcsJsonSerializer.serializeThreadName((StringBuilder)builder, (String)record.getThreadName());
        EcsJsonSerializer.serializeLoggerName((StringBuilder)builder, (String)record.getLoggerName());
        EcsJsonSerializer.serializeMDC((StringBuilder)builder, (Map)record.getMdcCopy());
        String ndc = record.getNdc();
        if (ndc != null && !ndc.isEmpty()) {
            EcsJsonSerializer.serializeTagStart((StringBuilder)builder);
            for (String tag : ndc.split("\\.")) {
                EcsJsonSerializer.serializeSingleTag((StringBuilder)builder, (String)tag);
            }
            EcsJsonSerializer.serializeTagEnd((StringBuilder)builder);
        }
        if (this.includeOrigin && record.getSourceFileName() != null && record.getSourceMethodName() != null) {
            EcsJsonSerializer.serializeOrigin((StringBuilder)builder, (String)record.getSourceFileName(), (String)record.getSourceMethodName(), (int)record.getSourceLineNumber());
        }
        if ((throwable = record.getThrown()) != null) {
            EcsJsonSerializer.serializeException((StringBuilder)builder, (Throwable)throwable, (boolean)this.stackTraceAsArray);
        }
        EcsJsonSerializer.serializeObjectEnd((StringBuilder)builder);
        return builder.toString();
    }

    public void setIncludeOrigin(boolean includeOrigin) {
        this.includeOrigin = includeOrigin;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
        this.eventDataset = EcsJsonSerializer.computeEventDataset((String)this.eventDataset, (String)serviceName);
    }

    public void setStackTraceAsArray(boolean stackTraceAsArray) {
        this.stackTraceAsArray = stackTraceAsArray;
    }

    public void setEventDataset(String eventDataset) {
        this.eventDataset = eventDataset;
    }

    private String getProperty(String name, String defaultValue) {
        String value = LogManager.getLogManager().getProperty(name);
        value = value == null ? defaultValue : value.trim();
        return value;
    }
}

