/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.opentracing;

import co.elastic.apm.opentracing.TraceContextSpanContext;
import io.opentracing.Span;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ApmSpan
implements Span {
    @Nullable
    private final TraceContextSpanContext spanContext;
    @Nullable
    private Object dispatcher;

    ApmSpan(@Nullable Object dispatcher) {
        this.dispatcher = dispatcher;
        this.spanContext = new TraceContextSpanContext(this.getTraceContext(dispatcher));
    }

    ApmSpan(@Nonnull TraceContextSpanContext spanContext) {
        this.spanContext = spanContext;
    }

    @Nullable
    private Object getTraceContext(@Nullable Object dispatcher) {
        return null;
    }

    public TraceContextSpanContext context() {
        return this.spanContext;
    }

    public ApmSpan setTag(String key, String value) {
        this.handleTag(key, value);
        return this;
    }

    public ApmSpan setTag(String key, boolean value) {
        this.handleTag(key, value);
        return this;
    }

    public ApmSpan setTag(String key, Number value) {
        this.handleTag(key, value);
        return this;
    }

    public ApmSpan setOperationName(String operationName) {
        return this;
    }

    public void finish() {
        this.finish(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(long finishMicros) {
        Object traceContext;
        if (this.spanContext != null && (traceContext = this.spanContext.getTraceContext()) != null) {
            Object object = traceContext;
            synchronized (object) {
                this.finishInternal(finishMicros, traceContext);
            }
        }
    }

    private void finishInternal(long finishMicros, Object traceContext) {
    }

    @Nullable
    Object getSpan() {
        return this.dispatcher;
    }

    public ApmSpan log(String event) {
        this.log((Map)Collections.singletonMap("event", event));
        return this;
    }

    public ApmSpan log(Map<String, ?> fields) {
        return this.log(-1L, (Map)fields);
    }

    public ApmSpan log(long timestampMicroseconds, String event) {
        this.log(timestampMicroseconds, (Map)Collections.singletonMap("event", event));
        return this;
    }

    public ApmSpan log(long timestampMicroseconds, Map<String, ?> fields) {
        return this;
    }

    public ApmSpan setBaggageItem(String key, String value) {
        return this;
    }

    @Nullable
    public String getBaggageItem(String key) {
        for (Map.Entry<String, String> baggage : this.context().baggageItems()) {
            if (!baggage.getKey().equals(key)) continue;
            return baggage.getValue();
        }
        return null;
    }

    private void handleTag(String key, @Nullable Object value) {
    }

    public String toString() {
        return String.valueOf(this.dispatcher);
    }
}

