/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.opentracing;

import co.elastic.apm.opentracing.ApmScope;
import co.elastic.apm.opentracing.ApmScopeManager;
import co.elastic.apm.opentracing.ApmSpan;
import co.elastic.apm.opentracing.ApmSpanBuilder;
import co.elastic.apm.opentracing.ExternalProcessSpanContext;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ElasticApmTracer
implements Tracer {
    private final ApmScopeManager scopeManager = new ApmScopeManager();

    public ApmScopeManager scopeManager() {
        return this.scopeManager;
    }

    @Nullable
    public ApmSpan activeSpan() {
        ApmScope active = this.scopeManager().active();
        if (active != null) {
            return active.span();
        }
        return null;
    }

    public ApmSpanBuilder buildSpan(String operationName) {
        return new ApmSpanBuilder(operationName, this.scopeManager());
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        if (format == Format.Builtin.HTTP_HEADERS || format == Format.Builtin.TEXT_MAP) {
            TextMap textMap = (TextMap)carrier;
            for (Map.Entry baggageItem : spanContext.baggageItems()) {
                textMap.put((String)baggageItem.getKey(), (String)baggageItem.getValue());
            }
        }
    }

    @Nullable
    public <C> SpanContext extract(Format<C> format, C carrier) {
        if (format == Format.Builtin.HTTP_HEADERS || format == Format.Builtin.TEXT_MAP) {
            TextMap textMap = (TextMap)carrier;
            return ExternalProcessSpanContext.of(textMap);
        }
        return null;
    }
}

