/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.opentracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

class ApmSpan
implements Span,
SpanContext {
    @Nullable
    private final Object transaction;
    @Nullable
    private final Object span;

    ApmSpan(@Nullable Object transaction, @Nullable Object span) {
        this.transaction = transaction;
        this.span = span;
    }

    public SpanContext context() {
        return this;
    }

    public ApmSpan setTag(String key, String value) {
        this.handleTag(key, value);
        return this;
    }

    public ApmSpan setTag(String key, boolean value) {
        this.handleTag(key, value);
        return this;
    }

    public ApmSpan setTag(String key, Number value) {
        this.handleTag(key, value);
        return this;
    }

    public ApmSpan setOperationName(String operationName) {
        return this;
    }

    public void finish() {
        this.finishInternal(System.nanoTime() / 1000L);
    }

    public void finish(long finishMicros) {
        this.finishInternal(finishMicros);
    }

    private void finishInternal(long finishMicros) {
    }

    @Nullable
    Object getSpan() {
        return this.span;
    }

    @Nullable
    Object getTransaction() {
        return this.transaction;
    }

    public ApmSpan log(Map<String, ?> fields) {
        if ("error".equals(fields.get("event"))) {
            this.createError(System.currentTimeMillis(), fields);
        }
        return this;
    }

    public ApmSpan log(long timestampMicroseconds, Map<String, ?> fields) {
        if ("error".equals(fields.get("event"))) {
            this.createError(timestampMicroseconds / 1000L, fields);
        }
        return this;
    }

    private void createError(long epochTimestampMillis, Map<String, ?> fields) {
    }

    public ApmSpan log(String event) {
        this.log((Map)Collections.singletonMap("event", event));
        return this;
    }

    public ApmSpan log(long timestampMicroseconds, String event) {
        this.log(timestampMicroseconds, (Map)Collections.singletonMap("event", event));
        return this;
    }

    public ApmSpan setBaggageItem(String key, String value) {
        return this;
    }

    @Nullable
    public String getBaggageItem(String key) {
        for (Map.Entry<String, String> baggage : this.baggageItems()) {
            if (!baggage.getKey().equals(key)) continue;
            return baggage.getValue();
        }
        return null;
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return Collections.emptyList();
    }

    private void handleTag(String key, @Nullable Object value) {
    }
}

