package co.datadome.api.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataDomeEnvironment {

    private DataDomeEnvironment() {
        throw new IllegalStateException("Utility class");
    }

    private static final Logger logger = Logger
            .getLogger(DataDomeEnvironment.class.getCanonicalName());

    private static final String UNKNOWN = "unknown";

    private static String moduleName = "java";

    private static String moduleVersion = UNKNOWN;

    private static String vertxWebVersion = UNKNOWN;

    private static String serverName;

    static {
        try {
            Properties properties = new Properties();

            properties.load(DataDomeRequest.class.getResourceAsStream("project.properties"));
            moduleVersion = properties.getProperty("version");
            vertxWebVersion = properties.getProperty("vertxweb-version");
        } catch (Exception e) {
            logger.log(Level.INFO,
                    "Can't load from version file from resources, using " + moduleVersion, e);
        }

        serverName = getHostname();
    }

    public static String getHostname() {
        try {
            String envHostname = getEnvironementHostname();
            if (envHostname != null && !envHostname.isEmpty()) {
                return envHostname;
            }

            return getHostnameOverLocalInterface();
        } catch (Exception e) {
            return getHostnameOverLocalInterface();
        }
    }

    private static String getEnvironementHostname(){
        if (System.getProperty("os.name") != null && System.getProperty("os.name").startsWith("Windows")) {
            return System.getenv("COMPUTERNAME");
        }

        return System.getenv("HOSTNAME");
    }


    private static String getHostnameOverLocalInterface() {
        try {
            logger.log(Level.INFO, "Can't load hostname, trying lookup it over local interface...");
            return InetAddress.getLocalHost().getHostName();
        } catch (UnknownHostException e) {
            logger.log(Level.WARNING, "Can't get hostname, using " + serverName, e);
        }

        return UNKNOWN;

    }


    public static String getModuleName() {
        return moduleName;
    }

    public static String getModuleVersion() {
        return moduleVersion;
    }

    public static String getServerName() {
        return serverName;
    }

    public static String getVertxWebVersion(){
        return vertxWebVersion;
    }

    public static void setServerInfo(String serverInfo) {
        if (serverInfo != null) {
            moduleName = moduleName + "/" + serverInfo;
        }
    }
}
