package co.datadome.api.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataDomeEnvironment {

    private static final Logger logger = Logger
        .getLogger(DataDomeEnvironment.class.getSimpleName());

    private static final String UNKNOWN = "unknown";

    private static String moduleName = "java";

    private static String moduleVersion = "unknown";

    private static String serverName = "unknown";

    static {
        try {
            Properties properties = new Properties();

            properties.load(DataDomeRequest.class.getResourceAsStream("project.properties"));
            moduleVersion = properties.getProperty("version");
        } catch (Exception e) {
            logger.log(Level.INFO,
                "Can't load from version file from resources, using " + moduleVersion, e);
        }

        serverName = getHostname();
    }

    public static String getHostname() {
        String hostname = UNKNOWN;
        try {

            if (System.getProperty("os.name") != null && System.getProperty("os.name")
                .startsWith("Windows")) {
                hostname = System.getenv("COMPUTERNAME");
            } else {
                hostname = System.getenv("HOSTNAME");
            }
            if (hostname == null || "".equals(hostname)) {
                hostname = getHostnameOverLocalInterface();
            }

        } catch (Exception e) {
            hostname = getHostnameOverLocalInterface();
        }
        return hostname;
    }


    private static String getHostnameOverLocalInterface() {
        try {
            logger.log(Level.INFO, "Can't load hostname, trying lookup it over local interface...");
            return InetAddress.getLocalHost().getHostName();
        } catch (UnknownHostException e) {
            logger.log(Level.WARNING, "Can't get hostname, using " + serverName, e);
        }

        return UNKNOWN;

    }


    public static String getModuleName() {
        return moduleName;
    }

    public static String getModuleVersion() {
        return moduleVersion;
    }

    public static String getServerName() {
        return serverName;
    }

    public static void setServerInfo(String serverInfo) {
        if (serverInfo != null) {
            moduleName = moduleName + "/" + serverInfo;
        }
    }
}
