package co.datadome.api.common;

/**
 * Contains details about the DataDomeRequest request
 *
 * <p>
 * Example:
 * <pre>
 * {@code
 * DataDomeRequest.Builder builder = DataDomeRequest.newBuilder();
 * builder.setIp("127.0.0.1");
 * builder.setMethod("GET");
 * builder.setProtocol("HTTPS");
 * ...
 * DataDomeRequest dataDomeRequest = builder.build();
 * }
 * </pre>
 *
 */
public class DataDomeRequest {

	private final String userAgent;

	private final String ip;

	private final String port;

	private final String clientID;

	private final String host;

	private final String referer;

	private final String request;

	private final String uri;

	private final String protocol;

	private final String method;

	private final String cookiesLen;

	private final String timeRequest;

	private final String serverHostname;

private final String postParamLen;

	private final String xForwaredForIP;

	private final String headersList;

	private final String authorizationLen;

	private final String xRequestedWith;

	private final String origin;

	private final String connection;

	private final String pragma;

	private final String cacheControl;

	private final String accept;

	private final String acceptCharset;

	private final String acceptEncoding;

	private final String acceptLanguage;

	private DataDomeRequest(String userAgent, String ip, String port, String clientID, String host, String referer, String request, String uri, String protocol, String method, String cookiesLen, String timeRequest, String serverHostname, String postParamLen, String xForwaredForIP, String headersList, String authorizationLen, String xRequestedWith, String origin, String connection, String pragma, String cacheControl, String accept, String acceptCharset, String acceptEncoding, String acceptLanguage) {
		this.userAgent = userAgent;
		this.ip = ip;
		this.port = port;
		this.clientID = clientID;
		this.host = host;
		this.referer = referer;
		this.request = request;
		this.uri = uri;
		this.protocol = protocol;
		this.method = method;
		this.cookiesLen = cookiesLen;
		this.timeRequest = timeRequest;
		this.serverHostname = serverHostname;
		this.postParamLen = postParamLen;
		this.xForwaredForIP = xForwaredForIP;
		this.headersList = headersList;
		this.authorizationLen = authorizationLen;
		this.xRequestedWith = xRequestedWith;
		this.origin = origin;
		this.connection = connection;
		this.pragma = pragma;
		this.cacheControl = cacheControl;
		this.accept = accept;
		this.acceptCharset = acceptCharset;
		this.acceptEncoding = acceptEncoding;
		this.acceptLanguage = acceptLanguage;
	}

	public String getUserAgent() {
		return userAgent;
	}

	public String getIp() {
		return ip;
	}

	public String getPort() {
		return port;
	}

	public String getClientID() {
		return clientID;
	}

	public String getHost() {
		return host;
	}

	public String getReferer() {
		return referer;
	}

	public String getRequest() {
		return request;
	}

	public String getUri() {
		return uri;
	}

	public String getProtocol() {
		return protocol;
	}

	public String getMethod() {
		return method;
	}

	public String getCookiesLen() {
		return cookiesLen;
	}

	public String getTimeRequest() {
		return timeRequest;
	}

	public String getServerHostname() {
		return serverHostname;
	}

	public String getPostParamLen() {
		return postParamLen;
	}

	public String getxForwaredForIP() {
		return xForwaredForIP;
	}

	public String getHeadersList() {
		return headersList;
	}

	public String getAuthorizationLen() {
		return authorizationLen;
	}

	public String getxRequestedWith() {
		return xRequestedWith;
	}

	public String getOrigin() {
		return origin;
	}

	public String getConnection() {
		return connection;
	}

	public String getPragma() {
		return pragma;
	}

	public String getCacheControl() {
		return cacheControl;
	}

	public String getAccept() {
		return accept;
	}

	public String getAcceptCharset() {
		return acceptCharset;
	}

	public String getAcceptEncoding() {
		return acceptEncoding;
	}

	public String getAcceptLanguage() {
		return acceptLanguage;
	}

	public static Builder newBuilder() {
		return new Builder();
	}

	public static class Builder {
		private String userAgent;
		private String ip;
		private String port;
		private String clientID;
		private String host;
		private String referer;
		private String request;
		private String uri;
		private String protocol;
		private String method;
		private String cookiesLen;
		private String timeRequest;
		private String serverHostname;
		private String postParamLen;
		private String xForwaredForIP;
		private String headersList;
		private String authorizationLen;
		private String xRequestedWith;
		private String origin;
		private String connection;
		private String pragma;
		private String cacheControl;
		private String accept;
		private String acceptCharset;
		private String acceptEncoding;
		private String acceptLanguage;

		public Builder setUserAgent(String userAgent) {
			this.userAgent = userAgent;
			return this;
		}

		public Builder setIp(String ip) {
			this.ip = ip;
			return this;
		}

		public Builder setPort(String port) {
			this.port = port;
			return this;
		}

		public Builder setClientID(String clientID) {
			this.clientID = clientID;
			return this;
		}

		public Builder setHost(String host) {
			this.host = host;
			return this;
		}

		public Builder setReferer(String referer) {
			this.referer = referer;
			return this;
		}

		public Builder setRequest(String request) {
			this.request = request;
			return this;
		}

		public Builder setUri(String uri) {
			this.uri = uri;
			return this;
		}

		public Builder setProtocol(String protocol) {
			this.protocol = protocol;
			return this;
		}

		public Builder setMethod(String method) {
			this.method = method;
			return this;
		}

		public Builder setCookiesLen(String cookiesLen) {
			this.cookiesLen = cookiesLen;
			return this;
		}

		public Builder setTimeRequest(String timeRequest) {
			this.timeRequest = timeRequest;
			return this;
		}

		public Builder setServerHostname(String serverHostname) {
			this.serverHostname = serverHostname;
			return this;
		}

		public Builder setPostParamLen(String postParamLen) {
			this.postParamLen = postParamLen;
			return this;
		}

		public Builder setForwaredForIP(String xForwaredForIP) {
			this.xForwaredForIP = xForwaredForIP;
			return this;
		}

		public Builder setHeadersList(String headersList) {
			this.headersList = headersList;
			return this;
		}

		public Builder setAuthorizationLen(String authorizationLen) {
			this.authorizationLen = authorizationLen;
			return this;
		}

		public Builder setxRequestedWith(String xRequestedWith) {
			this.xRequestedWith = xRequestedWith;
			return this;
		}

		public Builder setOrigin(String origin) {
			this.origin = origin;
			return this;
		}

		public Builder setConnection(String connection) {
			this.connection = connection;
			return this;
		}

		public Builder setPragma(String pragma) {
			this.pragma = pragma;
			return this;
		}

		public Builder setCacheControl(String cacheControl) {
			this.cacheControl = cacheControl;
			return this;
		}

		public Builder setAccept(String accept) {
			this.accept = accept;
			return this;
		}

		public Builder setAcceptCharset(String acceptCharset) {
			this.acceptCharset = acceptCharset;
			return this;
		}

		public Builder setAcceptEncoding(String acceptEncoding) {
			this.acceptEncoding = acceptEncoding;
			return this;
		}

		public Builder setAcceptLanguage(String acceptLanguage) {
			this.acceptLanguage = acceptLanguage;
			return this;
		}

		public DataDomeRequest build() {
			return new DataDomeRequest(userAgent, ip, port, clientID, host, referer, request, uri, protocol, method, cookiesLen, timeRequest, serverHostname, postParamLen, xForwaredForIP, headersList, authorizationLen, xRequestedWith, origin, connection, pragma, cacheControl, accept, acceptCharset, acceptEncoding, acceptLanguage);
		}
	}
}
