package co.datadome.api.common;

import com.sun.jna.Library;
import com.sun.jna.Native;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataDomeEnvironment {
    private static final Logger logger = Logger.getLogger(DataDomeEnvironment.class.getSimpleName());

    private static String moduleName = "java";

    private static String moduleVersion = "unknown";

    private static String serverName = "unknown";

    static {
        try {
            Properties properties = new Properties();

            properties.load(DataDomeRequest.class.getResourceAsStream("project.properties"));
            moduleVersion = properties.getProperty("version");

            serverName = getHostname();

        } catch (Exception e) {
            logger.log(Level.SEVERE, "Can't load from resources", e);
        }
    }

    private interface UnixCLibrary extends Library {
        UnixCLibrary INSTANCE = (UnixCLibrary) Native.loadLibrary("c", UnixCLibrary.class);
        int gethostname(byte[] hostname, int bufferSize);
    }

    private static String getHostname() {
        byte[] hostnameBuffer = new byte[4097];
        // http://pubs.opengroup.org/onlinepubs/9699919799/basedefs/limits.h.html suggests
        // the actual limit would be 255.

        int result = UnixCLibrary.INSTANCE.gethostname(hostnameBuffer, hostnameBuffer.length);
        if (result != 0) {
            throw new RuntimeException("gethostname call failed");
        }

        return Native.toString(hostnameBuffer);
    }

    public static String getModuleName() {
        return moduleName;
    }

    public static String getModuleVersion() {
        return moduleVersion;
    }

    public static String getServerName() {
        return serverName;
    }

    public static void setServerInfo(String serverInfo) {
        if (serverInfo != null) {
            moduleName = moduleName + "/" + serverInfo;
        }
    }
}
