/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.infraestructure.handle;

import co.com.sofka.business.asyn.UseCaseExecutor;
import co.com.sofka.infraestructure.handle.CommandHandler;
import co.com.sofka.infraestructure.handle.ExecutionNoFound;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Logger;

public abstract class CommandExecutor
implements CommandHandler<Map<String, String>> {
    private static Logger logger = Logger.getLogger(CommandExecutor.class.getName());
    protected Map<String, Consumer<Map<String, String>>> handles = new ConcurrentHashMap<String, Consumer<Map<String, String>>>();

    protected void put(String type, Consumer<Map<String, String>> consumer) {
        this.handles.put(type, consumer);
    }

    @Override
    public final void execute(Map<String, String> args) {
        logger.info("####### Executor Command #######");
        String type = args.getOrDefault("type", null);
        if (!this.handles.containsKey(type)) {
            throw new ExecutionNoFound(type);
        }
        Consumer<Map<String, String>> consumer = this.handles.get(type);
        if (args.containsKey("aggregateId")) {
            ((UseCaseExecutor)consumer).withAggregateId(args.get("aggregateId"));
        }
        if (args.containsKey("aggregateRootId")) {
            ((UseCaseExecutor)consumer).withAggregateId(args.get("aggregateRootId"));
        }
        consumer.accept(args);
    }
}

