/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.infraestructure;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;

public abstract class AbstractSerializer {
    protected Gson gson = new GsonBuilder().registerTypeAdapter(Instant.class, (Object)new DateSerializer()).registerTypeAdapter(Instant.class, (Object)new DateDeserializer()).serializeNulls().create();

    protected AbstractSerializer() {
    }

    private static class DateSerializer
    implements JsonSerializer<Instant> {
        private DateSerializer() {
        }

        public JsonElement serialize(Instant source, Type typeOfSource, JsonSerializationContext context) {
            return new JsonPrimitive(Long.toString(source.toEpochMilli()));
        }
    }

    private static class DateDeserializer
    implements JsonDeserializer<Instant> {
        private DateDeserializer() {
        }

        public Instant deserialize(JsonElement json, Type typeOfTarget, JsonDeserializationContext context) {
            long time = Long.parseLong(json.getAsJsonPrimitive().getAsString());
            return Instant.ofEpochMilli(time);
        }
    }
}

