/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.domain.generic;

import co.com.sofka.domain.generic.DomainEvent;
import co.com.sofka.domain.generic.EventChange;
import co.com.sofka.domain.generic.Incremental;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class ChangeEventSubscriber {
    private final List<DomainEvent> changes = new LinkedList<DomainEvent>();
    private final Map<String, AtomicLong> versions = new ConcurrentHashMap<String, AtomicLong>();
    private final Set<Consumer<? super DomainEvent>> observables = new HashSet<Consumer<? super DomainEvent>>();

    public List<DomainEvent> getChanges() {
        return this.changes;
    }

    public final ChangeApply appendChange(DomainEvent event) {
        this.changes.add(event);
        return () -> this.applyEvent(event);
    }

    public final void subscribe(EventChange eventChange) {
        this.observables.addAll(eventChange.behaviors);
    }

    public final void applyEvent(DomainEvent domainEvent) {
        this.observables.forEach(consumer -> {
            try {
                consumer.accept(domainEvent);
                if (domainEvent instanceof Incremental) {
                    AtomicLong map = this.versions.get(domainEvent.type);
                    long version = this.nextVersion(domainEvent, map);
                    domainEvent.setVersionType(version);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        });
    }

    private long nextVersion(DomainEvent domainEvent, AtomicLong map) {
        if (map == null) {
            this.versions.put(domainEvent.type, new AtomicLong(domainEvent.versionType()));
            return domainEvent.versionType();
        }
        return this.versions.get(domainEvent.type).incrementAndGet();
    }

    @FunctionalInterface
    public static interface ChangeApply {
        public void apply();
    }
}

