/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.domain.generic;

import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;

public abstract class DomainEvent
implements Serializable {
    public final Instant when;
    public final UUID uuid;
    public final String type;
    private String aggregateRootId;
    private String aggregate;
    private Long versionType;

    public DomainEvent(String type, String aggregateRootId) {
        this.type = type;
        this.aggregateRootId = aggregateRootId;
        this.aggregate = "default";
        this.when = Instant.now();
        this.uuid = UUID.randomUUID();
        this.versionType = 1L;
    }

    public DomainEvent(String type) {
        this(type, null);
    }

    public Long versionType() {
        return this.versionType;
    }

    public void setVersionType(Long versionType) {
        this.versionType = versionType;
    }

    public String aggregateRootId() {
        return this.aggregateRootId;
    }

    public void setAggregateRootId(String aggregateRootId) {
        this.aggregateRootId = Objects.requireNonNull(aggregateRootId, "The aggregateRootId cannot be a value null");
    }

    public String getAggregateName() {
        return this.aggregate;
    }

    public void setAggregateName(String aggregate) {
        this.aggregate = aggregate;
    }
}

