/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.domain.generic;

import co.com.sofka.domain.generic.AggregateRoot;
import co.com.sofka.domain.generic.ChangeEventSubscriber;
import co.com.sofka.domain.generic.DomainEvent;
import co.com.sofka.domain.generic.EventChange;
import co.com.sofka.domain.generic.Identity;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class AggregateEvent<T extends Identity>
extends AggregateRoot<T> {
    private final ChangeEventSubscriber changeEventSubscriber = new ChangeEventSubscriber();

    public AggregateEvent(T entityId) {
        super(entityId);
    }

    public List<DomainEvent> getUncommittedChanges() {
        return List.copyOf(this.changeEventSubscriber.getChanges());
    }

    protected ChangeEventSubscriber.ChangeApply appendChange(DomainEvent event) {
        String nameClass = this.entityId.getClass().getSimpleName();
        String aggregate = nameClass.replaceAll("(Identity|Id)", "").toLowerCase();
        event.setAggregateName(aggregate);
        event.setAggregateRootId(this.entityId.value());
        return this.changeEventSubscriber.appendChange(event);
    }

    protected final void subscribe(EventChange eventChange) {
        this.changeEventSubscriber.subscribe(eventChange);
    }

    protected void applyEvent(DomainEvent domainEvent) {
        this.changeEventSubscriber.applyEvent(domainEvent);
    }

    public void markChangesAsCommitted() {
        this.changeEventSubscriber.getChanges().clear();
    }

    public void refundEvent() {
        this.changeEventSubscriber.getChanges().clear();
    }

    public <E extends DomainEvent> Optional<E> findEventUncommitted(Class<E> event) {
        return this.changeEventSubscriber.getChanges().stream().filter(event::isInstance).map(e -> e).findFirst();
    }

    public <E extends DomainEvent> Stream<E> findAllEventUncommitted(Class<E> event) {
        return this.changeEventSubscriber.getChanges().stream().filter(event::isInstance).map(e -> e);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

