/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.domain.generic;

import co.com.sofka.domain.generic.AggregateRoot;
import co.com.sofka.domain.generic.BehaviorSubscriber;
import co.com.sofka.domain.generic.DomainEvent;
import co.com.sofka.domain.generic.EventBehavior;
import co.com.sofka.domain.generic.Identity;
import java.util.List;

public abstract class AggregateEvent<T extends Identity>
extends AggregateRoot<T> {
    private final BehaviorSubscriber behaviorSubscriber = new BehaviorSubscriber();

    public AggregateEvent(T entityId) {
        super(entityId);
    }

    public List<DomainEvent> getUncommittedChanges() {
        return List.copyOf(this.behaviorSubscriber.getChanges());
    }

    protected BehaviorSubscriber.ChangeApply appendChange(DomainEvent event) {
        String nameClass = this.entityId.getClass().getSimpleName();
        String aggregate = nameClass.replaceAll("(Identity|Id)", "").toLowerCase();
        event.setAggregateName(aggregate);
        event.setAggregateRootId(this.entityId.value());
        return this.behaviorSubscriber.appendChange(event);
    }

    protected final void subscribe(EventBehavior eventBehavior) {
        this.behaviorSubscriber.subscribe(eventBehavior);
    }

    protected void applyEvent(DomainEvent domainEvent) {
        this.behaviorSubscriber.applyEvent(domainEvent);
    }

    public void markChangesAsCommitted() {
        this.behaviorSubscriber.getChanges().clear();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

