/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.domain.generic;

import co.com.sofka.domain.generic.ValueObject;
import java.util.Objects;
import java.util.UUID;

public class Identity
implements ValueObject<String> {
    private final String uuid;

    public Identity(String uuid) {
        this.uuid = Objects.requireNonNull(uuid, "Identity can\u00b4t be null");
    }

    public Identity() {
        this.uuid = this.generateUUID().toString();
    }

    public UUID generateUUID() {
        return UUID.randomUUID();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Identity identity = (Identity)object;
        return Objects.equals(this.uuid, identity.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    @Override
    public String value() {
        return this.uuid;
    }
}

